/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import java.util.List;

public interface ReadOnlyLogMetadata {
    public long getEpoch();

    public int getUpdateVersion();

    public boolean isEnabled();

    public List<LedgerMetadata> getLedgers();

    public LedgerAddress getTruncationAddress();

    default public boolean equals(ReadOnlyLogMetadata other) {
        if (other == null) {
            return false;
        }
        List<LedgerMetadata> ledgers = this.getLedgers();
        List<LedgerMetadata> otherLedgers = other.getLedgers();
        if (this.isEnabled() != other.isEnabled() || this.getEpoch() != other.getEpoch() || !this.getTruncationAddress().equals(other.getTruncationAddress()) || ledgers.size() != otherLedgers.size()) {
            return false;
        }
        for (int i = 0; i < ledgers.size(); ++i) {
            if (ledgers.get(i).equals(otherLedgers.get(i))) continue;
            return false;
        }
        return true;
    }
}

