/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.segmentstore.storage.impl.bookkeeper.Write;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
class WriteQueue {
    private final Supplier<Long> timeSupplier;
    @GuardedBy(value="this")
    private final Deque<Write> writes;
    @GuardedBy(value="this")
    private long totalLength;
    @GuardedBy(value="this")
    private boolean closed;
    private final AtomicReference<QueueStats> stats;

    WriteQueue() {
        this(System::nanoTime);
    }

    @VisibleForTesting
    WriteQueue(Supplier<Long> timeSupplier) {
        this.timeSupplier = (Supplier)Preconditions.checkNotNull(timeSupplier, (Object)"timeSupplier");
        this.writes = new ArrayDeque<Write>();
        this.stats = new AtomicReference<QueueStats>(new QueueStats(0, 0L, 1047552, 0));
    }

    QueueStats getStatistics() {
        return this.stats.get();
    }

    @GuardedBy(value="this")
    private void updateStats(long lastDurationMillis) {
        if (lastDurationMillis == 0L && this.writes.size() > 0) {
            lastDurationMillis = (int)((this.timeSupplier.get() - this.writes.peekFirst().getQueueAddedTimestamp()) / 1000000L);
        }
        this.stats.set(new QueueStats(this.writes.size(), this.totalLength, 1047552, (int)lastDurationMillis));
    }

    synchronized void add(Write write) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        this.writes.addLast(write);
        this.totalLength += (long)write.getLength();
        write.setQueueAddedTimestamp(this.timeSupplier.get());
    }

    synchronized List<Write> close() {
        ArrayList<Write> items = new ArrayList<Write>(this.writes);
        this.writes.clear();
        this.totalLength = 0L;
        this.closed = true;
        return items;
    }

    synchronized List<Write> getWritesToExecute(long maximumAccumulatedSize) {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        long accumulatedSize = 0L;
        long firstLedgerId = this.writes.peekFirst().getWriteLedger().metadata.getLedgerId();
        boolean canSkip = true;
        ArrayList<Write> result = new ArrayList<Write>();
        for (Write write : this.writes) {
            if (accumulatedSize >= maximumAccumulatedSize) break;
            accumulatedSize += (long)write.getLength();
            if (write.isInProgress()) {
                if (canSkip) continue;
                return Collections.emptyList();
            }
            if (write.getWriteLedger().metadata.getLedgerId() != firstLedgerId) break;
            if (write.isDone()) continue;
            canSkip = false;
            result.add(write);
        }
        return result;
    }

    synchronized CleanupResult removeFinishedWrites() {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        long currentTime = this.timeSupplier.get();
        long totalElapsed = 0L;
        int removedCount = 0;
        boolean failedWrite = false;
        while (!this.writes.isEmpty() && this.writes.peekFirst().isDone()) {
            Write w = this.writes.removeFirst();
            this.totalLength = Math.max(0L, this.totalLength - (long)w.getLength());
            ++removedCount;
            totalElapsed += currentTime - w.getQueueAddedTimestamp();
            failedWrite |= w.getFailureCause() != null;
        }
        long lastDurationMillis = removedCount == 0 ? 0L : (long)((int)(totalElapsed / (long)removedCount / 1000000L));
        this.updateStats(lastDurationMillis);
        CleanupStatus status = failedWrite ? CleanupStatus.WriteFailed : (this.writes.isEmpty() ? CleanupStatus.QueueEmpty : CleanupStatus.QueueNotEmpty);
        return new CleanupResult(status, removedCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<Long> getTimeSupplier() {
        return this.timeSupplier;
    }

    static enum CleanupStatus {
        QueueEmpty,
        QueueNotEmpty,
        WriteFailed;

    }

    static class CleanupResult {
        private final CleanupStatus status;
        private final int removedCount;

        @ConstructorProperties(value={"status", "removedCount"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CleanupResult(CleanupStatus status, int removedCount) {
            this.status = status;
            this.removedCount = removedCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CleanupStatus getStatus() {
            return this.status;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getRemovedCount() {
            return this.removedCount;
        }
    }
}

