/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.rest;

import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.security.JKSHelper;
import io.pravega.shared.rest.CustomObjectMapperProvider;
import io.pravega.shared.rest.RESTApplication;
import io.pravega.shared.rest.RESTServerConfig;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Application;
import lombok.Generated;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServer
extends AbstractIdleService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RESTServer.class);
    private final String objectId;
    private final RESTServerConfig restServerConfig;
    private final URI baseUri;
    private final ResourceConfig resourceConfig;
    private HttpServer httpServer;

    public RESTServer(RESTServerConfig restServerConfig, Set<Object> resources) {
        this.objectId = "RESTServer";
        this.restServerConfig = restServerConfig;
        String serverURI = "http://" + restServerConfig.getHost();
        this.baseUri = URI.create(serverURI + ":" + restServerConfig.getPort() + "/");
        RESTApplication application = new RESTApplication(resources);
        this.resourceConfig = ResourceConfig.forApplication((Application)application);
        this.resourceConfig.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        this.resourceConfig.register((Object)new CustomObjectMapperProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startUp", (Object[])new Object[0]);
        try {
            log.info("Starting REST server listening on port: {}", (Object)this.restServerConfig.getPort());
            if (this.restServerConfig.isTlsEnabled()) {
                SSLContextConfigurator contextConfigurator = new SSLContextConfigurator();
                contextConfigurator.setKeyStoreFile(this.restServerConfig.getKeyFilePath());
                contextConfigurator.setKeyStorePass(JKSHelper.loadPasswordFrom((String)this.restServerConfig.getKeyFilePasswordPath()));
                this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)this.resourceConfig, (boolean)true, (SSLEngineConfigurator)new SSLEngineConfigurator(contextConfigurator, false, false, false).setEnabledProtocols(this.restServerConfig.tlsProtocolVersion()));
            } else {
                this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)this.resourceConfig, (boolean)true);
            }
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws Exception {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"shutDown", (Object[])new Object[0]);
        try {
            log.info("Stopping REST server listening on port: {}", (Object)this.restServerConfig.getPort());
            GrizzlyFuture shutdown = this.httpServer.shutdown(30L, TimeUnit.SECONDS);
            log.info("Awaiting termination of REST server");
            shutdown.get();
            log.info("REST server terminated");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
        }
    }
}

