/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.rest.impl;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.shared.rest.RESTServerConfig;
import java.util.Arrays;
import java.util.Properties;
import lombok.Generated;

public class RESTServerConfigImpl
implements RESTServerConfig {
    private final String host;
    private final int port;
    private final boolean authorizationEnabled;
    private final String userPasswordFile;
    private final boolean tlsEnabled;
    private final String[] tlsProtocolVersion;
    private final String keyFilePath;
    private final String keyFilePasswordPath;

    RESTServerConfigImpl(String host, int port, boolean authorizationEnabled, String userPasswordFile, boolean tlsEnabled, String[] tlsProtocolVersion, String keyFilePath, String keyFilePasswordPath) {
        Exceptions.checkNotNullOrEmpty((String)host, (String)"host");
        Exceptions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port", (String)"Should be positive integer", (Object[])new Object[0]);
        Exceptions.checkArgument((!tlsEnabled || !Strings.isNullOrEmpty((String)keyFilePath) ? 1 : 0) != 0, (String)"TLS", (String)"KeyFilePath should not be empty when TLS is enabled. ", (Object[])new Object[0]);
        this.host = host;
        this.port = port;
        this.tlsEnabled = tlsEnabled;
        this.tlsProtocolVersion = Arrays.copyOf(tlsProtocolVersion, tlsProtocolVersion.length);
        this.keyFilePath = keyFilePath;
        this.keyFilePasswordPath = keyFilePasswordPath;
        this.authorizationEnabled = authorizationEnabled;
        this.userPasswordFile = userPasswordFile;
    }

    public String toString() {
        return String.format("%s(", this.getClass().getSimpleName()) + String.format("host: %s, ", this.host) + String.format("port: %d, ", this.port) + String.format("tlsEnabled: %b, ", this.tlsEnabled) + String.format("tlsProtocolVersion: %s, ", Arrays.toString(this.tlsProtocolVersion)) + String.format("keyFilePath is %s, ", Strings.isNullOrEmpty((String)this.keyFilePath) ? "unspecified" : "specified") + String.format("keyFilePasswordPath is %s", Strings.isNullOrEmpty((String)this.keyFilePasswordPath) ? "unspecified" : "specified") + String.format("authorizationEnabled: %b, ", this.authorizationEnabled) + String.format("userPasswordFile is %s, ", Strings.isNullOrEmpty((String)this.userPasswordFile) ? "unspecified" : "specified") + ")";
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    @Override
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Override
    public String[] tlsProtocolVersion() {
        return Arrays.copyOf(this.tlsProtocolVersion, this.tlsProtocolVersion.length);
    }

    public Properties toAuthHandlerProperties() {
        Properties props = new Properties();
        if (this.userPasswordFile != null) {
            props.setProperty("basic.authplugin.dbfile", this.userPasswordFile);
        }
        return props;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static RESTServerConfigImplBuilder builder() {
        return new RESTServerConfigImplBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getHost() {
        return this.host;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPort() {
        return this.port;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUserPasswordFile() {
        return this.userPasswordFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getTlsProtocolVersion() {
        return this.tlsProtocolVersion;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyFilePasswordPath() {
        return this.keyFilePasswordPath;
    }

    public static final class RESTServerConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String host;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int port;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean authorizationEnabled;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String userPasswordFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean tlsEnabled;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyFilePath;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyFilePasswordPath;
        private String[] tlsProtocolVersion = new String[]{"TLSv1.2", "TLSv1.3"};

        public RESTServerConfigImpl build() {
            return new RESTServerConfigImpl(this.host, this.port, this.authorizationEnabled, this.userPasswordFile, this.tlsEnabled, this.tlsProtocolVersion, this.keyFilePath, this.keyFilePasswordPath);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        RESTServerConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder host(String host) {
            this.host = host;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder port(int port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder authorizationEnabled(boolean authorizationEnabled) {
            this.authorizationEnabled = authorizationEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder userPasswordFile(String userPasswordFile) {
            this.userPasswordFile = userPasswordFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder tlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder tlsProtocolVersion(String[] tlsProtocolVersion) {
            this.tlsProtocolVersion = tlsProtocolVersion;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder keyFilePath(String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RESTServerConfigImplBuilder keyFilePasswordPath(String keyFilePasswordPath) {
            this.keyFilePasswordPath = keyFilePasswordPath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "RESTServerConfigImpl.RESTServerConfigImplBuilder(host=" + this.host + ", port=" + this.port + ", authorizationEnabled=" + this.authorizationEnabled + ", userPasswordFile=" + this.userPasswordFile + ", tlsEnabled=" + this.tlsEnabled + ", tlsProtocolVersion=" + Arrays.deepToString(this.tlsProtocolVersion) + ", keyFilePath=" + this.keyFilePath + ", keyFilePasswordPath=" + this.keyFilePasswordPath + ")";
        }
    }
}

