/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.rest.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.AuthorizationException;
import io.pravega.shared.rest.security.AuthHandlerManager;
import java.security.Principal;
import java.util.List;
import javax.ws.rs.core.Response;

public class RESTAuthHelper {
    private final AuthHandlerManager pravegaAuthManager;

    public RESTAuthHelper(AuthHandlerManager pravegaAuthManager) {
        this.pravegaAuthManager = pravegaAuthManager;
    }

    public boolean isAuthorized(List<String> authHeader, String resource, Principal principal, AuthHandler.Permissions permission) throws AuthException {
        if (this.isAuthEnabled()) {
            return this.pravegaAuthManager.authorize(resource, principal, this.parseCredentials(authHeader), permission);
        }
        return true;
    }

    public void authorize(List<String> authHeader, String resource, Principal principal, AuthHandler.Permissions permission) throws AuthException {
        if (!this.isAuthorized(authHeader, resource, principal, permission)) {
            throw new AuthorizationException(String.format("Failed to authorize for resource [%s]", resource), Response.Status.FORBIDDEN.getStatusCode());
        }
    }

    public Principal authenticate(List<String> authHeader) throws AuthException {
        if (this.isAuthEnabled()) {
            String credentials = this.parseCredentials(authHeader);
            return this.pravegaAuthManager.authenticate(credentials);
        }
        return null;
    }

    public void authenticateAuthorize(List<String> authHeader, String resource, AuthHandler.Permissions permission) throws AuthException {
        String credentials;
        if (this.isAuthEnabled() && !this.pravegaAuthManager.authenticateAndAuthorize(resource, credentials = this.parseCredentials(authHeader), permission)) {
            throw new AuthorizationException(String.format("Failed to authorize for resource [%s]", resource), Response.Status.FORBIDDEN.getStatusCode());
        }
    }

    private String parseCredentials(List<String> authHeader) throws AuthenticationException {
        if (authHeader == null || authHeader.isEmpty()) {
            throw new AuthenticationException("Missing authorization header.");
        }
        String credentials = authHeader.get(0);
        Preconditions.checkNotNull((Object)credentials, (Object)"Missing credentials.");
        return credentials;
    }

    @VisibleForTesting
    public boolean isAuthEnabled() {
        return this.pravegaAuthManager != null;
    }
}

