/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

public final class MetricsNames {
    public static final String PREFIX = "pravega.";
    public static final String LOG_ERRORS = "pravega.logged_errors";
    public static final String LOG_WARNINGS = "pravega.logged_warnings";
    public static final String SEGMENT_CREATE_LATENCY = "pravega.segmentstore.segment.create_latency_ms";
    public static final String SEGMENT_DELETE_LATENCY = "pravega.segmentstore.segment.delete_latency_ms";
    public static final String SEGMENT_READ_LATENCY = "pravega.segmentstore.segment.read_latency_ms";
    public static final String SEGMENT_WRITE_LATENCY = "pravega.segmentstore.segment.write_latency_ms";
    public static final String SEGMENT_APPEND_SIZE = "pravega.segmentstore.segment.append_size";
    public static final String SEGMENT_READ_SIZE = "pravega.segmentstore.segment.read_size";
    public static final String SEGMENT_READ_BYTES = "pravega.segmentstore.segment.read_bytes";
    public static final String SEGMENT_WRITE_BYTES = "pravega.segmentstore.segment.write_bytes";
    public static final String SEGMENT_WRITE_EVENTS = "pravega.segmentstore.segment.write_events";
    public static final String TABLE_SEGMENT_UPDATE_LATENCY = "pravega.segmentstore.tablesegment.update_latency_ms";
    public static final String TABLE_SEGMENT_UPDATE_CONDITIONAL_LATENCY = "pravega.segmentstore.tablesegment.update_conditional_latency_ms";
    public static final String TABLE_SEGMENT_REMOVE_LATENCY = "pravega.segmentstore.tablesegment.remove_latency_ms";
    public static final String TABLE_SEGMENT_REMOVE_CONDITIONAL_LATENCY = "pravega.segmentstore.tablesegment.remove_conditional_latency_ms";
    public static final String TABLE_SEGMENT_GET_LATENCY = "pravega.segmentstore.tablesegment.get_latency_ms";
    public static final String TABLE_SEGMENT_ITERATE_KEYS_LATENCY = "pravega.segmentstore.tablesegment.iterate_keys_latency_ms";
    public static final String TABLE_SEGMENT_ITERATE_ENTRIES_LATENCY = "pravega.segmentstore.tablesegment.iterate_entries_latency_ms";
    public static final String TABLE_SEGMENT_GET_INFO_LATENCY = "pravega.segmentstore.tablesegment.get_info_latency_ms";
    public static final String TABLE_SEGMENT_UPDATE = "pravega.segmentstore.tablesegment.update";
    public static final String TABLE_SEGMENT_UPDATE_CONDITIONAL = "pravega.segmentstore.tablesegment.update_conditional";
    public static final String TABLE_SEGMENT_REMOVE = "pravega.segmentstore.tablesegment.remove";
    public static final String TABLE_SEGMENT_REMOVE_CONDITIONAL = "pravega.segmentstore.tablesegment.remove_conditional";
    public static final String TABLE_SEGMENT_GET = "pravega.segmentstore.tablesegment.get";
    public static final String TABLE_SEGMENT_ITERATE_KEYS = "pravega.segmentstore.tablesegment.iterate_keys";
    public static final String TABLE_SEGMENT_ITERATE_ENTRIES = "pravega.segmentstore.tablesegment.iterate_entries";
    public static final String TABLE_SEGMENT_GET_INFO = "pravega.segmentstore.tablesegment.get_info";
    public static final String STORAGE_READ_LATENCY = "pravega.segmentstore.storage.read_latency_ms";
    public static final String STORAGE_WRITE_LATENCY = "pravega.segmentstore.storage.write_latency_ms";
    public static final String STORAGE_CREATE_LATENCY = "pravega.segmentstore.storage.create_latency_ms";
    public static final String STORAGE_DELETE_LATENCY = "pravega.segmentstore.storage.delete_latency_ms";
    public static final String STORAGE_CONCAT_LATENCY = "pravega.segmentstore.storage.concat_latency_ms";
    public static final String STORAGE_READ_BYTES = "pravega.segmentstore.storage.read_bytes";
    public static final String STORAGE_WRITE_BYTES = "pravega.segmentstore.storage.write_bytes";
    public static final String STORAGE_CONCAT_BYTES = "pravega.segmentstore.storage.concat_bytes";
    public static final String STORAGE_CREATE_COUNT = "pravega.segmentstore.storage.create_count";
    public static final String STORAGE_DELETE_COUNT = "pravega.segmentstore.storage.delete_count";
    public static final String STORAGE_CONCAT_COUNT = "pravega.segmentstore.storage.concat_count";
    public static final String STORAGE_LARGE_CONCAT_COUNT = "pravega.segmentstore.storage.large_concat_count";
    public static final String SLTS_READ_LATENCY = "pravega.segmentstore.storage.slts.read_latency_ms";
    public static final String SLTS_WRITE_LATENCY = "pravega.segmentstore.storage.slts.write_latency_ms";
    public static final String SLTS_SYSTEM_READ_LATENCY = "pravega.segmentstore.storage.slts.system_read_latency_ms";
    public static final String SLTS_SYSTEM_WRITE_LATENCY = "pravega.segmentstore.storage.slts.system_write_latency_ms";
    public static final String SLTS_CREATE_LATENCY = "pravega.segmentstore.storage.slts.create_latency_ms";
    public static final String SLTS_DELETE_LATENCY = "pravega.segmentstore.storage.slts.delete_latency_ms";
    public static final String SLTS_CONCAT_LATENCY = "pravega.segmentstore.storage.slts.concat_latency_ms";
    public static final String SLTS_TRUNCATE_LATENCY = "pravega.segmentstore.storage.slts.truncate_latency_ms";
    public static final String SLTS_NUM_CHUNKS_READ = "pravega.segmentstore.storage.slts.num_chunks_read";
    public static final String SLTS_SYSTEM_NUM_CHUNKS_READ = "pravega.segmentstore.storage.slts.system_num_chunks_read";
    public static final String SLTS_NUM_CHUNKS_ADDED = "pravega.segmentstore.storage.slts.num_chunks_added";
    public static final String SLTS_SYSTEM_NUM_CHUNKS_ADDED = "pravega.segmentstore.storage.slts.system_num_chunks_added";
    public static final String SLTS_READ_INSTANT_TPUT = "pravega.segmentstore.storage.slts.read_instant_tput";
    public static final String SLTS_WRITE_INSTANT_TPUT = "pravega.segmentstore.storage.slts.write_instant_tput";
    public static final String SLTS_READ_INDEX_SCAN_LATENCY = "pravega.segmentstore.storage.slts.read_index.scan_latency_ms";
    public static final String SLTS_READ_INDEX_BLOCK_LOOKUP_LATENCY = "pravega.segmentstore.storage.slts.read_index.block_lookup_latency_ms";
    public static final String SLTS_READ_INDEX_NUM_SCANNED = "pravega.segmentstore.storage.slts.read_index.num_scanned";
    public static final String SLTS_SYS_READ_INDEX_SCAN_LATENCY = "pravega.segmentstore.storage.slts.read_index.system_scan_latency_ms";
    public static final String SLTS_SYS_READ_INDEX_BLOCK_LOOKUP_LATENCY = "pravega.segmentstore.storage.slts.read_index.system_block_lookup_latency_ms";
    public static final String SLTS_SYS_READ_INDEX_NUM_SCANNED = "pravega.segmentstore.storage.slts.read_index.system_num_scanned";
    public static final String SLTS_READ_INDEX_SEGMENT_INDEX_SIZE = "pravega.segmentstore.storage.slts.read_index.segment_index_size";
    public static final String SLTS_READ_INDEX_CHUNK_INDEX_SIZE = "pravega.segmentstore.storage.slts.read_index.chunks_index_size";
    public static final String SLTS_READ_INDEX_SEGMENT_MISS_RATE = "pravega.segmentstore.storage.slts.read_index.segment_miss_rate";
    public static final String SLTS_READ_BYTES = "pravega.segmentstore.storage.slts.read_bytes";
    public static final String SLTS_WRITE_BYTES = "pravega.segmentstore.storage.slts.write_bytes";
    public static final String SLTS_SYSTEM_READ_BYTES = "pravega.segmentstore.storage.slts.system_read_bytes";
    public static final String SLTS_SYSTEM_WRITE_BYTES = "pravega.segmentstore.storage.slts.system_write_bytes";
    public static final String SLTS_CONCAT_BYTES = "pravega.segmentstore.storage.slts.concat_bytes";
    public static final String SLTS_CREATE_COUNT = "pravega.segmentstore.storage.slts.create_count";
    public static final String SLTS_DELETE_COUNT = "pravega.segmentstore.storage.slts.delete_count";
    public static final String SLTS_CONCAT_COUNT = "pravega.segmentstore.storage.slts.concat_count";
    public static final String SLTS_TRUNCATE_COUNT = "pravega.segmentstore.storage.slts.truncate_count";
    public static final String SLTS_SYSTEM_TRUNCATE_COUNT = "pravega.segmentstore.storage.slts.system_truncate_count";
    public static final String SLTS_GC_QUEUE_SIZE = "pravega.segmentstore.storage.slts.GC_queue_record_count";
    public static final String SLTS_GC_TASK_PROCESSED = "pravega.segmentstore.storage.slts.GC.task_processed_count";
    public static final String SLTS_GC_CHUNK_NEW = "pravega.segmentstore.storage.slts.GC.chunk_new_count";
    public static final String SLTS_GC_CHUNK_QUEUED = "pravega.segmentstore.storage.slts.GC.chunk_queued_count";
    public static final String SLTS_GC_CHUNK_DELETED = "pravega.segmentstore.storage.slts.GC.chunk_deleted_count";
    public static final String SLTS_GC_CHUNK_RETRY = "pravega.segmentstore.storage.slts.GC.chunk_retry_count";
    public static final String SLTS_GC_CHUNK_FAILED = "pravega.segmentstore.storage.slts.GC.chunk_failed_count";
    public static final String SLTS_GC_SEGMENT_QUEUED = "pravega.segmentstore.storage.slts.GC.segment_queued_count";
    public static final String SLTS_GC_SEGMENT_PROCESSED = "pravega.segmentstore.storage.slts.GC.segment_deleted_count";
    public static final String SLTS_GC_SEGMENT_RETRY = "pravega.segmentstore.storage.slts.GC.segment_retry_count";
    public static final String SLTS_GC_SEGMENT_FAILED = "pravega.segmentstore.storage.slts.GC.segment_failed_count";
    public static final String STORAGE_METADATA_SIZE = "pravega.segmentstore.storage.size.";
    public static final String STORAGE_METADATA_NUM_CHUNKS = "pravega.segmentstore.storage.num_chunks.";
    public static final String STORAGE_METADATA_GET_LATENCY = "pravega.segmentstore.storage.metadata_get_latency_ms";
    public static final String STORAGE_METADATA_COMMIT_LATENCY = "pravega.segmentstore.storage.metadata_commit_latency_ms";
    public static final String STORAGE_METADATA_TABLE_GET_LATENCY = "pravega.segmentstore.storage.metadata_table_get_latency_ms";
    public static final String STORAGE_METADATA_TABLE_WRITE_LATENCY = "pravega.segmentstore.storage.metadata_table_write_latency_ms";
    public static final String STORAGE_METADATA_TXN_HIT_COUNT = "pravega.segmentstore.storage.metadata_txn_hit_count";
    public static final String STORAGE_METADATA_BUFFER_HIT_COUNT = "pravega.segmentstore.storage.metadata_buffer_hit_count";
    public static final String STORAGE_METADATA_CACHE_HIT_COUNT = "pravega.segmentstore.storage.metadata_cache_hit_count";
    public static final String STORAGE_METADATA_STORE_HIT_COUNT = "pravega.segmentstore.storage.metadata_store_hit_count";
    public static final String STORAGE_METADATA_MISS_COUNT = "pravega.segmentstore.storage.metadata_miss_count";
    public static final String STORAGE_METADATA_BUFFER_EVICTED_COUNT = "pravega.segmentstore.storage.metadata_buffer_evicted_count";
    public static final String STORAGE_METADATA_BUFFER_SIZE = "pravega.segmentstore.storage.metadata_buffer_record_count";
    public static final String STORAGE_METADATA_CACHE_SIZE = "pravega.segmentstore.storage.metadata_cache_record_count";
    public static final String STORAGE_METADATA_CACHE_MISS_RATE = "pravega.segmentstore.storage.metadata_cache_miss_rate";
    public static final String CACHE_WRITE_BYTES = "pravega.segmentstore.cache.write_bytes";
    public static final String CACHE_APPEND_BYTES = "pravega.segmentstore.cache.append_bytes";
    public static final String CACHE_READ_BYTES = "pravega.segmentstore.cache.read_bytes";
    public static final String CACHE_DELETE_BYTES = "pravega.segmentstore.cache.delete_bytes";
    public static final String CACHE_STORED_SIZE_BYTES = "pravega.segmentstore.cache.stored_size_bytes";
    public static final String CACHE_USED_SIZE_BYTES = "pravega.segmentstore.cache.used_size_bytes";
    public static final String CACHE_ALLOC_SIZE_BYTES = "pravega.segmentstore.cache.allocated_size_bytes";
    public static final String CACHE_GENERATION_SPREAD = "pravega.segmentstore.cache.gen";
    public static final String CACHE_MANAGER_ITERATION_DURATION = "pravega.segmentstore.cache.manager_iteration_duration_ms";
    public static final String BK_TOTAL_WRITE_LATENCY = "pravega.segmentstore.bookkeeper.total_write_latency_ms";
    public static final String BK_WRITE_LATENCY = "pravega.segmentstore.bookkeeper.write_latency_ms";
    public static final String BK_WRITE_BYTES = "pravega.segmentstore.bookkeeper.write_bytes";
    public static final String BK_WRITE_QUEUE_SIZE = "pravega.segmentstore.bookkeeper.write_queue_size";
    public static final String BK_WRITE_QUEUE_FILL_RATE = "pravega.segmentstore.bookkeeper.write_queue_fill";
    public static final String BK_LEDGER_COUNT = "pravega.segmentstore.bookkeeper.ledger_count";
    public static final String STORAGE_WRITER_FLUSH_ELAPSED = "pravega.segmentstore.storagewriter.flush_elapsed_ms";
    public static final String STORAGE_WRITER_ITERATION_ELAPSED = "pravega.segmentstore.storagewriter.iteration_elapsed_ms";
    public static final String STORAGE_WRITER_READ_COUNT = "pravega.segmentstore.storagewriter.read_count";
    public static final String STORAGE_WRITER_FLUSHED_BYTES = "pravega.segmentstore.storagewriter.flushed_bytes";
    public static final String STORAGE_WRITER_MERGED_BYTES = "pravega.segmentstore.storagewriter.merged_bytes";
    public static final String STORAGE_WRITER_FLUSHED_ATTRIBUTES = "pravega.segmentstore.storagewriter.flushed_attributes";
    public static final String CONTAINER_APPEND_COUNT = "pravega.segmentstore.container.append_count";
    public static final String CONTAINER_APPEND_OFFSET_COUNT = "pravega.segmentstore.container.append_offset_count";
    public static final String CONTAINER_UPDATE_ATTRIBUTES_COUNT = "pravega.segmentstore.container.update_attributes_count";
    public static final String CONTAINER_GET_ATTRIBUTES_COUNT = "pravega.segmentstore.container.get_attributes_count";
    public static final String CONTAINER_READ_COUNT = "pravega.segmentstore.container.read_count";
    public static final String CONTAINER_GET_INFO_COUNT = "pravega.segmentstore.container.get_info_count";
    public static final String CONTAINER_CREATE_SEGMENT_COUNT = "pravega.segmentstore.container.create_segment_count";
    public static final String CONTAINER_DELETE_SEGMENT_COUNT = "pravega.segmentstore.container.delete_segment_count";
    public static final String CONTAINER_MERGE_SEGMENT_COUNT = "pravega.segmentstore.container.merge_segment_count";
    public static final String CONTAINER_SEAL_COUNT = "pravega.segmentstore.container.seal_count";
    public static final String CONTAINER_TRUNCATE_COUNT = "pravega.segmentstore.container.truncate_count";
    public static final String CONTAINER_RECOVERY_TIME = "pravega.segmentstore.container.recovery_time";
    public static final String CONTAINER_EVENT_PROCESSOR_OUTSTANDING_BYTES = "pravega.segmentstore.container.event_processor_outstanding_bytes";
    public static final String CONTAINER_EVENT_PROCESSOR_BATCH_LATENCY = "pravega.segmentstore.container.event_processor_batch_latency";
    public static final String PROCESS_OPERATIONS_LATENCY = "pravega.segmentstore.container.process_operations.latency_ms";
    public static final String PROCESS_OPERATIONS_BATCH_SIZE = "pravega.segmentstore.container.process_operations.batch_size";
    public static final String OPERATION_QUEUE_SIZE = "pravega.segmentstore.container.operation_queue.size";
    public static final String OPERATION_PROCESSOR_IN_FLIGHT = "pravega.segmentstore.container.operation_processor.in_flight";
    public static final String OPERATION_QUEUE_WAIT_TIME = "pravega.segmentstore.container.operation_queue.wait_time";
    public static final String OPERATION_PROCESSOR_DELAY_MILLIS = "pravega.segmentstore.container.operation_processor.delay_ms";
    public static final String OPERATION_COMMIT_LATENCY = "pravega.segmentstore.container.operation_commit.latency_ms";
    public static final String OPERATION_LATENCY = "pravega.segmentstore.container.operation.latency_ms";
    public static final String OPERATION_COMMIT_MEMORY_COUNT = "pravega.segmentstore.container.operation_commit.memory_count";
    public static final String OPERATION_COMMIT_MEMORY_LATENCY = "pravega.segmentstore.container.operation_commit.memory_latency_ms";
    public static final String OPERATION_LOG_SIZE = "pravega.segmentstore.container.operation.log_size";
    public static final String ACTIVE_SEGMENT_COUNT = "pravega.segmentstore.container.active_segments";
    public static final String THREAD_POOL_QUEUE_SIZE = "pravega.segmentstore.thread_pool.queue_size";
    public static final String THREAD_POOL_ACTIVE_THREADS = "pravega.segmentstore.thread_pool.active_threads";
    public static final String STORAGE_THREAD_POOL_QUEUE_SIZE = "pravega.segmentstore.storage_thread_pool.queue_size";
    public static final String STORAGE_THREAD_POOL_ACTIVE_THREADS = "pravega.segmentstore.storage_thread_pool.active_threads";
    public static final String CREATE_KVTABLE = "pravega.controller.kvtable.created";
    public static final String KVTABLE_SEGMENTS_COUNT = "pravega.controller.kvtable.segments.count";
    public static final String CREATE_KVTABLE_LATENCY = "pravega.controller.kvtable.created_latency_ms";
    public static final String CREATE_KVTABLE_FAILED = "pravega.controller.kvtable.create_failed";
    public static final String DELETE_KVTABLE = "pravega.controller.kvtable.deleted";
    public static final String DELETE_KVTABLE_LATENCY = "pravega.controller.kvtable.deleted_latency_ms";
    public static final String DELETE_KVTABLE_FAILED = "pravega.controller.kvtable.delete_failed";
    public static final String CREATE_SCOPE = "pravega.controller.scope.created";
    public static final String CREATE_SCOPE_LATENCY = "pravega.controller.scope.created_latency_ms";
    public static final String CREATE_SCOPE_FAILED = "pravega.controller.scope.create_failed";
    public static final String DELETE_SCOPE = "pravega.controller.scope.deleted";
    public static final String DELETE_SCOPE_LATENCY = "pravega.controller.scope.deleted_latency_ms";
    public static final String DELETE_SCOPE_FAILED = "pravega.controller.scope.delete_failed";
    public static final String CREATE_STREAM = "pravega.controller.stream.created";
    public static final String CREATE_STREAM_LATENCY = "pravega.controller.stream.created_latency_ms";
    public static final String CREATE_STREAM_FAILED = "pravega.controller.stream.create_failed";
    public static final String SEAL_STREAM = "pravega.controller.stream.sealed";
    public static final String SEAL_STREAM_LATENCY = "pravega.controller.stream.sealed_latency_ms";
    public static final String SEAL_STREAM_FAILED = "pravega.controller.stream.seal_failed";
    public static final String DELETE_STREAM = "pravega.controller.stream.deleted";
    public static final String DELETE_STREAM_LATENCY = "pravega.controller.stream.deleted_latency_ms";
    public static final String DELETE_STREAM_FAILED = "pravega.controller.stream.delete_failed";
    public static final String UPDATE_STREAM = "pravega.controller.stream.updated";
    public static final String UPDATE_STREAM_LATENCY = "pravega.controller.stream.updated_latency_ms";
    public static final String UPDATE_STREAM_FAILED = "pravega.controller.stream.update_failed";
    public static final String TRUNCATE_STREAM = "pravega.controller.stream.truncated";
    public static final String TRUNCATE_STREAM_LATENCY = "pravega.controller.stream.truncated_latency_ms";
    public static final String TRUNCATE_STREAM_FAILED = "pravega.controller.stream.truncate_failed";
    public static final String CREATE_READER_GROUP = "pravega.controller.stream.create_reader_group";
    public static final String CREATE_READER_GROUP_LATENCY = "pravega.controller.stream.create_reader_group_latency_ms";
    public static final String CREATE_READER_GROUP_FAILED = "pravega.controller.stream.create_reader_group_failed";
    public static final String DELETE_READER_GROUP = "pravega.controller.stream.delete_reader_group";
    public static final String DELETE_READER_GROUP_LATENCY = "pravega.controller.stream.delete_reader_group_latency_ms";
    public static final String DELETE_READER_GROUP_FAILED = "pravega.controller.stream.delete_reader_group_failed";
    public static final String UPDATE_READER_GROUP = "pravega.controller.stream.update_reader_group";
    public static final String UPDATE_READER_GROUP_LATENCY = "pravega.controller.stream.update_reader_group_latency_ms";
    public static final String UPDATE_READER_GROUP_FAILED = "pravega.controller.stream.update_reader_group_failed";
    public static final String UPDATE_SUBSCRIBER = "pravega.controller.stream.update_subscriber_streamcut";
    public static final String UPDATE_SUBSCRIBER_LATENCY = "pravega.controller.stream.update_subscriber_streamcut_latency_ms";
    public static final String UPDATE_SUBSCRIBER_FAILED = "pravega.controller.stream.update_subscriber_streamcut_failed";
    public static final String CREATE_TRANSACTION = "pravega.controller.transactions.created";
    public static final String CREATE_TRANSACTION_LATENCY = "pravega.controller.transactions.created_latency_ms";
    public static final String CREATE_TRANSACTION_SEGMENTS_LATENCY = "pravega.controller.transactions.created_segments_latency_ms";
    public static final String CREATE_TRANSACTION_FAILED = "pravega.controller.transactions.create_failed";
    public static final String COMMITTING_TRANSACTION_LATENCY = "pravega.controller.transactions.committing_latency_ms";
    public static final String COMMIT_TRANSACTION = "pravega.controller.transactions.committed";
    public static final String COMMIT_TRANSACTION_LATENCY = "pravega.controller.transactions.committed_latency_ms";
    public static final String COMMIT_TRANSACTION_SEGMENTS_LATENCY = "pravega.controller.transactions.committed_segments_latency_ms";
    public static final String COMMIT_TRANSACTION_FAILED = "pravega.controller.transactions.commit_failed";
    public static final String ABORTING_TRANSACTION_LATENCY = "pravega.controller.transactions.aborting_latency_ms";
    public static final String ABORT_TRANSACTION = "pravega.controller.transactions.aborted";
    public static final String ABORT_TRANSACTION_LATENCY = "pravega.controller.transactions.aborted_latency_ms";
    public static final String ABORT_TRANSACTION_SEGMENTS_LATENCY = "pravega.controller.transactions.aborted_segments_latency_ms";
    public static final String ABORT_TRANSACTION_FAILED = "pravega.controller.transactions.abort_failed";
    public static final String OPEN_TRANSACTIONS = "pravega.controller.transactions.opened";
    public static final String TIMEDOUT_TRANSACTIONS = "pravega.controller.transactions.timedout";
    public static final String SEGMENT_STORE_HOST_NUMBER = "pravega.controller.hosts.count";
    public static final String SEGMENT_STORE_HOST_FAILURES = "pravega.controller.hosts.failures";
    public static final String SEGMENT_STORE_HOST_CONTAINER_COUNT = "pravega.controller.hosts.container_count";
    public static final String CONTAINER_FAILOVERS = "pravega.controller.container.failovers";
    public static final String SEGMENTS_COUNT = "pravega.controller.segments.count";
    public static final String SEGMENTS_SPLITS = "pravega.controller.segment.splits";
    public static final String SEGMENTS_MERGES = "pravega.controller.segment.merges";
    public static final String RETENTION_FREQUENCY = "pravega.controller.retention.frequency";
    public static final String TRUNCATED_SIZE = "pravega.controller.retention.truncated_size";
    public static final String CONTROLLER_ZK_SESSION_EXPIRATION = "pravega.controller.zookeeper.session_expiration";

    public static String globalMetricName(String stringName) {
        return stringName + "_global";
    }

    public static String failMetricName(String metricName) {
        if (Strings.isNullOrEmpty((String)metricName)) {
            return metricName;
        }
        CharSequence[] tags = metricName.split("\\.");
        if (tags.length >= 2 && Ints.tryParse((String)tags[tags.length - 1]) != null) {
            int n = tags.length - 2;
            tags[n] = tags[n] + "_fail";
            return String.join((CharSequence)".", tags);
        }
        return metricName + "_fail";
    }

    public static MetricKey metricKey(String metric, String ... tags) {
        if (tags == null || tags.length == 0) {
            return new MetricKey(metric, metric);
        }
        StringBuilder sb = new StringBuilder(metric);
        Preconditions.checkArgument((tags.length % 2 == 0 ? 1 : 0) != 0, (String)"Tags is a set of key/value pair so the size must be even: %s", (int)tags.length);
        for (int i = 0; i < tags.length; i += 2) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tags[i]) || !Strings.isNullOrEmpty((String)tags[i + 1]) ? 1 : 0) != 0, (Object)"Tag name or value cannot be empty or null");
            sb.append('.').append(tags[i + 1]);
        }
        return new MetricKey(sb.toString(), metric);
    }

    public static class MetricKey {
        private final String cacheKey;
        private final String registryKey;

        @ConstructorProperties(value={"cacheKey", "registryKey"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MetricKey(String cacheKey, String registryKey) {
            this.cacheKey = cacheKey;
            this.registryKey = registryKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getCacheKey() {
            return this.cacheKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getRegistryKey() {
            return this.registryKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetricKey)) {
                return false;
            }
            MetricKey other = (MetricKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cacheKey = this.getCacheKey();
            String other$cacheKey = other.getCacheKey();
            if (this$cacheKey == null ? other$cacheKey != null : !this$cacheKey.equals(other$cacheKey)) {
                return false;
            }
            String this$registryKey = this.getRegistryKey();
            String other$registryKey = other.getRegistryKey();
            return !(this$registryKey == null ? other$registryKey != null : !this$registryKey.equals(other$registryKey));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MetricKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cacheKey = this.getCacheKey();
            result = result * 59 + ($cacheKey == null ? 43 : $cacheKey.hashCode());
            String $registryKey = this.getRegistryKey();
            result = result * 59 + ($registryKey == null ? 43 : $registryKey.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "MetricsNames.MetricKey(cacheKey=" + this.getCacheKey() + ", registryKey=" + this.getRegistryKey() + ")";
        }
    }
}

