/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.MeterRegistry;
import io.pravega.common.Exceptions;
import io.pravega.common.util.SimpleCache;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.Gauge;
import io.pravega.shared.metrics.Meter;
import io.pravega.shared.metrics.Metric;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicLoggerImpl
implements DynamicLogger {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicLoggerImpl.class);
    private final MeterRegistry metrics;
    private final StatsLogger underlying;
    private final SimpleCache<String, Counter> countersCache;
    private final SimpleCache<String, Gauge> gaugesCache;
    private final SimpleCache<String, Meter> metersCache;

    DynamicLoggerImpl(@NonNull MetricsConfig metricsConfig, @NonNull MeterRegistry metrics, @NonNull StatsLogger statsLogger) {
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        if (statsLogger == null) {
            throw new NullPointerException("statsLogger is marked non-null but is null");
        }
        this.metrics = metrics;
        this.underlying = statsLogger;
        int cacheSize = metricsConfig.getDynamicCacheSize();
        Duration cacheEvictionDuration = metricsConfig.getDynamicCacheEvictionDurationMinutes();
        this.countersCache = new SimpleCache(cacheSize, cacheEvictionDuration, this::unregister);
        this.gaugesCache = new SimpleCache(cacheSize, cacheEvictionDuration, this::unregister);
        this.metersCache = new SimpleCache(cacheSize, cacheEvictionDuration, this::unregister);
    }

    @Override
    public void incCounterValue(String name, long delta, String ... tags) {
        this.getCounter(name, tags).add(delta);
    }

    @Override
    public void updateCounterValue(String name, long value, String ... tags) {
        Counter c = this.getCounter(name, tags);
        c.clear();
        c.add(value);
    }

    private Counter getCounter(String name, String ... tags) {
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Counter counter = (Counter)this.countersCache.get((Object)keys.getCacheKey());
        if (counter == null) {
            counter = this.underlying.createCounter(keys.getRegistryKey(), tags);
            this.countersCache.putIfAbsent((Object)keys.getCacheKey(), (Object)counter);
        }
        return counter;
    }

    @Override
    public <T extends Number> void reportGaugeValue(String name, T value, String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Gauge gauge = (Gauge)this.gaugesCache.get((Object)keys.getCacheKey());
        if (gauge == null) {
            gauge = this.underlying.registerGauge(keys.getRegistryKey(), value::doubleValue, tags);
            this.gaugesCache.putIfAbsent((Object)keys.getCacheKey(), (Object)gauge);
        }
        gauge.setSupplier(value::doubleValue);
    }

    @Override
    public void recordMeterEvents(String name, long number, String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Meter meter = (Meter)this.metersCache.get((Object)keys.getCacheKey());
        if (meter == null) {
            meter = this.underlying.createMeter(keys.getRegistryKey(), tags);
            this.metersCache.putIfAbsent((Object)keys.getCacheKey(), (Object)meter);
        }
        meter.recordEvents(number);
    }

    @Override
    public void freezeCounter(String name, String ... tags) {
        this.freeze(this.countersCache, name, tags);
    }

    @Override
    public void freezeGaugeValue(String name, String ... tags) {
        this.freeze(this.gaugesCache, name, tags);
    }

    @Override
    public void freezeMeter(String name, String ... tags) {
        this.freeze(this.metersCache, name, tags);
    }

    private <T extends Metric> void freeze(SimpleCache<String, T> cache, String name, String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Metric metric = (Metric)cache.remove((Object)keys.getCacheKey());
        if (metric != null) {
            metric.close();
            this.unregister(metric);
        }
    }

    private void unregister(String cacheKey, Metric m) {
        this.unregister(m);
    }

    private void unregister(Metric m) {
        this.metrics.remove(m.getId());
        log.trace("Closed Metric: {}.", (Object)m.getId());
    }
}

