/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Meter;
import io.pravega.common.Exceptions;
import io.pravega.shared.metrics.Metric;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;

abstract class MetricProxy<MetricT extends Metric, SelfT extends MetricProxy<MetricT, SelfT>>
implements AutoCloseable {
    private final AtomicReference<MetricT> instance = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String proxyName;
    private final Consumer<SelfT> closeCallback;

    MetricProxy(MetricT instance, String proxyName, Consumer<SelfT> closeCallback) {
        this.closeCallback = (Consumer)Preconditions.checkNotNull(closeCallback, (Object)"closeCallback");
        this.proxyName = Exceptions.checkNotNullOrEmpty((String)proxyName, (String)"name");
        this.updateInstance(instance);
    }

    @Override
    public void close() {
        Metric i;
        if (!this.closed.getAndSet(true) && (i = (Metric)this.instance.get()) != null) {
            i.close();
            this.closeCallback.accept(this.getSelf());
        }
    }

    protected abstract SelfT getSelf();

    public Meter.Id getId() {
        return this.getInstance().getId();
    }

    void updateInstance(MetricT newInstance) {
        Metric oldInstance = this.instance.getAndSet((Metric)Preconditions.checkNotNull(newInstance, (Object)"instance"));
        if (oldInstance != null && !newInstance.equals(oldInstance)) {
            oldInstance.close();
        }
    }

    protected MetricT getInstance() {
        return (MetricT)((Metric)this.instance.get());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getProxyName() {
        return this.proxyName;
    }
}

