/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class MetricRegistryUtils {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricRegistryUtils.class);

    public static Counter getCounter(String metricsName, String ... tags) {
        Collection counters = Metrics.globalRegistry.find(metricsName).tags(tags).counters();
        int size = counters.size();
        Preconditions.checkState((size <= 1 ? 1 : 0) != 0, (String)"Metric was not unique %s", counters.stream().map(m -> m.getId()).collect(Collectors.toList()));
        if (size == 0) {
            return null;
        }
        return (Counter)counters.iterator().next();
    }

    public static DistributionSummary getMeter(String metricsName, String ... tags) {
        Collection summaries = Metrics.globalRegistry.find(metricsName).tags(tags).summaries();
        int size = summaries.size();
        Preconditions.checkState((size <= 1 ? 1 : 0) != 0, (String)"Metric was not unique %s", summaries.stream().map(m -> m.getId()).collect(Collectors.toList()));
        if (size == 0) {
            return null;
        }
        return (DistributionSummary)summaries.iterator().next();
    }

    public static Gauge getGauge(String metricsName, String ... tags) {
        Collection gauges = Metrics.globalRegistry.find(metricsName).tags(tags).gauges();
        int size = gauges.size();
        Preconditions.checkState((size <= 1 ? 1 : 0) != 0, (String)"Metric was not unique %s", gauges.stream().map(m -> m.getId()).collect(Collectors.toList()));
        if (size == 0) {
            return null;
        }
        return (Gauge)gauges.iterator().next();
    }

    public static Timer getTimer(String metricsName, String ... tags) {
        Collection timers = Metrics.globalRegistry.find(metricsName).tags(tags).timers();
        int size = timers.size();
        Preconditions.checkState((size <= 1 ? 1 : 0) != 0, (String)"Metric was not unique %s", timers.stream().map(m -> m.getId()).collect(Collectors.toList()));
        if (size == 0) {
            return null;
        }
        return (Timer)timers.iterator().next();
    }
}

