/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.time.Duration;
import lombok.Generated;

public class MetricsConfig {
    public static final Property<Boolean> ENABLE_STATISTICS = Property.named((String)"statistics.enable", (Object)false, (String)"enableStatistics");
    public static final Property<Integer> DYNAMIC_CACHE_SIZE = Property.named((String)"dynamicCache.size", (Object)100000, (String)"dynamicCacheSize");
    public static final Property<Integer> DYNAMIC_CACHE_EVICTION_DURATION_MINUTES = Property.named((String)"dynamicCache.eviction.duration.minutes", (Object)3, (String)"dynamicCacheEvictionDurationMinutes");
    public static final Property<Integer> OUTPUT_FREQUENCY = Property.named((String)"output.frequency.seconds", (Object)60, (String)"outputFrequencySeconds");
    public static final Property<String> METRICS_PREFIX = Property.named((String)"prefix", (Object)"pravega", (String)"metricsPrefix");
    public static final Property<String> STATSD_HOST = Property.named((String)"statsD.connect.host", (Object)"localhost", (String)"statsDHost");
    public static final Property<Integer> STATSD_PORT = Property.named((String)"statsD.connect.port", (Object)8125, (String)"statsDPort");
    public static final Property<String> INFLUXDB_URI = Property.named((String)"influxDB.connect.uri", (Object)"http://localhost:8086", (String)"influxDBURI");
    public static final Property<String> INFLUXDB_NAME = Property.named((String)"influxDB.connect.db.name", (Object)"pravega", (String)"influxDBName");
    public static final Property<String> INFLUXDB_USERNAME = Property.named((String)"influxDB.connect.credentials.username", (Object)"", (String)"influxDBUserName");
    public static final Property<String> INFLUXDB_PASSWORD = Property.named((String)"influxDB.connect.credentials.pwd", (Object)"", (String)"influxDBPassword");
    public static final Property<String> INFLUXDB_RETENTION_POLICY = Property.named((String)"influxDB.retention", (Object)"", (String)"influxDBRetention");
    public static final Property<Boolean> ENABLE_STATSD_REPORTER = Property.named((String)"statsD.reporter.enable", (Object)false, (String)"enableStatsDReporter");
    public static final Property<Boolean> ENABLE_INFLUXDB_REPORTER = Property.named((String)"influxDB.reporter.enable", (Object)false, (String)"enableInfluxDBReporter");
    public static final String COMPONENT_CODE = "metrics";
    private final boolean enableStatistics;
    private final int dynamicCacheSize;
    private Duration dynamicCacheEvictionDurationMinutes;
    private final Duration outputFrequencySeconds;
    private final String metricsPrefix;
    private final String statsDHost;
    private final int statsDPort;
    private final String influxDBUri;
    private final String influxDBName;
    private final String influxDBUserName;
    private final char[] influxDBPassword;
    private final String influxDBRetention;
    private final boolean enableStatsDReporter;
    private final boolean enableInfluxDBReporter;

    private MetricsConfig(TypedProperties properties) throws ConfigurationException {
        this.enableStatistics = properties.getBoolean(ENABLE_STATISTICS);
        this.dynamicCacheSize = properties.getInt(DYNAMIC_CACHE_SIZE);
        this.dynamicCacheEvictionDurationMinutes = Duration.ofMinutes(properties.getInt(DYNAMIC_CACHE_EVICTION_DURATION_MINUTES));
        this.outputFrequencySeconds = Duration.ofSeconds(properties.getInt(OUTPUT_FREQUENCY));
        this.metricsPrefix = properties.get(METRICS_PREFIX);
        this.statsDHost = properties.get(STATSD_HOST);
        this.statsDPort = properties.getInt(STATSD_PORT);
        this.influxDBUri = properties.get(INFLUXDB_URI);
        this.influxDBName = properties.get(INFLUXDB_NAME);
        this.influxDBUserName = properties.get(INFLUXDB_USERNAME);
        this.influxDBPassword = properties.get(INFLUXDB_PASSWORD).toCharArray();
        this.influxDBRetention = properties.get(INFLUXDB_RETENTION_POLICY);
        this.enableInfluxDBReporter = properties.getBoolean(ENABLE_INFLUXDB_REPORTER);
        this.enableStatsDReporter = properties.getBoolean(ENABLE_STATSD_REPORTER);
    }

    public static ConfigBuilder<MetricsConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, MetricsConfig::new);
    }

    @VisibleForTesting
    public void setDynamicCacheEvictionDuration(Duration duration) {
        this.dynamicCacheEvictionDurationMinutes = duration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getDynamicCacheSize() {
        return this.dynamicCacheSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getDynamicCacheEvictionDurationMinutes() {
        return this.dynamicCacheEvictionDurationMinutes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getOutputFrequencySeconds() {
        return this.outputFrequencySeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStatsDHost() {
        return this.statsDHost;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStatsDPort() {
        return this.statsDPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInfluxDBUri() {
        return this.influxDBUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInfluxDBName() {
        return this.influxDBName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInfluxDBUserName() {
        return this.influxDBUserName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public char[] getInfluxDBPassword() {
        return this.influxDBPassword;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getInfluxDBRetention() {
        return this.influxDBRetention;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableStatsDReporter() {
        return this.enableStatsDReporter;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableInfluxDBReporter() {
        return this.enableInfluxDBReporter;
    }
}

