/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.Status;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public class MetricsLogAppender
implements Appender<ILoggingEvent> {
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();
    private static final String COMPLETION_EXCEPTION_NAME = CompletionException.class.getSimpleName();
    private static final String EXECUTION_EXCEPTION_NAME = ExecutionException.class.getSimpleName();

    public String getName() {
        return "Metrics Appender";
    }

    public void doAppend(ILoggingEvent event) throws LogbackException {
        if (event.getLevel() == Level.ERROR) {
            this.recordEvent("pravega.logged_errors", event);
        } else if (event.getLevel() == Level.WARN) {
            this.recordEvent("pravega.logged_warnings", event);
        }
    }

    private void recordEvent(String metricName, ILoggingEvent event) {
        IThrowableProxy p = event.getThrowableProxy();
        while (this.shouldUnwrap(p)) {
            p = p.getCause();
        }
        DYNAMIC_LOGGER.recordMeterEvents(metricName, 1L, MetricsTags.exceptionTag(event.getLoggerName(), p == null ? null : p.getClassName()));
    }

    private boolean shouldUnwrap(IThrowableProxy p) {
        return p != null && p.getCause() != null && (p.getClassName().endsWith(COMPLETION_EXCEPTION_NAME) || p.getClassName().endsWith(EXECUTION_EXCEPTION_NAME));
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return true;
    }

    public void setName(String name) {
    }

    public void setContext(Context context) {
    }

    public Context getContext() {
        return null;
    }

    public void addStatus(Status status) {
    }

    public void addInfo(String msg) {
    }

    public void addInfo(String msg, Throwable ex) {
    }

    public void addWarn(String msg) {
    }

    public void addWarn(String msg, Throwable ex) {
    }

    public void addError(String msg) {
    }

    public void addError(String msg, Throwable ex) {
    }

    public void addFilter(Filter<ILoggingEvent> newFilter) {
    }

    public void clearAllFilters() {
    }

    public List<Filter<ILoggingEvent>> getCopyOfAttachedFiltersList() {
        return null;
    }

    public FilterReply getFilterChainDecision(ILoggingEvent event) {
        return null;
    }
}

