/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.DynamicLoggerProxy;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.StatsLogger;
import io.pravega.shared.metrics.StatsProvider;
import io.pravega.shared.metrics.StatsProviderProxy;

public class MetricsProvider {
    private static final StatsProviderProxy STATS_PROVIDER = new StatsProviderProxy();
    private static final DynamicLoggerProxy DYNAMIC_LOGGER = new DynamicLoggerProxy(STATS_PROVIDER.createDynamicLogger());

    public static synchronized void initialize(MetricsConfig config) {
        STATS_PROVIDER.setProvider(config);
        DYNAMIC_LOGGER.setLogger(STATS_PROVIDER.createDynamicLogger());
    }

    public static synchronized StatsProvider getMetricsProvider() {
        return STATS_PROVIDER;
    }

    public static synchronized StatsLogger createStatsLogger(String loggerName) {
        return STATS_PROVIDER.createStatsLogger(loggerName);
    }

    public static synchronized DynamicLogger getDynamicLogger() {
        return DYNAMIC_LOGGER;
    }
}

