/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.metrics.OpStatsData;
import io.pravega.shared.metrics.OpStatsLogger;
import java.time.Duration;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

class OpStatsLoggerImpl
implements OpStatsLogger {
    private final Timer success;
    private final Timer fail;
    private final MeterRegistry meterRegistry;

    OpStatsLoggerImpl(MeterRegistry metricRegistry, String statName, String ... tags) {
        this.meterRegistry = (MeterRegistry)Preconditions.checkNotNull((Object)metricRegistry, (Object)"metrics");
        this.success = Timer.builder((String)statName).tags(tags).publishPercentiles(OpStatsData.PERCENTILE_ARRAY).register(this.meterRegistry);
        this.fail = Timer.builder((String)MetricsNames.failMetricName(statName)).tags(tags).publishPercentiles(OpStatsData.PERCENTILE_ARRAY).register(this.meterRegistry);
    }

    @Override
    public void close() {
        this.meterRegistry.remove((Meter)this.success);
        this.meterRegistry.remove((Meter)this.fail);
    }

    @Override
    public Meter.Id getId() {
        return this.success.getId();
    }

    @Override
    public void reportFailEvent(Duration duration) {
        this.fail.record(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void reportSuccessEvent(Duration duration) {
        this.success.record(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void reportSuccessValue(long value) {
        this.success.record(value, TimeUnit.MILLISECONDS);
    }

    @Override
    public void reportFailValue(long value) {
        this.fail.record(value, TimeUnit.MILLISECONDS);
    }

    @Override
    public void clear() {
    }

    @Override
    public OpStatsData toOpStatsData() {
        long numFailed = this.fail.count();
        long numSuccess = this.success.count();
        HistogramSnapshot snapshot = this.success.takeSnapshot();
        double avgLatencyMillis = snapshot.mean();
        EnumMap<OpStatsData.Percentile, Long> percentileLongMap = new EnumMap<OpStatsData.Percentile, Long>(OpStatsData.Percentile.class);
        if (OpStatsData.PERCENTILE_ARRAY.length == snapshot.percentileValues().length) {
            int index = 0;
            for (OpStatsData.Percentile percent : OpStatsData.PERCENTILE_SET) {
                percentileLongMap.put(percent, (long)snapshot.percentileValues()[index++].value());
            }
        }
        return new OpStatsData(numSuccess, numFailed, avgLatencyMillis, percentileLongMap);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpStatsLoggerImpl)) {
            return false;
        }
        OpStatsLoggerImpl other = (OpStatsLoggerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Timer this$success = this.success;
        Timer other$success = other.success;
        if (this$success == null ? other$success != null : !this$success.equals(other$success)) {
            return false;
        }
        Timer this$fail = this.fail;
        Timer other$fail = other.fail;
        if (this$fail == null ? other$fail != null : !this$fail.equals(other$fail)) {
            return false;
        }
        MeterRegistry this$meterRegistry = this.meterRegistry;
        MeterRegistry other$meterRegistry = other.meterRegistry;
        return !(this$meterRegistry == null ? other$meterRegistry != null : !this$meterRegistry.equals(other$meterRegistry));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpStatsLoggerImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Timer $success = this.success;
        result = result * 59 + ($success == null ? 43 : $success.hashCode());
        Timer $fail = this.fail;
        result = result * 59 + ($fail == null ? 43 : $fail.hashCode());
        MeterRegistry $meterRegistry = this.meterRegistry;
        result = result * 59 + ($meterRegistry == null ? 43 : $meterRegistry.hashCode());
        return result;
    }
}

