/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.Gauge;
import io.pravega.shared.metrics.Meter;
import io.pravega.shared.metrics.NullStatsLogger;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.OpStatsLoggerImpl;
import io.pravega.shared.metrics.StatsLogger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsLoggerImpl
implements StatsLogger {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatsLoggerImpl.class);
    private final MeterRegistry metrics;

    StatsLoggerImpl(MeterRegistry metrics) {
        this.metrics = (MeterRegistry)Preconditions.checkNotNull((Object)metrics, (Object)"metrics");
    }

    @Override
    public OpStatsLogger createStats(String statName, String ... tags) {
        try {
            return new OpStatsLoggerImpl(this.metrics, statName, tags);
        }
        catch (Exception e) {
            log.warn("createStats failure: {}", (Object)statName, (Object)e);
            return NullStatsLogger.NULLOPSTATSLOGGER;
        }
    }

    @Override
    public Counter createCounter(String statName, String ... tags) {
        try {
            return new CounterImpl(statName, tags);
        }
        catch (Exception e) {
            log.warn("createCounter failure: {}", (Object)statName, (Object)e);
            return NullStatsLogger.NULLCOUNTER;
        }
    }

    @Override
    public Gauge registerGauge(String statName, Supplier<Number> valueSupplier, String ... tags) {
        try {
            return new GaugeImpl(statName, (Supplier)Preconditions.checkNotNull(valueSupplier), tags);
        }
        catch (Exception e) {
            log.warn("registerGauge failure: {}", (Object)statName, (Object)e);
            return NullStatsLogger.NULLGAUGE;
        }
    }

    @Override
    public Meter createMeter(String statName, String ... tags) {
        try {
            return new MeterImpl(statName, tags);
        }
        catch (Exception e) {
            log.warn("createMeter failure: {}", (Object)statName, (Object)e);
            return NullStatsLogger.NULLMETER;
        }
    }

    @Override
    public StatsLogger createScopeLogger(String scope) {
        return new StatsLoggerImpl(this.metrics);
    }

    private class MeterImpl
    implements Meter {
        private final DistributionSummary summary;
        private final Meter.Id id;

        MeterImpl(String statName, String ... tagPairs) {
            this.summary = DistributionSummary.builder((String)statName).tags(tagPairs).register(StatsLoggerImpl.this.metrics);
            this.id = this.summary == null ? null : this.summary.getId();
        }

        @Override
        public void close() {
            StatsLoggerImpl.this.metrics.remove((io.micrometer.core.instrument.Meter)this.summary);
        }

        @Override
        public void recordEvent() {
            this.summary.record(1.0);
        }

        @Override
        public void recordEvents(long n) {
            this.summary.record((double)n);
        }

        @Override
        public long getCount() {
            return (long)this.summary.totalAmount();
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Meter.Id getId() {
            return this.id;
        }
    }

    private class GaugeImpl
    implements Gauge {
        private final Meter.Id id;
        private final AtomicReference<Supplier<Number>> supplierReference = new AtomicReference();

        GaugeImpl(String statName, Supplier<Number> valueSupplier, String ... tagPairs) {
            Tags tags = Tags.of((String[])tagPairs);
            this.id = new Meter.Id(statName, tags, null, null, Meter.Type.GAUGE);
            this.supplierReference.set(valueSupplier);
            StatsLoggerImpl.this.metrics.gauge(statName, (Iterable)tags, this.supplierReference, obj -> ((Number)((Supplier)obj.get()).get()).doubleValue());
        }

        @Override
        public void setSupplier(Supplier<Number> supplier) {
            this.supplierReference.set((Supplier)Preconditions.checkNotNull(supplier));
        }

        @Override
        public Supplier<Number> getSupplier() {
            return this.supplierReference.get();
        }

        @Override
        public void close() {
            StatsLoggerImpl.this.metrics.remove(this.id);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Meter.Id getId() {
            return this.id;
        }
    }

    private class CounterImpl
    implements Counter {
        @GuardedBy(value="this")
        private io.micrometer.core.instrument.Counter counter;
        private final Tags tags;
        private final Meter.Id id;
        private final String name;

        CounterImpl(String statName, String ... tagPairs) {
            this.tags = Tags.of((String[])tagPairs);
            this.name = statName;
            this.counter = StatsLoggerImpl.this.metrics.counter(this.name, (Iterable)this.tags);
            this.id = this.counter.getId();
        }

        @Override
        public synchronized void close() {
            StatsLoggerImpl.this.metrics.remove((io.micrometer.core.instrument.Meter)this.counter);
        }

        @Override
        public synchronized void clear() {
            StatsLoggerImpl.this.metrics.remove(this.counter.getId());
            this.counter = StatsLoggerImpl.this.metrics.counter(this.name, (Iterable)this.tags);
        }

        @Override
        public synchronized long get() {
            return (long)this.counter.count();
        }

        @Override
        public synchronized void inc() {
            this.counter.increment();
        }

        @Override
        public synchronized void add(long delta) {
            this.counter.increment((double)delta);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Meter.Id getId() {
            return this.id;
        }
    }
}

