/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.CounterProxy;
import io.pravega.shared.metrics.Gauge;
import io.pravega.shared.metrics.GaugeProxy;
import io.pravega.shared.metrics.Meter;
import io.pravega.shared.metrics.MeterProxy;
import io.pravega.shared.metrics.Metric;
import io.pravega.shared.metrics.MetricProxy;
import io.pravega.shared.metrics.NullStatsLogger;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.OpStatsLoggerProxy;
import io.pravega.shared.metrics.StatsLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsLoggerProxy
implements StatsLogger {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatsLoggerProxy.class);
    private final AtomicReference<StatsLogger> statsLoggerRef = new AtomicReference<NullStatsLogger>(new NullStatsLogger());
    private final ConcurrentHashMap<String, OpStatsLoggerProxy> opStatsLoggers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CounterProxy> counters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MeterProxy> meters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, GaugeProxy> gauges = new ConcurrentHashMap();

    StatsLoggerProxy(StatsLogger logger) {
        this.statsLoggerRef.set(logger);
    }

    void setLogger(StatsLogger logger) {
        this.statsLoggerRef.set(logger);
        this.opStatsLoggers.values().forEach(v -> v.updateInstance(this.statsLoggerRef.get().createStats(v.getProxyName(), new String[0])));
        this.counters.values().forEach(v -> v.updateInstance(this.statsLoggerRef.get().createCounter(v.getProxyName(), new String[0])));
        this.meters.values().forEach(v -> v.updateInstance(this.statsLoggerRef.get().createMeter(v.getProxyName(), new String[0])));
        this.gauges.values().forEach(v -> v.updateInstance(this.statsLoggerRef.get().registerGauge(v.getProxyName(), v.getSupplier(), new String[0])));
    }

    @Override
    public OpStatsLogger createStats(String name, String ... tags) {
        return StatsLoggerProxy.getOrSet(this.opStatsLoggers, name, metricName -> this.statsLoggerRef.get().createStats((String)metricName, tags), OpStatsLoggerProxy::new, tags);
    }

    @Override
    public Counter createCounter(String name, String ... tags) {
        return StatsLoggerProxy.getOrSet(this.counters, name, metricName -> this.statsLoggerRef.get().createCounter((String)metricName, tags), CounterProxy::new, tags);
    }

    @Override
    public Meter createMeter(String name, String ... tags) {
        return StatsLoggerProxy.getOrSet(this.meters, name, metricName -> this.statsLoggerRef.get().createMeter((String)metricName, tags), MeterProxy::new, tags);
    }

    @Override
    public Gauge registerGauge(String name, Supplier<Number> supplier, String ... tags) {
        return StatsLoggerProxy.getOrSet(this.gauges, name, metricName -> this.statsLoggerRef.get().registerGauge((String)metricName, supplier, tags), (metric, proxyName, c) -> new GaugeProxy((Gauge)metric, proxyName, c), tags);
    }

    @Override
    public StatsLogger createScopeLogger(String scope) {
        StatsLogger logger = this.statsLoggerRef.get().createScopeLogger(scope);
        return new StatsLoggerProxy(logger);
    }

    private static <T extends Metric, V extends MetricProxy<T, V>> V getOrSet(ConcurrentHashMap<String, V> cache, String name, Function<String, T> createMetric, ProxyCreator<T, V> createProxy, String ... tags) {
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Consumer<MetricProxy> closeCallback = m -> cache.remove(m.getProxyName(), m);
        return (V)cache.computeIfAbsent(keys.getCacheKey(), k -> {
            Metric newMetric = (Metric)createMetric.apply(keys.getRegistryKey());
            return (MetricProxy)createProxy.apply(newMetric, keys.getCacheKey(), closeCallback);
        });
    }

    private static interface ProxyCreator<T1, R> {
        public R apply(T1 var1, String var2, Consumer<R> var3);
    }
}

