/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.influx.InfluxMeterRegistry;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.DynamicLoggerImpl;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.RegistryConfigUtil;
import io.pravega.shared.metrics.StatsLogger;
import io.pravega.shared.metrics.StatsLoggerImpl;
import io.pravega.shared.metrics.StatsProvider;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatsProviderImpl
implements StatsProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatsProviderImpl.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private final CompositeMeterRegistry metrics;
    private final MetricsConfig conf;

    StatsProviderImpl(MetricsConfig conf) {
        this(conf, Metrics.globalRegistry);
    }

    @VisibleForTesting
    StatsProviderImpl(MetricsConfig conf, CompositeMeterRegistry registry) {
        this.conf = (MetricsConfig)Preconditions.checkNotNull((Object)conf, (Object)"conf");
        this.metrics = registry;
        this.metrics.config().commonTags(MetricsTags.createHostTag("HOSTNAME"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.$lock;
        synchronized (object) {
            new JvmMemoryMetrics().bindTo((MeterRegistry)this.metrics);
            new JvmGcMetrics().bindTo((MeterRegistry)this.metrics);
            new ProcessorMetrics().bindTo((MeterRegistry)this.metrics);
            new JvmThreadMetrics().bindTo((MeterRegistry)this.metrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.$lock;
        synchronized (object) {
            log.info("Metrics prefix: {}", (Object)this.conf.getMetricsPrefix());
            if (this.conf.isEnableStatsDReporter()) {
                this.metrics.add((MeterRegistry)new StatsdMeterRegistry(RegistryConfigUtil.createStatsDConfig(this.conf), Clock.SYSTEM));
            }
            if (this.conf.isEnableInfluxDBReporter()) {
                this.metrics.add((MeterRegistry)new InfluxMeterRegistry(RegistryConfigUtil.createInfluxConfig(this.conf), Clock.SYSTEM));
            }
            Preconditions.checkArgument((this.metrics.getRegistries().size() != 0 ? 1 : 0) != 0, (Object)"No meter register bound hence no storage for metrics!");
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWithoutExporting() {
        Object object = this.$lock;
        synchronized (object) {
            for (MeterRegistry registry : new ArrayList(this.metrics.getRegistries())) {
                this.metrics.remove(registry);
            }
            Metrics.addRegistry((MeterRegistry)new SimpleMeterRegistry());
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            for (MeterRegistry registry : this.metrics.getRegistries()) {
                registry.close();
                this.metrics.remove(registry);
            }
        }
    }

    @Override
    public StatsLogger createStatsLogger(String name) {
        return new StatsLoggerImpl((MeterRegistry)this.getMetrics());
    }

    @Override
    public DynamicLogger createDynamicLogger() {
        return new DynamicLoggerImpl(this.conf, (MeterRegistry)this.metrics, new StatsLoggerImpl((MeterRegistry)this.getMetrics()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompositeMeterRegistry getMetrics() {
        return this.metrics;
    }
}

