/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.HealthEndpoint;
import io.pravega.shared.health.HealthServiceUpdater;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.StatusAggregator;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import io.pravega.shared.health.impl.HealthEndpointImpl;
import io.pravega.shared.health.impl.HealthServiceUpdaterImpl;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthServiceManager
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthServiceManager.class);
    @VisibleForTesting
    private final HealthContributor root = new RootHealthContributor();
    private final HealthServiceUpdater updater;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HealthEndpoint endpoint;

    public HealthServiceManager(Duration interval) {
        this.updater = new HealthServiceUpdaterImpl(this.root, interval);
        this.endpoint = new HealthEndpointImpl(this.root, this.updater);
    }

    public HealthEndpoint getEndpoint() {
        return this.endpoint;
    }

    @VisibleForTesting
    HealthServiceUpdater getHealthServiceUpdater() {
        return this.updater;
    }

    public void start() {
        this.updater.startAsync();
        this.updater.awaitRunning();
    }

    public void register(HealthContributor ... children) {
        for (HealthContributor child : children) {
            this.root.register(child);
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.updater.close();
            this.updater.stopAsync();
            this.updater.awaitTerminated();
            this.root.close();
        }
    }

    public String getName() {
        return this.root.getName();
    }

    public Health getHealthSnapshot() {
        return this.root.getHealthSnapshot();
    }

    private static class RootHealthContributor
    extends AbstractHealthContributor {
        RootHealthContributor() {
            super("", StatusAggregator.UNANIMOUS);
        }

        @Override
        public Status doHealthCheck(Health.HealthBuilder builder) {
            Status status = Status.UP;
            builder.status(status);
            return status;
        }
    }
}

