/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health;

import io.pravega.shared.health.Status;
import java.util.Collection;
import java.util.function.Function;

public enum StatusAggregator {
    MAJORITY(StatusAggregator::majority),
    UNANIMOUS(StatusAggregator::unanimous),
    ANY(StatusAggregator::any);

    private final Function<Collection<Status>, Status> rule;

    private StatusAggregator(Function<Collection<Status>, Status> rule) {
        this.rule = rule;
    }

    public static Status majority(Collection<Status> statuses) {
        if (statuses.isEmpty()) {
            return Status.UNKNOWN;
        }
        int isAliveStatus = 0;
        for (Status status : statuses) {
            isAliveStatus += status.isAlive() ? 1 : -1;
        }
        return isAliveStatus > 0 ? Status.UP : Status.DOWN;
    }

    public static Status unanimous(Collection<Status> statuses) {
        if (statuses.isEmpty()) {
            return Status.UNKNOWN;
        }
        if (statuses.stream().allMatch(Status::isAlive)) {
            return Status.UP;
        }
        return Status.DOWN;
    }

    public static Status any(Collection<Status> statuses) {
        if (statuses.isEmpty()) {
            return Status.UNKNOWN;
        }
        if (statuses.stream().anyMatch(Status::isAlive)) {
            return Status.UP;
        }
        return Status.DOWN;
    }

    public static Status aggregate(StatusAggregator aggregator, Collection<Status> statuses) {
        return aggregator.rule.apply(statuses);
    }
}

