/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.StatusAggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractHealthContributor
implements HealthContributor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHealthContributor.class);
    @NonNull
    private final StatusAggregator aggregator;
    @NonNull
    private final String name;
    private Status status;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Map<String, HealthContributor> contributors = new ConcurrentHashMap<String, HealthContributor>();

    public AbstractHealthContributor(@NonNull String name) {
        this(name, StatusAggregator.UNANIMOUS);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    public AbstractHealthContributor(@NonNull String name, @NonNull StatusAggregator aggregator) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (aggregator == null) {
            throw new NullPointerException("aggregator is marked non-null but is null");
        }
        this.name = name;
        this.aggregator = aggregator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized Health getHealthSnapshot() {
        Exceptions.checkNotClosed((boolean)this.isClosed(), (Object)this);
        Health.HealthBuilder builder = Health.builder().name(this.getName());
        ArrayList<Status> statuses = new ArrayList<Status>();
        HashMap<String, Health> children = new HashMap<String, Health>();
        for (Map.Entry<String, HealthContributor> entry : this.contributors.entrySet()) {
            HealthContributor contributor;
            HealthContributor healthContributor = contributor = entry.getValue();
            synchronized (healthContributor) {
                if (!contributor.isClosed()) {
                    Health health = contributor.getHealthSnapshot();
                    children.put(entry.getKey(), health);
                    statuses.add(health.getStatus());
                } else {
                    this.contributors.remove(this.name);
                }
            }
        }
        Status status = Status.DOWN;
        try {
            status = this.doHealthCheck(builder);
        }
        catch (Exception ex) {
            log.warn("HealthCheck for {} has failed.", (Object)this.name, (Object)ex);
            builder.status(Status.FAILED);
        }
        this.status = status = statuses.isEmpty() ? status : Status.min(StatusAggregator.aggregate(this.aggregator, statuses), status);
        return builder.name(this.name).status(status).children(children).build();
    }

    @Override
    public final synchronized void register(HealthContributor ... children) {
        Exceptions.checkNotClosed((boolean)this.isClosed(), (Object)this);
        for (HealthContributor child : children) {
            if (child.getName().contains("/")) {
                log.warn("The supplied HealthContributor contains the lookup delimiter ('{}') -- skipping.", (Object)"/");
                continue;
            }
            this.contributors.put(child.getName(), child);
        }
    }

    @Override
    public final synchronized void close() {
        if (!this.closed.getAndSet(true)) {
            for (Map.Entry<String, HealthContributor> contributor : this.contributors.entrySet()) {
                contributor.getValue().close();
            }
            this.contributors.clear();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed.get();
    }

    public abstract Status doHealthCheck(Health.HealthBuilder var1) throws Exception;

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StatusAggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }
}

