/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.health.ContributorNotFoundException;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.HealthEndpoint;
import io.pravega.shared.health.HealthServiceUpdater;
import io.pravega.shared.health.Status;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthEndpointImpl
implements HealthEndpoint {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthEndpointImpl.class);
    @NonNull
    private final HealthContributor root;
    @NonNull
    private final HealthServiceUpdater updater;

    @Override
    public String getDefaultContributorName() {
        return this.root.getName();
    }

    @Override
    @NonNull
    public Health getHealth(String id) {
        Health health;
        if (id == null || id.equals(this.root.getName())) {
            health = this.updater.getLatestHealth();
        } else {
            List<String> path = Arrays.asList(id.split("/"));
            health = this.search(path, this.updater.getLatestHealth());
        }
        if (health == null) {
            throw new ContributorNotFoundException(String.format("No HealthContributor found with name '%s'", id), 404);
        }
        return health;
    }

    @Override
    public Health getHealth() {
        return this.getHealth(this.root.getName());
    }

    @Override
    public Status getStatus(String id) {
        return this.getHealth(id).getStatus();
    }

    @Override
    public boolean isReady(String id) {
        return this.getHealth(id).isReady();
    }

    @Override
    public boolean isAlive(String id) {
        return this.getHealth(id).isAlive();
    }

    @Override
    public Map<String, Object> getDetails(String id) {
        return this.getHealth(id).getDetails();
    }

    private Health search(List<String> path, Health current) {
        Health child = current;
        for (String id : path) {
            child = current.getChildren().get(id);
            if (child != null) {
                current = child;
                continue;
            }
            return null;
        }
        return child;
    }

    @ConstructorProperties(value={"root", "updater"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthEndpointImpl(@NonNull HealthContributor root, @NonNull HealthServiceUpdater updater) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        this.root = root;
        this.updater = updater;
    }
}

