/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health.impl;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.Services;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.HealthServiceUpdater;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthServiceUpdaterImpl
extends AbstractScheduledService
implements HealthServiceUpdater {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthServiceUpdaterImpl.class);
    private static final Health INITIAL_HEALTH = Health.builder().build();
    private final AtomicReference<Health> latest = new AtomicReference<Health>(INITIAL_HEALTH);
    private final HealthContributor root;
    private final Duration interval;
    private final ScheduledExecutorService executorService = ExecutorServiceHelpers.newScheduledThreadPool((int)1, (String)"health-service-updater", (int)1);

    @Override
    public Health getLatestHealth() {
        return this.latest.get();
    }

    protected ScheduledExecutorService executor() {
        return this.executorService;
    }

    protected void runOneIteration() {
        this.latest.set(this.root.getHealthSnapshot());
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((Duration)this.interval, (Duration)this.interval);
    }

    protected void startUp() {
        log.info("Starting the HealthServiceUpdater, running at {} intervals.", (Object)this.interval);
    }

    protected void shutDown() {
        log.info("Shutting down the HealthServiceUpdater.");
        this.latest.set(INITIAL_HEALTH);
    }

    @Override
    public void close() {
        if (this.isRunning()) {
            this.shutDown();
        }
        if (this.state() == Service.State.RUNNING) {
            Futures.await((CompletableFuture)Services.stopAsync((Service)this, (Executor)this.executorService));
        }
        log.info("Stopping ScheduledExecutorService.");
        ExecutorServiceHelpers.shutdown((Duration)Duration.ofSeconds(5L), (ExecutorService[])new ExecutorService[]{this.executorService});
    }

    @ConstructorProperties(value={"root", "interval"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthServiceUpdaterImpl(HealthContributor root, Duration interval) {
        this.root = root;
        this.interval = interval;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getInterval() {
        return this.interval;
    }
}

