/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.NflyFSystem;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFileSystemOverloadSchemeWithHdfsScheme {
    private static final String TEST_STRING = "Hello ViewFSOverloadedScheme!";
    private static final String FS_IMPL_PATTERN_KEY = "fs.%s.impl";
    private static final String HDFS_SCHEME = "hdfs";
    private Configuration conf = null;
    private static MiniDFSCluster cluster = null;
    private URI defaultFSURI;
    private File localTargetDir;
    private static final String TEST_ROOT_DIR = PathUtils.getTestDirName(TestViewFileSystemOverloadSchemeWithHdfsScheme.class);
    private static final String HDFS_USER_FOLDER = "/HDFSUser";
    private static final String LOCAL_FOLDER = "/local";

    @BeforeClass
    public static void init() throws IOException {
        cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(2).build();
        cluster.waitClusterUp();
    }

    @Before
    public void setUp() throws IOException {
        Configuration config = this.getNewConf();
        config.setInt("ipc.client.connect.max.retries", 1);
        config.set(String.format(FS_IMPL_PATTERN_KEY, HDFS_SCHEME), ViewFileSystemOverloadScheme.class.getName());
        config.setBoolean("fs.viewfs.ignore.port.in.mount.table.name", false);
        this.setConf(config);
        this.defaultFSURI = URI.create(config.get("fs.defaultFS"));
        this.localTargetDir = new File(TEST_ROOT_DIR, "/root/");
        this.localTargetDir.mkdirs();
        Assert.assertEquals((Object)HDFS_SCHEME, (Object)this.defaultFSURI.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void cleanUp() throws IOException {
        if (cluster != null) {
            fs.initialize(this.defaultFSURI, this.conf);
            try (DistributedFileSystem fs = new DistributedFileSystem();){
                FileStatus[] statuses;
                for (FileStatus st : statuses = fs.listStatus(new Path("/"))) {
                    Assert.assertTrue((boolean)fs.delete(st.getPath(), true));
                }
            }
            FileSystem.closeAll();
        }
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (cluster != null) {
            FileSystem.closeAll();
            cluster.shutdown();
        }
    }

    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration config) throws IOException, URISyntaxException {
        ViewFsTestSetup.addMountLinksToConf((String)mountTable, (String[])sources, (String[])targets, (Configuration)config);
    }

    @Test(timeout=30000L)
    public void testMountLinkWithLocalAndHDFS() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        Path localTragetPath = new Path(this.localTargetDir.toURI());
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        Path hdfsFile = new Path("/HDFSUser/testfile");
        Path localDir = new Path("/local/test");
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            Assert.assertEquals((long)2L, (long)fs.getChildFileSystems().length);
            fs.createNewFile(hdfsFile);
            fs.mkdirs(localDir);
        }
        var6_6 = null;
        try (DistributedFileSystem dfs = new DistributedFileSystem();){
            dfs.initialize(this.defaultFSURI, this.conf);
            Assert.assertTrue((boolean)dfs.exists(new Path(Path.getPathWithoutSchemeAndAuthority((Path)hdfsTargetPath), hdfsFile.getName())));
            Assert.assertFalse((boolean)dfs.exists(new Path(Path.getPathWithoutSchemeAndAuthority((Path)localTragetPath), localDir.getName())));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        var6_6 = null;
        try (RawLocalFileSystem lfs = new RawLocalFileSystem();){
            lfs.initialize(localTragetPath.toUri(), this.conf);
            Assert.assertFalse((boolean)lfs.exists(new Path(Path.getPathWithoutSchemeAndAuthority((Path)hdfsTargetPath), hdfsFile.getName())));
            Assert.assertTrue((boolean)lfs.exists(new Path(Path.getPathWithoutSchemeAndAuthority((Path)localTragetPath), localDir.getName())));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test(timeout=30000L)
    public void testMountLinkWithNonExistentLink() throws Exception {
        this.testMountLinkWithNonExistentLink(true);
    }

    public void testMountLinkWithNonExistentLink(boolean expectFsInitFailure) throws Exception {
        String userFolder = "/User";
        Path nonExistTargetPath = new Path("nonexistent://NonExistent/User");
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{"/User"}, new String[]{nonExistTargetPath.toUri().toString()}, this.conf);
        if (expectFsInitFailure) {
            LambdaTestUtils.intercept(IOException.class, () -> FileSystem.get((Configuration)this.conf));
        } else {
            try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
                Assert.assertEquals((Object)HDFS_SCHEME, (Object)fs.getScheme());
            }
        }
    }

    @Test(timeout=30000L)
    public void testListStatusOnRootShouldListAllMountLinks() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        try (DistributedFileSystem dfs = new DistributedFileSystem();){
            dfs.initialize(this.defaultFSURI, this.conf);
            dfs.mkdirs(hdfsTargetPath);
        }
        var3_3 = null;
        try (RawLocalFileSystem lfs = new RawLocalFileSystem();){
            lfs.initialize(this.localTargetDir.toURI(), this.conf);
            lfs.mkdirs(new Path(this.localTargetDir.toURI()));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        var3_3 = null;
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            fs.mkdirs(hdfsTargetPath);
            FileStatus[] ls = fs.listStatus(new Path("/"));
            Assert.assertEquals((long)2L, (long)ls.length);
            String lsPath1 = Path.getPathWithoutSchemeAndAuthority((Path)ls[0].getPath()).toString();
            String lsPath2 = Path.getPathWithoutSchemeAndAuthority((Path)ls[1].getPath()).toString();
            Assert.assertTrue((HDFS_USER_FOLDER.equals(lsPath1) || LOCAL_FOLDER.equals(lsPath1) ? 1 : 0) != 0);
            Assert.assertTrue((HDFS_USER_FOLDER.equals(lsPath2) || LOCAL_FOLDER.equals(lsPath2) ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test(expected=IOException.class, timeout=30000L)
    public void testListStatusOnNonMountedPath() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            fs.listStatus(new Path("/nonMount"));
            Assert.fail((String)"It should fail as no mount link with /nonMount");
        }
    }

    @Test
    public void testAccessViewFsPathWithoutAuthority() throws Exception {
        FileStatus[] expectedStatus;
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        Path hdfsDir = new Path(HDFS_USER_FOLDER, "test");
        Path localDir = new Path(LOCAL_FOLDER, "test");
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            fs.mkdirs(hdfsDir);
            fs.mkdirs(localDir);
            expectedStatus = fs.listStatus(new Path("/"));
        }
        Path viewFsRootPath = new Path("viewfs:/");
        LambdaTestUtils.intercept(IOException.class, (String)"Empty Mount table in config for viewfs://default", () -> viewFsRootPath.getFileSystem(this.conf));
        this.conf.set("fs.viewfs.mounttable.default.name.key", this.defaultFSURI.getAuthority());
        try (FileSystem fs = viewFsRootPath.getFileSystem(this.conf);){
            FileStatus[] status = fs.listStatus(viewFsRootPath);
            List expectedPaths = Arrays.stream(expectedStatus).map(s -> s.getPath().getName()).sorted().collect(Collectors.toList());
            List paths = Arrays.stream(status).map(s -> s.getPath().getName()).sorted().collect(Collectors.toList());
            Assert.assertEquals(expectedPaths, paths);
        }
    }

    @Test(timeout=30000L)
    public void testWithLinkFallBack() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER, "linkFallback"}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString(), hdfsTargetPath.toUri().toString()}, this.conf);
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            fs.createNewFile(new Path("/nonMount/myfile"));
            FileStatus[] ls = fs.listStatus(new Path("/nonMount"));
            Assert.assertEquals((long)1L, (long)ls.length);
            Assert.assertEquals((Object)Path.getPathWithoutSchemeAndAuthority((Path)ls[0].getPath()).getName(), (Object)"myfile");
        }
    }

    @Test(timeout=30000L)
    public void testCreateOnRoot() throws Exception {
        this.testCreateOnRoot(false);
    }

    public void testCreateOnRoot(boolean fallbackExist) throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            if (fallbackExist) {
                Assert.assertTrue((boolean)fs.createNewFile(new Path("/newFileOnRoot")));
            } else {
                LambdaTestUtils.intercept(NotInMountpointException.class, () -> fs.createNewFile(new Path("/newFileOnRoot")));
            }
        }
    }

    @Test(expected=UnsupportedFileSystemException.class, timeout=30000L)
    public void testInvalidOverloadSchemeTargetFS() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        String mountTableIfSet = this.conf.get("fs.viewfs.mounttable.path");
        this.conf = new Configuration();
        if (mountTableIfSet != null) {
            this.conf.set("fs.viewfs.mounttable.path", mountTableIfSet);
        }
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER, "linkFallback"}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString(), hdfsTargetPath.toUri().toString()}, this.conf);
        this.conf.set("fs.defaultFS", this.defaultFSURI.toString());
        this.conf.set(String.format(FS_IMPL_PATTERN_KEY, HDFS_SCHEME), ViewFileSystemOverloadScheme.class.getName());
        this.conf.unset(String.format("fs.viewfs.overload.scheme.target.%s.impl", HDFS_SCHEME));
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            fs.createNewFile(new Path("/onRootWhenFallBack"));
            Assert.fail((String)"OverloadScheme target fs should be valid.");
        }
    }

    @Test(timeout=30000L)
    public void testViewFsOverloadSchemeWhenInnerCacheDisabled() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString()}, this.conf);
        this.conf.setBoolean("fs.viewfs.enable.inner.cache", false);
        try (FileSystem fs = FileSystem.get((Configuration)this.conf);){
            Path testFile = new Path("/HDFSUser/testFile");
            fs.createNewFile(testFile);
            Assert.assertTrue((boolean)fs.exists(testFile));
        }
    }

    @Test(timeout=30000L)
    public void testViewFsOverloadSchemeWithInnerCache() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{"/HDFSUser0", "/HDFSUser1"}, new String[]{hdfsTargetPath.toUri().toString(), hdfsTargetPath.toUri().toString()}, this.conf);
        try (FileSystem vfs = FileSystem.get((Configuration)this.conf);){
            Assert.assertEquals((long)1L, (long)vfs.getChildFileSystems().length);
        }
        this.conf.setBoolean("fs.viewfs.enable.inner.cache", false);
        vfs = FileSystem.get((Configuration)this.conf);
        var3_3 = null;
        try {
            Assert.assertEquals((long)(this.isFallBackExist(this.conf) ? 3L : 2L), (long)vfs.getChildFileSystems().length);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (vfs != null) {
                if (var3_3 != null) {
                    try {
                        vfs.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    vfs.close();
                }
            }
        }
    }

    private boolean isFallBackExist(Configuration config) {
        return config.get(ConfigUtil.getConfigViewFsPrefix((String)this.defaultFSURI.getAuthority()) + "." + "linkFallback") != null;
    }

    @Test(timeout=3000L)
    public void testViewFsOverloadSchemeWithNoInnerCacheAndHdfsTargets() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{"/HDFSUser0", "/HDFSUser1"}, new String[]{hdfsTargetPath.toUri().toString(), hdfsTargetPath.toUri().toString()}, this.conf);
        this.conf.setBoolean("fs.viewfs.enable.inner.cache", false);
        try (FileSystem vfs = FileSystem.get((Configuration)this.conf);){
            Assert.assertEquals((long)(this.isFallBackExist(this.conf) ? 3L : 2L), (long)vfs.getChildFileSystems().length);
        }
    }

    @Test(timeout=3000L)
    public void testViewFsOverloadSchemeWithNoInnerCacheAndLocalSchemeTargets() throws Exception {
        Path localTragetPath = new Path(this.localTargetDir.toURI());
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{"/local0", "/local1"}, new String[]{localTragetPath.toUri().toString(), localTragetPath.toUri().toString()}, this.conf);
        this.conf.setBoolean("fs.viewfs.enable.inner.cache", false);
        try (FileSystem vfs = FileSystem.get((Configuration)this.conf);){
            Assert.assertEquals((long)(this.isFallBackExist(this.conf) ? 2L : 1L), (long)vfs.getChildFileSystems().length);
        }
    }

    @Test(timeout=3000L)
    public void testNflyRename() throws Exception {
        URI[] testUris;
        Path hdfsTargetPath1 = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        Path hdfsTargetPath2 = new Path(this.defaultFSURI + HDFS_USER_FOLDER + 1);
        URI uri1 = hdfsTargetPath1.toUri();
        URI uri2 = hdfsTargetPath2.toUri();
        Path nflyRoot = new Path("/nflyroot");
        String nflyLinkKey = "linkNfly.minReplication=2." + nflyRoot.toString();
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{nflyLinkKey}, new String[]{uri1.toString() + "," + uri2.toString()}, this.conf);
        FileSystem nfly = FileSystem.get((URI)this.defaultFSURI, (Configuration)this.conf);
        Path testDir = new Path("/nflyroot/testdir1/sub1/sub3");
        Path testDirTmp = new Path("/nflyroot/testdir1/sub1/sub3_temp");
        Assert.assertTrue((String)(testDir + ": Failed to create!"), (boolean)nfly.mkdirs(testDir));
        Assert.assertTrue((boolean)nfly.rename(testDir, testDirTmp));
        Assert.assertTrue((boolean)nfly.rename(testDirTmp, testDir));
        for (URI testUri : testUris = new URI[]{uri1, uri2}) {
            FileSystem fs = FileSystem.get((URI)testUri, (Configuration)this.conf);
            Assert.assertTrue((String)(testDir + " should exist!"), (boolean)fs.exists(testDir));
        }
    }

    @Test(timeout=3000L)
    public void testNflyWriteRead() throws Exception {
        URI[] testUris;
        Path hdfsTargetPath1 = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        Path hdfsTargetPath2 = new Path(this.defaultFSURI + HDFS_USER_FOLDER + 1);
        URI uri1 = hdfsTargetPath1.toUri();
        URI uri2 = hdfsTargetPath2.toUri();
        Path nflyRoot = new Path("/nflyroot");
        String nflyLinkKey = "linkNfly.minReplication=2." + nflyRoot.toString();
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{nflyLinkKey}, new String[]{uri1.toString() + "," + uri2.toString()}, this.conf);
        FileSystem nfly = FileSystem.get((URI)this.defaultFSURI, (Configuration)this.conf);
        Path testFile = new Path("/nflyroot/test.txt");
        this.writeString(nfly, TEST_STRING, testFile);
        for (URI testUri : testUris = new URI[]{uri1, uri2}) {
            try (FileSystem fs = FileSystem.get((URI)testUri, (Configuration)this.conf);){
                this.readString(fs, testFile, TEST_STRING, testUri);
            }
        }
    }

    @Test(timeout=3000L)
    public void testNflyRepair() throws Exception {
        NflyFSystem.NflyKey repairKey = NflyFSystem.NflyKey.repairOnRead;
        Path hdfsTargetPath1 = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        Path hdfsTargetPath2 = new Path(this.defaultFSURI + HDFS_USER_FOLDER + 1);
        URI uri1 = hdfsTargetPath1.toUri();
        URI uri2 = hdfsTargetPath2.toUri();
        Path nflyRoot = new Path("/nflyroot");
        String nflyLinkKey = "linkNfly.minReplication=2," + repairKey + "=true." + nflyRoot.toString();
        this.addMountLinks(this.defaultFSURI.getAuthority(), new String[]{nflyLinkKey}, new String[]{uri1.toString() + "," + uri2.toString()}, this.conf);
        try (FileSystem nfly = FileSystem.get((URI)this.defaultFSURI, (Configuration)this.conf);){
            Path testFilePath = new Path("/nflyroot/test.txt");
            this.writeString(nfly, TEST_STRING, testFilePath);
            URI[] testUris = new URI[]{uri1, uri2};
            ViewFileSystemOverloadScheme.ChildFsGetter getter = new ViewFileSystemOverloadScheme.ChildFsGetter(HDFS_SCHEME);
            try (FileSystem fs1 = getter.getNewInstance(testUris[0], this.conf);){
                String testFile = "/test.txt";
                Assert.assertTrue((boolean)fs1.delete(new Path(testUris[0].toString() + testFile), false));
                Assert.assertFalse((boolean)fs1.exists(new Path(testUris[0].toString() + testFile)));
                this.readString(nfly, testFilePath, TEST_STRING, testUris[0]);
                Assert.assertTrue((boolean)fs1.exists(new Path(testUris[0].toString() + testFile)));
            }
        }
    }

    @Test(timeout=30000L)
    public void testMountTableNameShouldIgnorePortFromURI() throws Exception {
        Path hdfsTargetPath = new Path(this.defaultFSURI + HDFS_USER_FOLDER);
        this.conf = new Configuration(this.getConf());
        this.addMountLinks(this.defaultFSURI.getHost(), new String[]{HDFS_USER_FOLDER, LOCAL_FOLDER, "linkFallback"}, new String[]{hdfsTargetPath.toUri().toString(), this.localTargetDir.toURI().toString(), hdfsTargetPath.toUri().toString()}, this.conf);
        this.conf.set("fs.defaultFS", this.defaultFSURI.toString());
        this.conf.set(String.format(FS_IMPL_PATTERN_KEY, HDFS_SCHEME), ViewFileSystemOverloadScheme.class.getName());
        this.conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", HDFS_SCHEME), DistributedFileSystem.class.getName());
        this.conf.setBoolean("fs.viewfs.ignore.port.in.mount.table.name", true);
        Path testDirOnRoot = new Path("/test");
        URI uriWithoutPort = new URI("hdfs://" + this.defaultFSURI.getHost());
        try (FileSystem fs = FileSystem.get((URI)uriWithoutPort, (Configuration)this.conf);){
            fs.mkdirs(testDirOnRoot);
            fs.delete(testDirOnRoot, true);
        }
        fs = FileSystem.get((URI)this.defaultFSURI, (Configuration)this.conf);
        var5_5 = null;
        try {
            fs.mkdirs(testDirOnRoot);
            fs.delete(testDirOnRoot, true);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (fs != null) {
                if (var5_5 != null) {
                    try {
                        fs.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    fs.close();
                }
            }
        }
    }

    private void writeString(FileSystem nfly, String testString, Path testFile) throws IOException {
        try (FSDataOutputStream fsDos = nfly.create(testFile);){
            fsDos.writeUTF(testString);
        }
    }

    private void readString(FileSystem nfly, Path testFile, String testString, URI testUri) throws IOException {
        try (FSDataInputStream fsDis = nfly.open(testFile);){
            Assert.assertEquals((String)"Wrong file content", (Object)testString, (Object)fsDis.readUTF());
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Configuration getNewConf() {
        return new Configuration(cluster.getConfiguration(0));
    }

    public void setConf(Configuration config) {
        this.conf = config;
    }
}

