/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDFSInputStreamBlockLocations {
    private static final int BLOCK_SIZE = 0x100000;
    private static final String[] RACKS = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
    private static final int NUM_DATA_NODES = RACKS.length;
    private static final short REPLICATION_FACTOR = 4;
    private final int staleInterval = 8000;
    private final int numOfBlocks = 24;
    private final int fileLength = 0x1800000;
    private final int dfsClientPrefetchSize = 0xC00000;
    private final long dfsInputLocationsTimeout = 3600000L;
    private HdfsConfiguration conf;
    private MiniDFSCluster dfsCluster;
    private DFSClient dfsClient;
    private DistributedFileSystem fs;
    private Path filePath;
    private boolean enableBlkExpiration;

    @Parameterized.Parameters(name="{index}: CacheExpirationConfig(Enable {0})")
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.TRUE}, {Boolean.FALSE});
    }

    public TestDFSInputStreamBlockLocations(Boolean enableExpiration) {
        this.enableBlkExpiration = enableExpiration;
    }

    @Before
    public void setup() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        this.conf.setLong("dfs.namenode.stale.datanode.interval", 8000L);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 4000);
        this.conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
        this.conf.setInt("dfs.replication", 4);
        this.conf.setLong("dfs.blocksize", 0x100000L);
        this.conf.setLong("dfs.client.read.prefetch.size", 0xC00000L);
        if (this.enableBlkExpiration) {
            this.conf.setLong("dfs.client.refresh.read-block-locations.ms", 3600000L);
        }
        this.dfsCluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(NUM_DATA_NODES).racks(RACKS).build();
        this.dfsCluster.waitActive();
        Assert.assertEquals((long)NUM_DATA_NODES, (long)this.dfsCluster.getDataNodes().size());
        InetSocketAddress addr = new InetSocketAddress("localhost", this.dfsCluster.getNameNodePort());
        this.dfsClient = new DFSClient(addr, (Configuration)this.conf);
        this.fs = this.dfsCluster.getFileSystem();
    }

    @After
    public void teardown() throws IOException {
        if (this.dfsClient != null) {
            this.dfsClient.close();
            this.dfsClient = null;
        }
        if (this.fs != null) {
            this.fs.deleteOnExit(this.filePath);
            this.fs.close();
            this.fs = null;
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRead() throws Exception {
        String fileName = "/test_cache_locations";
        this.filePath = new Path("/test_cache_locations");
        DFSInputStream fin = null;
        FSDataOutputStream fout = null;
        try {
            fout = this.fs.create(this.filePath, (short)4);
            fout.write(new byte[0x1800000]);
            fout.close();
            fout = null;
            LocatedBlocks referenceLocatedBlocks = this.dfsClient.getLocatedBlocks("/test_cache_locations", 0L, 0x1800000L);
            Assert.assertEquals((long)24L, (long)referenceLocatedBlocks.locatedBlockCount());
            String poolId = this.dfsCluster.getNamesystem().getBlockPoolId();
            fin = this.dfsClient.open("/test_cache_locations");
            LocatedBlocks finLocatedBlocks = fin.locatedBlocks;
            Assert.assertEquals((long)12L, (long)finLocatedBlocks.locatedBlockCount());
            int chunkReadSize = 262144;
            byte[] readBuffer = new byte[262144];
            DatanodeInfo prevDNInfo = null;
            DatanodeInfo currDNInfo = null;
            int bytesRead = 0;
            int firstBlockMark = 0x100000;
            LocatedBlock firstLocatedBlk = (LocatedBlock)fin.locatedBlocks.getLocatedBlocks().get(0);
            DatanodeInfoWithStorage[] firstBlkDNInfos = firstLocatedBlk.getLocations();
            while (fin.getPos() < (long)firstBlockMark) {
                bytesRead = fin.read(readBuffer);
                Assert.assertTrue((String)"Unexpected number of read bytes", (262144 >= bytesRead ? 1 : 0) != 0);
                if (currDNInfo == null) {
                    currDNInfo = fin.getCurrentDatanode();
                    Assert.assertNotNull((String)"current FIS datanode is null", (Object)currDNInfo);
                    continue;
                }
                prevDNInfo = currDNInfo;
                currDNInfo = fin.getCurrentDatanode();
                Assert.assertEquals((String)"the DFSInput stream does not read from same node", (Object)prevDNInfo, (Object)currDNInfo);
            }
            Assert.assertEquals((String)"InputStream exceeds expected position", (long)firstBlockMark, (long)fin.getPos());
            LocatedBlock secondLocatedBlk = (LocatedBlock)fin.locatedBlocks.getLocatedBlocks().get(1);
            DatanodeInfoWithStorage[] secondBlkDNInfos = secondLocatedBlk.getLocations();
            DatanodeInfoWithStorage deadNodeInfo = secondBlkDNInfos[0];
            DataNode deadNode = this.getdataNodeFromHostName(this.dfsCluster, deadNodeInfo.getHostName());
            DatanodeRegistration reg = InternalDataNodeTestUtils.getDNRegistrationForBP(this.dfsCluster.getDataNodes().get(0), poolId);
            MiniDFSCluster.DataNodeProperties stoppedDNProps = this.dfsCluster.stopDataNode(deadNodeInfo.getName());
            ArrayList<DataNode> datanodesPostStoppage = this.dfsCluster.getDataNodes();
            Assert.assertEquals((long)(NUM_DATA_NODES - 1), (long)datanodesPostStoppage.size());
            LocatedBlocks afterStoppageLocatedBlocks = this.dfsClient.getLocatedBlocks("/test_cache_locations", 0L, 0x1800000L);
            int secondBlockMark = 0x180000;
            boolean firstIteration = true;
            if (this.enableBlkExpiration) {
                fin.setReadTimeStampsForTesting(Time.monotonicNow());
            }
            while (fin.getPos() < (long)secondBlockMark) {
                bytesRead = fin.read(readBuffer);
                Assert.assertTrue((String)("dead node used to read at position: " + fin.getPos()), (boolean)fin.deadNodesContain((DatanodeInfo)deadNodeInfo));
                Assert.assertTrue((String)"Unexpected number of read bytes", (262144 >= bytesRead ? 1 : 0) != 0);
                prevDNInfo = currDNInfo;
                currDNInfo = fin.getCurrentDatanode();
                Assert.assertNotEquals((Object)deadNodeInfo, (Object)currDNInfo);
                if (!firstIteration) continue;
                Assert.assertFalse((String)"FSInputStream should pick a different DN", (firstBlkDNInfos[0].equals((Object)deadNodeInfo) && prevDNInfo.equals((Object)currDNInfo) ? 1 : 0) != 0);
                firstIteration = false;
            }
            Assert.assertEquals((String)"InputStream exceeds expected position", (long)secondBlockMark, (long)fin.getPos());
            Assert.assertTrue((boolean)this.dfsCluster.restartDataNode(stoppedDNProps, true));
            this.dfsCluster.waitActive();
            ArrayList<DataNode> datanodesPostRestart = this.dfsCluster.getDataNodes();
            Assert.assertEquals((long)NUM_DATA_NODES, (long)datanodesPostRestart.size());
            int thirdBlockMark = 0x200000;
            firstIteration = true;
            while (fin.getPos() < (long)thirdBlockMark) {
                bytesRead = fin.read(readBuffer);
                if (this.enableBlkExpiration) {
                    Assert.assertEquals((String)"node is removed from deadNodes after 1st iteration", (Object)firstIteration, (Object)fin.deadNodesContain((DatanodeInfo)deadNodeInfo));
                } else {
                    Assert.assertTrue((boolean)fin.deadNodesContain((DatanodeInfo)deadNodeInfo));
                }
                Assert.assertTrue((String)"Unexpected number of read bytes", (262144 >= bytesRead ? 1 : 0) != 0);
                prevDNInfo = currDNInfo;
                currDNInfo = fin.getCurrentDatanode();
                if (!this.enableBlkExpiration) {
                    Assert.assertNotEquals((Object)deadNodeInfo, (Object)currDNInfo);
                }
                if (!firstIteration) continue;
                Assert.assertEquals((Object)prevDNInfo, (Object)currDNInfo);
                firstIteration = false;
                if (!this.enableBlkExpiration) continue;
                fin.setReadTimeStampsForTesting(Time.monotonicNow() - 3600001L);
            }
            Assert.assertEquals((String)"InputStream exceeds expected position", (long)thirdBlockMark, (long)fin.getPos());
        }
        finally {
            if (fout != null) {
                fout.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    private DataNode getdataNodeFromHostName(MiniDFSCluster cluster, String hostName) {
        for (DataNode dn : cluster.getDataNodes()) {
            if (!dn.getDatanodeId().getHostName().equals(hostName)) continue;
            return dn;
        }
        return null;
    }
}

