/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.AdminStatesBaseTest;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDecommissioningStatus {
    private final long seed = 3735928559L;
    private final int blockSize = 8192;
    private final int fileSize = 16384;
    private final int numDatanodes = 2;
    private MiniDFSCluster cluster;
    private FileSystem fileSys;
    private HostsFileWriter hostsFileWriter;
    private Configuration conf;
    private Logger LOG;
    final ArrayList<String> decommissionedNodes = new ArrayList(2);

    protected MiniDFSCluster getCluster() {
        return this.cluster;
    }

    protected FileSystem getFileSys() {
        return this.fileSys;
    }

    protected HostsFileWriter getHostsFileWriter() {
        return this.hostsFileWriter;
    }

    protected Configuration setupConfig() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        this.hostsFileWriter = new HostsFileWriter();
        this.hostsFileWriter.initialize(this.conf, "work-dir/decommission");
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 4);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.conf.setInt("dfs.namenode.decommission.interval", 1);
        this.conf.setLong("dfs.datanode.balance.bandwidthPerSec", 1L);
        Logger.getLogger(DatanodeAdminManager.class).setLevel(Level.DEBUG);
        this.LOG = Logger.getLogger(TestDecommissioningStatus.class);
        return this.conf;
    }

    protected void createCluster() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
        this.fileSys = this.cluster.getFileSystem();
        this.cluster.getNamesystem().getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
    }

    @Before
    public void setUp() throws Exception {
        this.setupConfig();
        this.createCluster();
    }

    @After
    public void tearDown() throws Exception {
        if (this.hostsFileWriter != null) {
            this.hostsFileWriter.cleanup();
        }
        if (this.fileSys != null) {
            this.fileSys.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    protected String decommissionNode(DFSClient client, int nodeIndex) throws IOException {
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        String nodename = info[nodeIndex].getXferAddr();
        this.decommissionNode(nodename);
        return nodename;
    }

    protected void decommissionNode(String dnName) throws IOException {
        System.out.println("Decommissioning node: " + dnName);
        ArrayList<String> nodes = new ArrayList<String>(this.decommissionedNodes);
        nodes.add(dnName);
        this.hostsFileWriter.initExcludeHosts(nodes);
    }

    protected void checkDecommissionStatus(DatanodeDescriptor decommNode, int expectedUnderRep, int expectedDecommissionOnly, int expectedUnderRepInOpenFiles) {
        Assert.assertEquals((String)"Unexpected num under-replicated blocks", (long)expectedUnderRep, (long)decommNode.getLeavingServiceStatus().getUnderReplicatedBlocks());
        Assert.assertEquals((String)"Unexpected number of decom-only replicas", (long)expectedDecommissionOnly, (long)decommNode.getLeavingServiceStatus().getOutOfServiceOnlyReplicas());
        Assert.assertEquals((String)"Unexpected number of replicas in under-replicated open files", (long)expectedUnderRepInOpenFiles, (long)decommNode.getLeavingServiceStatus().getUnderReplicatedInOpenFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void checkDFSAdminDecommissionStatus(List<DatanodeDescriptor> expectedDecomm, DistributedFileSystem dfs, DFSAdmin admin) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos);
        PrintStream oldOut = System.out;
        System.setOut(ps);
        try {
            void var12_14;
            admin.report(new String[]{"-decommissioning"}, 0);
            String[] lines = baos.toString().split("\n");
            Integer num = null;
            int count = 0;
            String[] stringArray = lines;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_14 < n) {
                String line = stringArray[var12_14];
                if (line.startsWith("Decommissioning datanodes")) {
                    String temp = line.split(" ")[2];
                    num = Integer.parseInt((String)temp.subSequence(1, temp.length() - 2));
                }
                if (line.contains("Decommission in progress")) {
                    ++count;
                }
                ++var12_14;
            }
            Assert.assertTrue((String)"No decommissioning output", (num != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"Unexpected number of decomming DNs", (long)expectedDecomm.size(), (long)num.intValue());
            Assert.assertEquals((String)"Unexpected number of decomming DNs", (long)expectedDecomm.size(), (long)count);
            ArrayList<DatanodeInfo> decomming = new ArrayList<DatanodeInfo>(Arrays.asList(dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.DECOMMISSIONING)));
            Assert.assertEquals((String)"Unexpected number of decomming DNs", (long)expectedDecomm.size(), (long)decomming.size());
            for (DatanodeID datanodeID : expectedDecomm) {
                Assert.assertTrue((String)("Did not find expected decomming DN " + datanodeID), (boolean)decomming.contains(datanodeID));
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }

    private void waitForDecommissionedNodes(DatanodeAdminManager dnAdminMgr, int trackedNumber) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> dnAdminMgr.getNumTrackedNodes() == trackedNumber, (long)100L, (long)2000L);
    }

    @Test
    public void testDecommissionStatus() throws Exception {
        InetSocketAddress addr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, this.conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)2L, (long)info.length);
        DistributedFileSystem fileSys = this.cluster.getFileSystem();
        DFSAdmin admin = new DFSAdmin(this.cluster.getConfiguration(0));
        short replicas = 2;
        Path file1 = new Path("decommission.dat");
        DFSTestUtil.createFile((FileSystem)fileSys, file1, 16384, 16384L, 8192L, replicas, 3735928559L);
        Path file2 = new Path("decommission1.dat");
        FSDataOutputStream st1 = AdminStatesBaseTest.writeIncompleteFile((FileSystem)fileSys, file2, replicas, (short)2);
        for (DataNode d : this.cluster.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        FSNamesystem fsn = this.cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        for (int iteration = 0; iteration < 2; ++iteration) {
            String downnode = this.decommissionNode(client, iteration);
            dm.refreshNodes(this.conf);
            this.decommissionedNodes.add(downnode);
            BlockManagerTestUtil.recheckDecommissionState(dm);
            this.waitForDecommissionedNodes(dm.getDatanodeAdminManager(), iteration + 1);
            List decommissioningNodes = dm.getDecommissioningNodes();
            if (iteration == 0) {
                Assert.assertEquals((long)decommissioningNodes.size(), (long)1L);
                DatanodeDescriptor decommNode = (DatanodeDescriptor)decommissioningNodes.get(0);
                this.checkDecommissionStatus(decommNode, 3, 0, 1);
                this.checkDFSAdminDecommissionStatus(decommissioningNodes.subList(0, 1), fileSys, admin);
                continue;
            }
            Assert.assertEquals((long)decommissioningNodes.size(), (long)2L);
            DatanodeDescriptor decommNode1 = (DatanodeDescriptor)decommissioningNodes.get(0);
            DatanodeDescriptor decommNode2 = (DatanodeDescriptor)decommissioningNodes.get(1);
            this.checkDecommissionStatus(decommNode1, 3, 3, 1);
            this.checkDecommissionStatus(decommNode2, 4, 4, 2);
            this.checkDFSAdminDecommissionStatus(decommissioningNodes.subList(0, 2), fileSys, admin);
        }
        this.hostsFileWriter.initExcludeHost("");
        dm.refreshNodes(this.conf);
        st1.close();
        AdminStatesBaseTest.cleanupFile((FileSystem)fileSys, file1);
        AdminStatesBaseTest.cleanupFile((FileSystem)fileSys, file2);
    }

    @Test(timeout=120000L)
    public void testDecommissionStatusAfterDNRestart() throws Exception {
        DistributedFileSystem fileSys = this.cluster.getFileSystem();
        Path f = new Path("decommission.dat");
        DFSTestUtil.createFile((FileSystem)fileSys, f, 16384, 16384L, 16384L, (short)1, 3735928559L);
        RemoteIterator fileList = fileSys.listLocatedStatus(f);
        BlockLocation[] blockLocations = ((LocatedFileStatus)fileList.next()).getBlockLocations();
        String dnName = blockLocations[0].getNames()[0];
        FSNamesystem fsn = this.cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        this.decommissionNode(dnName);
        dm.refreshNodes(this.conf);
        MiniDFSCluster.DataNodeProperties dataNodeProperties = this.cluster.stopDataNode(dnName);
        ArrayList dead = new ArrayList();
        while (true) {
            dm.fetchDatanodes(null, dead, false);
            if (dead.size() == 1) break;
            Thread.sleep(1000L);
        }
        BlockManagerTestUtil.checkHeartbeat(fsn.getBlockManager());
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.waitForDecommissionedNodes(dm.getDatanodeAdminManager(), 1);
        Assert.assertTrue((String)"the node should be DECOMMISSION_IN_PROGRESSS", (boolean)((DatanodeDescriptor)dead.get(0)).isDecommissionInProgress());
        List decomlist = dm.getDecommissioningNodes();
        Assert.assertTrue((String)"The node should be be decommissioning", (decomlist.size() == 1 ? 1 : 0) != 0);
        AdminStatesBaseTest.cleanupFile((FileSystem)fileSys, f);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.waitForDecommissionedNodes(dm.getDatanodeAdminManager(), 0);
        Assert.assertTrue((String)"the node should be decommissioned", (boolean)((DatanodeDescriptor)dead.get(0)).isDecommissioned());
        this.cluster.restartDataNode(dataNodeProperties, true);
        this.cluster.waitActive();
        this.hostsFileWriter.initExcludeHost("");
        dm.refreshNodes(this.conf);
    }

    @Test(timeout=120000L)
    public void testDecommissionDeadDN() throws Exception {
        Logger log = Logger.getLogger(DatanodeAdminManager.class);
        log.setLevel(Level.DEBUG);
        DatanodeID dnID = this.cluster.getDataNodes().get(0).getDatanodeId();
        String dnName = dnID.getXferAddr();
        MiniDFSCluster.DataNodeProperties stoppedDN = this.cluster.stopDataNode(0);
        DFSTestUtil.waitForDatanodeState(this.cluster, dnID.getDatanodeUuid(), false, 30000);
        FSNamesystem fsn = this.cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        DatanodeDescriptor dnDescriptor = dm.getDatanode(dnID);
        this.decommissionNode(dnName);
        dm.refreshNodes(this.conf);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.waitForDecommissionedNodes(dm.getDatanodeAdminManager(), 0);
        Assert.assertTrue((boolean)dnDescriptor.isDecommissioned());
        this.cluster.restartDataNode(stoppedDN, true);
        this.cluster.waitActive();
        this.hostsFileWriter.initExcludeHost("");
        dm.refreshNodes(this.conf);
    }

    @Test(timeout=120000L)
    public void testDecommissionLosingData() throws Exception {
        ArrayList<String> nodes = new ArrayList<String>(2);
        FSNamesystem fsn = this.cluster.getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dm = bm.getDatanodeManager();
        Path file1 = new Path("decommissionLosingData.dat");
        DFSTestUtil.createFile(this.fileSys, file1, 16384, 16384L, 8192L, (short)2, 3735928559L);
        Thread.sleep(1000L);
        this.LOG.info((Object)"Shutdown dn1");
        DatanodeID dnID = this.cluster.getDataNodes().get(1).getDatanodeId();
        String dnName = dnID.getXferAddr();
        DatanodeDescriptor dnDescriptor1 = dm.getDatanode(dnID);
        nodes.add(dnName);
        MiniDFSCluster.DataNodeProperties stoppedDN1 = this.cluster.stopDataNode(1);
        DFSTestUtil.waitForDatanodeState(this.cluster, dnID.getDatanodeUuid(), false, 30000);
        this.LOG.info((Object)"Shutdown dn0");
        dnID = this.cluster.getDataNodes().get(0).getDatanodeId();
        dnName = dnID.getXferAddr();
        DatanodeDescriptor dnDescriptor0 = dm.getDatanode(dnID);
        nodes.add(dnName);
        MiniDFSCluster.DataNodeProperties stoppedDN0 = this.cluster.stopDataNode(0);
        DFSTestUtil.waitForDatanodeState(this.cluster, dnID.getDatanodeUuid(), false, 30000);
        this.LOG.info((Object)"Decommissioning nodes");
        this.hostsFileWriter.initExcludeHosts(nodes);
        dm.refreshNodes(this.conf);
        BlockManagerTestUtil.recheckDecommissionState(dm);
        this.waitForDecommissionedNodes(dm.getDatanodeAdminManager(), 0);
        Assert.assertTrue((boolean)dnDescriptor0.isDecommissioned());
        Assert.assertTrue((boolean)dnDescriptor1.isDecommissioned());
        long missingBlocks = bm.getMissingBlocksCount();
        long underreplicated = bm.getLowRedundancyBlocksCount();
        Assert.assertTrue((missingBlocks > 0L ? 1 : 0) != 0);
        Assert.assertTrue((underreplicated > 0L ? 1 : 0) != 0);
        this.LOG.info((Object)"Bring back dn0");
        this.cluster.restartDataNode(stoppedDN0, true);
        while ((dnID = this.cluster.getDataNodes().get(0).getDatanodeId()) == null) {
        }
        dnDescriptor0 = dm.getDatanode(dnID);
        while (dnDescriptor0.numBlocks() == 0) {
            Thread.sleep(100L);
        }
        this.LOG.info((Object)"Bring back dn1");
        this.cluster.restartDataNode(stoppedDN1, true);
        while ((dnID = this.cluster.getDataNodes().get(1).getDatanodeId()) == null) {
        }
        dnDescriptor1 = dm.getDatanode(dnID);
        while (dnDescriptor1.numBlocks() == 0) {
            Thread.sleep(100L);
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)underreplicated, (long)bm.getLowRedundancyBlocksCount());
        this.LOG.info((Object)"Starting two more nodes");
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        int count = 0;
        while ((bm.getLowRedundancyBlocksCount() > 0L || bm.getPendingReconstructionBlocksCount() > 0L) && count++ < 10) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((long)0L, (long)bm.getLowRedundancyBlocksCount());
        Assert.assertEquals((long)0L, (long)bm.getPendingReconstructionBlocksCount());
        Assert.assertEquals((long)0L, (long)bm.getMissingBlocksCount());
        dnID = this.cluster.getDataNodes().get(3).getDatanodeId();
        this.cluster.stopDataNode(3);
        DFSTestUtil.waitForDatanodeState(this.cluster, dnID.getDatanodeUuid(), false, 30000);
        dnID = this.cluster.getDataNodes().get(2).getDatanodeId();
        this.cluster.stopDataNode(2);
        DFSTestUtil.waitForDatanodeState(this.cluster, dnID.getDatanodeUuid(), false, 30000);
        this.hostsFileWriter.initExcludeHost("");
        dm.refreshNodes(this.conf);
        this.fileSys.delete(file1, false);
    }
}

