/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AdminStatesBaseTest;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminBackoffMonitor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorInterface;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.TestDecommissioningStatus;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestDecommissioningStatusWithBackoffMonitor
extends TestDecommissioningStatus {
    private final long seed = 3735928559L;
    private final int blockSize = 8192;
    private final int fileSize = 16384;
    private final int numDatanodes = 2;
    private MiniDFSCluster cluster;
    private FileSystem fileSys;
    private HostsFileWriter hostsFileWriter;
    private Configuration conf;

    @Override
    public void setUp() throws Exception {
        this.conf = this.setupConfig();
        this.conf.setClass("dfs.namenode.decommission.monitor.class", DatanodeAdminBackoffMonitor.class, DatanodeAdminMonitorInterface.class);
        this.createCluster();
        this.cluster = super.getCluster();
        this.fileSys = super.getFileSys();
        this.hostsFileWriter = super.getHostsFileWriter();
    }

    @Override
    @Test
    public void testDecommissionStatus() throws Exception {
        InetSocketAddress addr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, this.conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)2L, (long)info.length);
        DistributedFileSystem distFileSys = this.cluster.getFileSystem();
        DFSAdmin admin = new DFSAdmin(this.cluster.getConfiguration(0));
        short replicas = 2;
        Path file1 = new Path("decommission.dat");
        DFSTestUtil.createFile((FileSystem)distFileSys, file1, 16384, 16384L, 8192L, replicas, 3735928559L);
        Path file2 = new Path("decommission1.dat");
        FSDataOutputStream st1 = AdminStatesBaseTest.writeIncompleteFile((FileSystem)distFileSys, file2, replicas, (short)2);
        for (DataNode d : this.cluster.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(d);
        }
        FSNamesystem fsn = this.cluster.getNamesystem();
        DatanodeManager dm = fsn.getBlockManager().getDatanodeManager();
        for (int iteration = 0; iteration < 2; ++iteration) {
            String downnode = this.decommissionNode(client, iteration);
            dm.refreshNodes(this.conf);
            this.decommissionedNodes.add(downnode);
            BlockManagerTestUtil.recheckDecommissionState(dm);
            List decommissioningNodes = dm.getDecommissioningNodes();
            if (iteration == 0) {
                Assert.assertEquals((long)decommissioningNodes.size(), (long)1L);
                BlockManagerTestUtil.recheckDecommissionState(dm);
                DatanodeDescriptor decommNode = (DatanodeDescriptor)decommissioningNodes.get(0);
                this.checkDecommissionStatus(decommNode, 3, 0, 1);
                this.checkDFSAdminDecommissionStatus(decommissioningNodes.subList(0, 1), distFileSys, admin);
                continue;
            }
            Assert.assertEquals((long)decommissioningNodes.size(), (long)2L);
            BlockManagerTestUtil.recheckDecommissionState(dm);
            DatanodeDescriptor decommNode1 = (DatanodeDescriptor)decommissioningNodes.get(0);
            DatanodeDescriptor decommNode2 = (DatanodeDescriptor)decommissioningNodes.get(1);
            this.checkDecommissionStatus(decommNode1, 3, 3, 1);
            this.checkDecommissionStatus(decommNode2, 4, 4, 2);
            this.checkDFSAdminDecommissionStatus(decommissioningNodes.subList(0, 2), distFileSys, admin);
        }
        this.hostsFileWriter.initExcludeHost("");
        dm.refreshNodes(this.conf);
        st1.close();
        AdminStatesBaseTest.cleanupFile(this.fileSys, file1);
        AdminStatesBaseTest.cleanupFile(this.fileSys, file2);
    }
}

