/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMetaSave {
    static final int NUM_DATA_NODES = 2;
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    private static MiniDFSCluster cluster = null;
    private static FileSystem fileSys = null;
    private static NamenodeProtocols nnRpc = null;

    @Before
    public void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1000);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.heartbeat.recheck-interval", 1L);
        conf.setLong("dfs.namenode.stale.datanode.interval", 5L);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        nnRpc = cluster.getNameNodeRpc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSave() throws IOException, InterruptedException, TimeoutException {
        for (int i = 0; i < 2; ++i) {
            Path file = new Path("/filestatus" + i);
            DFSTestUtil.createFile(fileSys, file, 1024, 1024L, 8192L, (short)2, 3735928559L);
        }
        this.stopDatanodeAndWait(1);
        nnRpc.setReplication("/filestatus0", (short)4);
        nnRpc.metaSave("metasave.out.txt");
        FileInputStream fstream = new FileInputStream(TestMetaSave.getLogFile("metasave.out.txt"));
        DataInputStream in = new DataInputStream(fstream);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            Assert.assertEquals((Object)"3 files and directories, 2 blocks = 5 total filesystem objects", (Object)line);
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Live Datanodes: 1"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Dead Datanodes: 1"));
            reader.readLine();
            line = reader.readLine();
            Assert.assertTrue((boolean)line.matches("^/filestatus[01]:.*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetasaveAfterDelete() throws IOException, InterruptedException, TimeoutException {
        for (int i = 0; i < 2; ++i) {
            Path file = new Path("/filestatus" + i);
            DFSTestUtil.createFile(fileSys, file, 1024, 1024L, 8192L, (short)2, 3735928559L);
        }
        this.stopDatanodeAndWait(1);
        nnRpc.setReplication("/filestatus0", (short)4);
        nnRpc.delete("/filestatus0", true);
        nnRpc.delete("/filestatus1", true);
        nnRpc.metaSave("metasaveAfterDelete.out.txt");
        try (BufferedReader reader = null;){
            FileInputStream fstream = new FileInputStream(TestMetaSave.getLogFile("metasaveAfterDelete.out.txt"));
            DataInputStream in = new DataInputStream(fstream);
            reader = new BufferedReader(new InputStreamReader(in));
            reader.readLine();
            String line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Live Datanodes: 1"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Dead Datanodes: 1"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Blocks waiting for reconstruction: 0"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Blocks currently missing: 0"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Mis-replicated blocks that have been postponed:"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Blocks being reconstructed: 0"));
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Blocks 2 waiting deletion from 1 datanodes."));
            line = reader.readLine();
            line = reader.readLine();
            Assert.assertTrue((boolean)line.contains("blk"));
            line = reader.readLine();
            line = reader.readLine();
            Assert.assertTrue((boolean)line.equals("Metasave: Number of datanodes: 2"));
            line = reader.readLine();
            Assert.assertFalse((boolean)line.contains("NaN"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSaveOverwrite() throws Exception {
        nnRpc.metaSave("metaSaveOverwrite.out.txt");
        nnRpc.metaSave("metaSaveOverwrite.out.txt");
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader rdr = null;
        try {
            fis = new FileInputStream(TestMetaSave.getLogFile("metaSaveOverwrite.out.txt"));
            isr = new InputStreamReader(fis);
            rdr = new BufferedReader(isr);
            boolean foundLiveDatanodesLine = false;
            String line = rdr.readLine();
            while (line != null) {
                if (line.startsWith("Live Datanodes")) {
                    if (foundLiveDatanodesLine) {
                        Assert.fail((String)"multiple Live Datanodes lines, output file not overwritten");
                    }
                    foundLiveDatanodesLine = true;
                }
                line = rdr.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{rdr, isr, fis});
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{rdr, isr, fis});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentMetaSave() throws Exception {
        int i;
        ArrayList<MetaSaveThread> threads = new ArrayList<MetaSaveThread>();
        for (i = 0; i < 10; ++i) {
            threads.add(new MetaSaveThread(nnRpc, "metaSaveConcurrent.out.txt"));
        }
        for (i = 0; i < 10; ++i) {
            ((MetaSaveThread)threads.get(i)).start();
        }
        for (i = 0; i < 10; ++i) {
            ((MetaSaveThread)threads.get(i)).join();
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader rdr = null;
        try {
            fis = new FileInputStream(TestMetaSave.getLogFile("metaSaveConcurrent.out.txt"));
            isr = new InputStreamReader(fis);
            rdr = new BufferedReader(isr);
            boolean foundLiveDatanodesLine = false;
            String line = rdr.readLine();
            while (line != null) {
                if (line.startsWith("Live Datanodes")) {
                    if (foundLiveDatanodesLine) {
                        Assert.fail((String)"multiple Live Datanodes lines, output file not overwritten");
                    }
                    foundLiveDatanodesLine = true;
                }
                line = rdr.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{rdr, isr, fis});
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{rdr, isr, fis});
    }

    @After
    public void tearDown() throws IOException {
        if (fileSys != null) {
            fileSys.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static File getLogFile(String name) {
        return new File(System.getProperty("hadoop.log.dir"), name);
    }

    private void stopDatanodeAndWait(int dnIdx) throws TimeoutException, InterruptedException {
        final DataNode dnToStop = cluster.getDataNodes().get(dnIdx);
        cluster.stopDataNode(dnIdx);
        BlockManagerTestUtil.noticeDeadDatanode(cluster.getNameNode(), dnToStop.getDatanodeId().getXferAddr());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return BlockManagerTestUtil.isDatanodeRemoved(cluster.getNameNode(), dnToStop.getDatanodeUuid());
            }
        }, (long)1000L, (long)30000L);
    }

    class MetaSaveThread
    extends Thread {
        NamenodeProtocols nnRpc;
        String filename;

        public MetaSaveThread(NamenodeProtocols nnRpc, String filename) {
            this.nnRpc = nnRpc;
            this.filename = filename;
        }

        @Override
        public void run() {
            try {
                this.nnRpc.metaSave(this.filename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

