/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import org.apache.hadoop.hdfs.DFSUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestPathComponents {
    @Test
    public void testBytes2ByteArrayFQ() throws Exception {
        this.testString("/", new String[]{null});
        this.testString("//", new String[]{null});
        this.testString("/file", new String[]{"", "file"});
        this.testString("/dir/", new String[]{"", "dir"});
        this.testString("//file", new String[]{"", "file"});
        this.testString("/dir//file", new String[]{"", "dir", "file"});
        this.testString("//dir/dir1//", new String[]{"", "dir", "dir1"});
        this.testString("//dir//dir1//", new String[]{"", "dir", "dir1"});
        this.testString("//dir//dir1//file", new String[]{"", "dir", "dir1", "file"});
    }

    @Test
    public void testBytes2ByteArrayRelative() throws Exception {
        this.testString("file", new String[]{"file"});
        this.testString("dir/", new String[]{"dir"});
        this.testString("dir//", new String[]{"dir"});
        this.testString("dir//file", new String[]{"dir", "file"});
        this.testString("dir/dir1//", new String[]{"dir", "dir1"});
        this.testString("dir//dir1//", new String[]{"dir", "dir1"});
        this.testString("dir//dir1//file", new String[]{"dir", "dir1", "file"});
    }

    @Test
    public void testByteArray2PathStringRoot() {
        byte[][] components = DFSUtil.getPathComponents((String)"/");
        Assert.assertEquals((Object)"", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)0));
        Assert.assertEquals((Object)"/", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)1));
    }

    @Test
    public void testByteArray2PathStringFQ() {
        byte[][] components = DFSUtil.getPathComponents((String)"/1/2/3");
        Assert.assertEquals((Object)"/1/2/3", (Object)DFSUtil.byteArray2PathString((byte[][])components));
        Assert.assertEquals((Object)"", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)0));
        Assert.assertEquals((Object)"/", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)1));
        Assert.assertEquals((Object)"/1", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)2));
        Assert.assertEquals((Object)"/1/2", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)3));
        Assert.assertEquals((Object)"/1/2/3", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)4));
        Assert.assertEquals((Object)"", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)0));
        Assert.assertEquals((Object)"1", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)1));
        Assert.assertEquals((Object)"1/2", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)2));
        Assert.assertEquals((Object)"1/2/3", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)3));
    }

    @Test
    public void testByteArray2PathStringRelative() {
        byte[][] components = DFSUtil.getPathComponents((String)"1/2/3");
        Assert.assertEquals((Object)"1/2/3", (Object)DFSUtil.byteArray2PathString((byte[][])components));
        Assert.assertEquals((Object)"", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)0));
        Assert.assertEquals((Object)"1", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)1));
        Assert.assertEquals((Object)"1/2", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)2));
        Assert.assertEquals((Object)"1/2/3", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)0, (int)3));
        Assert.assertEquals((Object)"", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)0));
        Assert.assertEquals((Object)"2", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)1));
        Assert.assertEquals((Object)"2/3", (Object)DFSUtil.byteArray2PathString((byte[][])components, (int)1, (int)2));
    }

    public void testString(String path, String[] expected) throws Exception {
        byte[][] components = DFSUtil.getPathComponents((String)path);
        String[] actual = new String[components.length];
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            actual[i] = DFSUtil.bytes2String((byte[])components[i]);
        }
        Assert.assertEquals(Arrays.asList(expected), Arrays.asList(actual));
        path = path.replaceAll("/+", "/");
        if (path.length() > 1) {
            path = path.replaceAll("/$", "");
        }
        Assert.assertEquals((Object)path, (Object)DFSUtil.byteArray2PathString((byte[][])components));
    }
}

