/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestSecureNameNodeWithExternalKdc {
    private static final int NUM_OF_DATANODES = 0;

    @Before
    public void testExternalKdcRunning() {
        Assume.assumeTrue((boolean)SecurityUtilTestHelper.isExternalKdcRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecureNameNode() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            Path p2;
            String nnPrincipal = System.getProperty("dfs.namenode.kerberos.principal");
            String nnSpnegoPrincipal = System.getProperty("dfs.namenode.kerberos.internal.spnego.principal");
            String nnKeyTab = System.getProperty("dfs.namenode.keytab.file");
            Assert.assertNotNull((String)"NameNode principal was not specified", (Object)nnPrincipal);
            Assert.assertNotNull((String)"NameNode SPNEGO principal was not specified", (Object)nnSpnegoPrincipal);
            Assert.assertNotNull((String)"NameNode keytab was not specified", (Object)nnKeyTab);
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("dfs.namenode.kerberos.principal", nnPrincipal);
            conf.set("dfs.namenode.kerberos.internal.spnego.principal", nnSpnegoPrincipal);
            conf.set("dfs.namenode.keytab.file", nnKeyTab);
            final MiniDFSCluster clusterRef = cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem fsForCurrentUser = cluster.getFileSystem();
            fsForCurrentUser.mkdirs(new Path("/tmp"));
            fsForCurrentUser.setPermission(new Path("/tmp"), new FsPermission(511));
            String userPrincipal = System.getProperty("user.principal");
            String userKeyTab = System.getProperty("user.keytab");
            Assert.assertNotNull((String)"User principal was not specified", (Object)userPrincipal);
            Assert.assertNotNull((String)"User keytab was not specified", (Object)userKeyTab);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)userPrincipal, (String)userKeyTab);
            FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return clusterRef.getFileSystem();
                }
            });
            try {
                p2 = new Path("/users");
                fs.mkdirs(p2);
                Assert.fail((String)"User must not be allowed to write in /");
            }
            catch (IOException p2) {
                // empty catch block
            }
            p2 = new Path("/tmp/alpha");
            fs.mkdirs(p2);
            Assert.assertNotNull((Object)fs.listStatus(p2));
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

