/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.DomainPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShm;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplicaInfo;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Waitable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TestShortCircuitCache {
    static final Logger LOG = LoggerFactory.getLogger(TestShortCircuitCache.class);

    @Test(timeout=60000L)
    public void testCreateAndDestroy() throws Exception {
        ShortCircuitCache cache = new ShortCircuitCache(10, 1L, 10, 1L, 1L, 10000L, 0);
        cache.close();
    }

    @Test(timeout=60000L)
    public void testAddAndRetrieve() throws Exception {
        ShortCircuitCache cache = new ShortCircuitCache(10, 10000000L, 10, 10000000L, 1L, 10000L, 0);
        TestFileDescriptorPair pair = new TestFileDescriptorPair();
        ShortCircuitReplicaInfo replicaInfo1 = cache.fetchOrCreate(new ExtendedBlockId(123L, "test_bp1"), (ShortCircuitCache.ShortCircuitReplicaCreator)new SimpleReplicaCreator(123, cache, pair));
        Preconditions.checkNotNull((Object)replicaInfo1.getReplica());
        Preconditions.checkState((replicaInfo1.getInvalidTokenException() == null ? 1 : 0) != 0);
        pair.compareWith(replicaInfo1.getReplica().getDataStream(), replicaInfo1.getReplica().getMetaStream());
        ShortCircuitReplicaInfo replicaInfo2 = cache.fetchOrCreate(new ExtendedBlockId(123L, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                Assert.fail((String)"expected to use existing entry.");
                return null;
            }
        });
        Preconditions.checkNotNull((Object)replicaInfo2.getReplica());
        Preconditions.checkState((replicaInfo2.getInvalidTokenException() == null ? 1 : 0) != 0);
        Preconditions.checkState((replicaInfo1 == replicaInfo2 ? 1 : 0) != 0);
        pair.compareWith(replicaInfo2.getReplica().getDataStream(), replicaInfo2.getReplica().getMetaStream());
        replicaInfo1.getReplica().unref();
        replicaInfo2.getReplica().unref();
        ShortCircuitReplicaInfo replicaInfo3 = cache.fetchOrCreate(new ExtendedBlockId(123L, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                Assert.fail((String)"expected to use existing entry.");
                return null;
            }
        });
        Preconditions.checkNotNull((Object)replicaInfo3.getReplica());
        Preconditions.checkState((replicaInfo3.getInvalidTokenException() == null ? 1 : 0) != 0);
        replicaInfo3.getReplica().unref();
        pair.close();
        cache.close();
    }

    @Test(timeout=100000L)
    public void testExpiry() throws Exception {
        ShortCircuitCache cache = new ShortCircuitCache(2, 1L, 1, 10000000L, 1L, 10000000L, 0);
        TestFileDescriptorPair pair = new TestFileDescriptorPair();
        ShortCircuitReplicaInfo replicaInfo1 = cache.fetchOrCreate(new ExtendedBlockId(123L, "test_bp1"), (ShortCircuitCache.ShortCircuitReplicaCreator)new SimpleReplicaCreator(123, cache, pair));
        Preconditions.checkNotNull((Object)replicaInfo1.getReplica());
        Preconditions.checkState((replicaInfo1.getInvalidTokenException() == null ? 1 : 0) != 0);
        pair.compareWith(replicaInfo1.getReplica().getDataStream(), replicaInfo1.getReplica().getMetaStream());
        replicaInfo1.getReplica().unref();
        final MutableBoolean triedToCreate = new MutableBoolean(false);
        do {
            Thread.sleep(10L);
            ShortCircuitReplicaInfo replicaInfo2 = cache.fetchOrCreate(new ExtendedBlockId(123L, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

                public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                    triedToCreate.setValue(true);
                    return null;
                }
            });
            if (replicaInfo2 == null || replicaInfo2.getReplica() == null) continue;
            replicaInfo2.getReplica().unref();
        } while (triedToCreate.isFalse());
        cache.close();
    }

    @Test(timeout=60000L)
    public void testEviction() throws Exception {
        int i;
        int i2;
        ShortCircuitCache cache = new ShortCircuitCache(2, 10000000L, 1, 10000000L, 1L, 10000L, 0);
        TestFileDescriptorPair[] pairs = new TestFileDescriptorPair[]{new TestFileDescriptorPair(), new TestFileDescriptorPair(), new TestFileDescriptorPair()};
        ShortCircuitReplicaInfo[] replicaInfos = new ShortCircuitReplicaInfo[]{null, null, null};
        for (i2 = 0; i2 < pairs.length; ++i2) {
            replicaInfos[i2] = cache.fetchOrCreate(new ExtendedBlockId((long)i2, "test_bp1"), (ShortCircuitCache.ShortCircuitReplicaCreator)new SimpleReplicaCreator(i2, cache, pairs[i2]));
            Preconditions.checkNotNull((Object)replicaInfos[i2].getReplica());
            Preconditions.checkState((replicaInfos[i2].getInvalidTokenException() == null ? 1 : 0) != 0);
            pairs[i2].compareWith(replicaInfos[i2].getReplica().getDataStream(), replicaInfos[i2].getReplica().getMetaStream());
        }
        for (i2 = 0; i2 < pairs.length; ++i2) {
            replicaInfos[i2].getReplica().unref();
        }
        for (i2 = 1; i2 < pairs.length; ++i2) {
            final Integer iVal = i2;
            replicaInfos[i2] = cache.fetchOrCreate(new ExtendedBlockId((long)i2, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

                public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                    Assert.fail((String)("expected to use existing entry for " + iVal));
                    return null;
                }
            });
            Preconditions.checkNotNull((Object)replicaInfos[i2].getReplica());
            Preconditions.checkState((replicaInfos[i2].getInvalidTokenException() == null ? 1 : 0) != 0);
            pairs[i2].compareWith(replicaInfos[i2].getReplica().getDataStream(), replicaInfos[i2].getReplica().getMetaStream());
        }
        final MutableBoolean calledCreate = new MutableBoolean(false);
        replicaInfos[0] = cache.fetchOrCreate(new ExtendedBlockId(0L, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                calledCreate.setValue(true);
                return null;
            }
        });
        Preconditions.checkState((replicaInfos[0].getReplica() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)calledCreate.isTrue());
        for (i = 1; i < pairs.length; ++i) {
            replicaInfos[i].getReplica().unref();
        }
        for (i = 0; i < pairs.length; ++i) {
            pairs[i].close();
        }
        cache.close();
    }

    @Test(timeout=60000L)
    public void testTimeBasedStaleness() throws Exception {
        final ShortCircuitCache cache = new ShortCircuitCache(2, 10000000L, 1, 10000000L, 1L, 10L, 0);
        final TestFileDescriptorPair[] pairs = new TestFileDescriptorPair[]{new TestFileDescriptorPair(), new TestFileDescriptorPair()};
        ShortCircuitReplicaInfo[] replicaInfos = new ShortCircuitReplicaInfo[]{null, null};
        long HOUR_IN_MS = 3600000L;
        for (int i = 0; i < pairs.length; ++i) {
            final Integer iVal = i;
            final ExtendedBlockId key = new ExtendedBlockId((long)i, "test_bp1");
            replicaInfos[i] = cache.fetchOrCreate(key, new ShortCircuitCache.ShortCircuitReplicaCreator(){

                public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                    try {
                        return new ShortCircuitReplicaInfo(new ShortCircuitReplica(key, pairs[iVal].getFileInputStreams()[0], pairs[iVal].getFileInputStreams()[1], cache, Time.monotonicNow() + (long)iVal.intValue() * 3600000L, null));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            Preconditions.checkNotNull((Object)replicaInfos[i].getReplica());
            Preconditions.checkState((replicaInfos[i].getInvalidTokenException() == null ? 1 : 0) != 0);
            pairs[i].compareWith(replicaInfos[i].getReplica().getDataStream(), replicaInfos[i].getReplica().getMetaStream());
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                ShortCircuitReplicaInfo info = cache.fetchOrCreate(new ExtendedBlockId(0L, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

                    public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                        return null;
                    }
                });
                if (info.getReplica() != null) {
                    info.getReplica().unref();
                    return false;
                }
                return true;
            }
        }, (long)500L, (long)60000L);
        ShortCircuitReplicaInfo info = cache.fetchOrCreate(new ExtendedBlockId(1L, "test_bp1"), new ShortCircuitCache.ShortCircuitReplicaCreator(){

            public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
                Assert.fail((String)"second replica went stale, despite 1 hour staleness time.");
                return null;
            }
        });
        info.getReplica().unref();
        for (int i = 1; i < pairs.length; ++i) {
            replicaInfos[i].getReplica().unref();
        }
        cache.close();
    }

    private static Configuration createShortCircuitConf(String testName, TemporarySocketDirectory sockDir) {
        Configuration conf = new Configuration();
        conf.set("dfs.client.context", testName);
        conf.setLong("dfs.blocksize", 4096L);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), testName).getAbsolutePath());
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.setBoolean("dfs.client.domain.socket.data.traffic", false);
        DFSInputStream.tcpReadsDisabledForTesting = true;
        DomainSocket.disableBindPathValidation();
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        return conf;
    }

    private static DomainPeer getDomainPeerToDn(Configuration conf) throws IOException {
        DomainSocket sock = DomainSocket.connect((String)conf.get("dfs.domain.socket.path"));
        return new DomainPeer(sock);
    }

    @Test(timeout=60000L)
    public void testAllocShm() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testAllocShm", sockDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        final ShortCircuitCache cache = fs.getClient().getClientContext().getShortCircuitCache(0L);
        cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

            public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                Assert.assertEquals((long)0L, (long)info.size());
            }
        });
        DomainPeer peer = TestShortCircuitCache.getDomainPeerToDn(conf);
        MutableBoolean usedPeer = new MutableBoolean(false);
        ExtendedBlockId blockId = new ExtendedBlockId(123L, "xyz");
        final DatanodeInfo datanode = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(cluster.getDataNodes().get(0).getDatanodeId()).build();
        ShortCircuitShm.Slot slot = cache.allocShmSlot(datanode, peer, usedPeer, blockId, "testAllocShm_client");
        Assert.assertNotNull((Object)slot);
        Assert.assertTrue((boolean)usedPeer.booleanValue());
        cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

            public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                Assert.assertEquals((long)1L, (long)info.size());
                DfsClientShmManager.PerDatanodeVisitorInfo vinfo = info.get(datanode);
                Assert.assertFalse((boolean)vinfo.disabled);
                Assert.assertEquals((long)0L, (long)vinfo.full.size());
                Assert.assertEquals((long)1L, (long)vinfo.notFull.size());
            }
        });
        cache.scheduleSlotReleaser(slot);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                final MutableBoolean done = new MutableBoolean(false);
                try {
                    cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

                        public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                            done.setValue(info.get((Object)datanode).full.isEmpty() && info.get((Object)datanode).notFull.isEmpty());
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error("error running visitor", (Throwable)e);
                }
                return done.booleanValue();
            }
        }, (long)10L, (long)60000L);
        cluster.shutdown();
        sockDir.close();
    }

    @Test(timeout=60000L)
    public void testShmBasedStaleness() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testShmBasedStaleness", sockDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        ShortCircuitCache cache = fs.getClient().getClientContext().getShortCircuitCache(0L);
        String TEST_FILE = "/test_file";
        int TEST_FILE_LEN = 8193;
        int SEED = 1027565;
        DFSTestUtil.createFile((FileSystem)fs, new Path(TEST_FILE), 8193L, (short)1, 1027565L);
        FSDataInputStream fis = fs.open(new Path(TEST_FILE));
        int first = fis.read();
        final ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, new Path(TEST_FILE));
        Assert.assertTrue((first != -1 ? 1 : 0) != 0);
        cache.accept(new ShortCircuitCache.CacheVisitor(){

            public void visit(int numOutstandingMmaps, Map<ExtendedBlockId, ShortCircuitReplica> replicas, Map<ExtendedBlockId, SecretManager.InvalidToken> failedLoads, LinkedMap evictable, LinkedMap evictableMmapped) {
                ShortCircuitReplica replica = replicas.get(ExtendedBlockId.fromExtendedBlock((ExtendedBlock)block));
                Assert.assertNotNull((Object)replica);
                Assert.assertTrue((boolean)replica.getSlot().isValid());
            }
        });
        cluster.getDataNodes().get(0).shutdown();
        cache.accept(new ShortCircuitCache.CacheVisitor(){

            public void visit(int numOutstandingMmaps, Map<ExtendedBlockId, ShortCircuitReplica> replicas, Map<ExtendedBlockId, SecretManager.InvalidToken> failedLoads, LinkedMap evictable, LinkedMap evictableMmapped) {
                ShortCircuitReplica replica = replicas.get(ExtendedBlockId.fromExtendedBlock((ExtendedBlock)block));
                Assert.assertNotNull((Object)replica);
                Assert.assertFalse((boolean)replica.getSlot().isValid());
            }
        });
        cluster.shutdown();
        sockDir.close();
    }

    @Test(timeout=60000L)
    public void testUnlinkingReplicasInFileDescriptorCache() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testUnlinkingReplicasInFileDescriptorCache", sockDir);
        conf.setLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 1000000000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        final ShortCircuitCache cache = fs.getClient().getClientContext().getShortCircuitCache(0L);
        cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

            public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                Assert.assertEquals((long)0L, (long)info.size());
            }
        });
        Path TEST_PATH = new Path("/test_file");
        int TEST_FILE_LEN = 8193;
        int SEED = 1027552;
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 8193L, (short)1, 1027552L);
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH);
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(1027552L, 8193);
        Assert.assertTrue((boolean)Arrays.equals(contents, expected));
        final DatanodeInfo datanode = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(cluster.getDataNodes().get(0).getDatanodeId()).build();
        cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

            public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                Assert.assertTrue((boolean)info.get((Object)datanode).full.isEmpty());
                Assert.assertFalse((boolean)info.get((Object)datanode).disabled);
                Assert.assertEquals((long)1L, (long)info.get((Object)datanode).notFull.values().size());
                DfsClientShm shm = (DfsClientShm)info.get((Object)datanode).notFull.values().iterator().next();
                Assert.assertFalse((boolean)shm.isDisconnected());
            }
        });
        fs.delete(TEST_PATH, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){
            MutableBoolean done = new MutableBoolean(true);

            @Override
            public Boolean get() {
                try {
                    this.done.setValue(true);
                    cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

                        public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) throws IOException {
                            Assert.assertTrue((boolean)info.get((Object)datanode).full.isEmpty());
                            Assert.assertFalse((boolean)info.get((Object)datanode).disabled);
                            Assert.assertEquals((long)1L, (long)info.get((Object)datanode).notFull.values().size());
                            DfsClientShm shm = (DfsClientShm)info.get((Object)datanode).notFull.values().iterator().next();
                            ShortCircuitShm.SlotIterator iter = shm.slotIterator();
                            while (iter.hasNext()) {
                                ShortCircuitShm.Slot slot = (ShortCircuitShm.Slot)iter.next();
                                if (!slot.isValid()) continue;
                                done.setValue(false);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    LOG.error("error running visitor", (Throwable)e);
                }
                return this.done.booleanValue();
            }
        }, (long)10L, (long)60000L);
        cluster.shutdown();
        sockDir.close();
    }

    private static void checkNumberOfSegmentsAndSlots(final int expectedSegments, final int expectedSlots, final ShortCircuitRegistry registry) throws InterruptedException, TimeoutException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return registry.visit(new ShortCircuitRegistry.Visitor(){

                    public boolean accept(HashMap<ShortCircuitShm.ShmId, ShortCircuitRegistry.RegisteredShm> segments, HashMultimap<ExtendedBlockId, ShortCircuitShm.Slot> slots) {
                        return expectedSegments == segments.size() && expectedSlots == slots.size();
                    }
                });
            }
        }, (long)100L, (long)10000L);
    }

    @Test(timeout=60000L)
    public void testDataXceiverCleansUpSlotsOnFailure() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testDataXceiverCleansUpSlotsOnFailure", sockDir);
        conf.setLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 1000000000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path TEST_PATH1 = new Path("/test_file1");
        Path TEST_PATH2 = new Path("/test_file2");
        int TEST_FILE_LEN = 4096;
        int SEED = 1027553;
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH1, 4096L, (short)1, 1027553L);
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH2, 4096L, (short)1, 1027553L);
        DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH1);
        BlockReaderFactory.setFailureInjectorForTesting((BlockReaderFactory.FailureInjector)new TestCleanupFailureInjector());
        try {
            DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH2);
        }
        catch (Throwable t) {
            GenericTestUtils.assertExceptionContains((String)"TCP reads were disabled for testing, but we failed to do a non-TCP read.", (Throwable)t);
        }
        TestShortCircuitCache.checkNumberOfSegmentsAndSlots(1, 1, cluster.getDataNodes().get(0).getShortCircuitRegistry());
        cluster.shutdown();
        sockDir.close();
    }

    @Test(timeout=60000L)
    public void testDataXceiverHandlesRequestShortCircuitShmFailure() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testDataXceiverHandlesRequestShortCircuitShmFailure", sockDir);
        conf.setLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 1000000000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path TEST_PATH1 = new Path("/test_file1");
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH1, 4096L, (short)1, 1027553L);
        LOG.info("Setting failure injector and performing a read which should fail...");
        DataNodeFaultInjector failureInjector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
        ((DataNodeFaultInjector)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                throw new IOException("injected error into sendShmResponse");
            }
        }).when((Object)failureInjector)).sendShortCircuitShmResponse();
        DataNodeFaultInjector prevInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)failureInjector);
        try {
            DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH1);
            Assert.fail((String)"expected readFileBuffer to fail, but it succeeded.");
        }
        catch (Throwable t) {
            GenericTestUtils.assertExceptionContains((String)"TCP reads were disabled for testing, but we failed to do a non-TCP read.", (Throwable)t);
        }
        TestShortCircuitCache.checkNumberOfSegmentsAndSlots(0, 0, cluster.getDataNodes().get(0).getShortCircuitRegistry());
        LOG.info("Clearing failure injector and performing another read...");
        DataNodeFaultInjector.set((DataNodeFaultInjector)prevInjector);
        fs.getClient().getClientContext().getDomainSocketFactory().clearPathMap();
        DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH1);
        TestShortCircuitCache.checkNumberOfSegmentsAndSlots(1, 1, cluster.getDataNodes().get(0).getShortCircuitRegistry());
        cluster.shutdown();
        sockDir.close();
    }

    @Test(timeout=60000L)
    public void testPreReceiptVerificationDfsClientCanDoScr() throws Exception {
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testPreReceiptVerificationDfsClientCanDoScr", sockDir);
        conf.setLong("dfs.client.read.shortcircuit.streams.cache.expiry.ms", 1000000000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        BlockReaderFactory.setFailureInjectorForTesting((BlockReaderFactory.FailureInjector)new TestPreReceiptVerificationFailureInjector());
        Path TEST_PATH1 = new Path("/test_file1");
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH1, 4096L, (short)1, 1027554L);
        Path TEST_PATH2 = new Path("/test_file2");
        DFSTestUtil.createFile((FileSystem)fs, TEST_PATH2, 4096L, (short)1, 1027554L);
        DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH1);
        DFSTestUtil.readFileBuffer((FileSystem)fs, TEST_PATH2);
        TestShortCircuitCache.checkNumberOfSegmentsAndSlots(1, 2, cluster.getDataNodes().get(0).getShortCircuitRegistry());
        cluster.shutdown();
        sockDir.close();
    }

    @Test
    public void testFetchOrCreateRetries() throws Exception {
        try (ShortCircuitCache cache = (ShortCircuitCache)Mockito.spy((Object)new ShortCircuitCache(10, 10000000L, 10, 10000000L, 1L, 10000L, 0));){
            TestFileDescriptorPair pair = new TestFileDescriptorPair();
            ExtendedBlockId extendedBlockId = new ExtendedBlockId(123L, "test_bp1");
            SimpleReplicaCreator sRC = new SimpleReplicaCreator(123, cache, pair);
            ((ShortCircuitCache)Mockito.doThrow((Throwable[])new Throwable[]{new RetriableException("Retry")}).when((Object)cache)).fetch((ExtendedBlockId)Mockito.eq((Object)extendedBlockId), (Waitable)Mockito.any());
            cache.fetchOrCreate(extendedBlockId, (ShortCircuitCache.ShortCircuitReplicaCreator)sRC);
            cache.fetchOrCreate(extendedBlockId, (ShortCircuitCache.ShortCircuitReplicaCreator)sRC);
            ((ShortCircuitCache)Mockito.verify((Object)cache, (VerificationMode)Mockito.atLeast((int)3))).fetch((ExtendedBlockId)Mockito.eq((Object)extendedBlockId), (Waitable)Mockito.any());
        }
    }

    @Test
    public void testRequestFileDescriptorsWhenULimit() throws Exception {
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testRequestFileDescriptorsWhenULimit", sockDir);
        boolean replicas = true;
        int fileSize = 3;
        String testFile = "/testfile";
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, new Path("/testfile"), 3L, (short)1, 0L);
            LocatedBlock blk = new DFSClient(DFSUtilClient.getNNAddress((Configuration)conf), conf).getLocatedBlocks("/testfile", 0L, 3L).get(0);
            ClientContext clientContext = (ClientContext)Mockito.mock(ClientContext.class);
            Mockito.when((Object)clientContext.getPeerCache()).thenAnswer(peerCacheCall -> {
                PeerCache peerCache = new PeerCache(10, Long.MAX_VALUE);
                DomainPeer peer = (DomainPeer)Mockito.spy((Object)TestShortCircuitCache.getDomainPeerToDn(conf));
                peerCache.put((DatanodeID)blk.getLocations()[0], (Peer)peer);
                Mockito.when((Object)peer.getDomainSocket()).thenAnswer(domainSocketCall -> {
                    DomainSocket domainSocket = (DomainSocket)Mockito.mock(DomainSocket.class);
                    Mockito.when((Object)domainSocket.recvFileInputStreams((FileInputStream[])Mockito.any(FileInputStream[].class), (byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenAnswer(recvFileInputStreamsCall -> null);
                    return domainSocket;
                });
                return peerCache;
            });
            Mockito.when((Object)clientContext.getShortCircuitCache(blk.getBlock().getBlockId())).thenAnswer(shortCircuitCacheCall -> {
                ShortCircuitCache cache = (ShortCircuitCache)Mockito.mock(ShortCircuitCache.class);
                Mockito.when((Object)cache.allocShmSlot((DatanodeInfo)Mockito.any(DatanodeInfo.class), (DomainPeer)Mockito.any(DomainPeer.class), (MutableBoolean)Mockito.any(MutableBoolean.class), (ExtendedBlockId)Mockito.any(ExtendedBlockId.class), Mockito.anyString())).thenAnswer(call -> null);
                return cache;
            });
            DatanodeInfoWithStorage[] nodes = blk.getLocations();
            try {
                Assert.assertNull((Object)new BlockReaderFactory(new DfsClientConf(conf)).setInetSocketAddress(NetUtils.createSocketAddr((String)nodes[0].getXferAddr())).setClientCacheContext(clientContext).setDatanodeInfo((DatanodeInfo)blk.getLocations()[0]).setBlock(blk.getBlock()).setBlockToken(new Token()).createShortCircuitReplicaInfo());
            }
            catch (NullPointerException ex) {
                Assert.fail((String)"Should not throw NPE when the native library is unable to create new files!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDomainSocketClosedByDN() throws Exception {
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testDomainSocketClosedByDN", sockDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ShortCircuitCache cache = fs.getClient().getClientContext().getShortCircuitCache();
            DomainPeer peer = TestShortCircuitCache.getDomainPeerToDn(conf);
            MutableBoolean usedPeer = new MutableBoolean(false);
            ExtendedBlockId blockId = new ExtendedBlockId(123L, "xyz");
            DatanodeInfo datanode = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(cluster.getDataNodes().get(0).getDatanodeId()).build();
            ShortCircuitShm.Slot slot1 = cache.allocShmSlot(datanode, peer, usedPeer, blockId, "testReleaseSlotReuseDomainSocket_client");
            cluster.getDataNodes().get(0).getShortCircuitRegistry().registerSlot(blockId, slot1.getSlotId(), false);
            ShortCircuitShm.Slot slot2 = cache.allocShmSlot(datanode, peer, usedPeer, blockId, "testReleaseSlotReuseDomainSocket_client");
            cluster.getDataNodes().get(0).getShortCircuitRegistry().registerSlot(blockId, slot2.getSlotId(), false);
            cache.scheduleSlotReleaser(slot1);
            Thread.sleep(2000L);
            cache.scheduleSlotReleaser(slot2);
            Thread.sleep(2000L);
            Assert.assertEquals((long)0L, (long)cluster.getDataNodes().get(0).getShortCircuitRegistry().getShmNum());
            Assert.assertEquals((long)0L, (long)cache.getDfsClientShmManager().getShmNum());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDNRestart() throws Exception {
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        Configuration conf = TestShortCircuitCache.createShortCircuitConf("testDNRestart", sockDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ShortCircuitCache cache = fs.getClient().getClientContext().getShortCircuitCache();
            DomainPeer peer = TestShortCircuitCache.getDomainPeerToDn(conf);
            MutableBoolean usedPeer = new MutableBoolean(false);
            ExtendedBlockId blockId = new ExtendedBlockId(123L, "xyz");
            DatanodeInfo datanode = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(cluster.getDataNodes().get(0).getDatanodeId()).build();
            ShortCircuitShm.Slot slot1 = cache.allocShmSlot(datanode, peer, usedPeer, blockId, "testReleaseSlotReuseDomainSocket_client");
            cluster.getDataNodes().get(0).getShortCircuitRegistry().registerSlot(blockId, slot1.getSlotId(), false);
            cluster.restartDataNode(0);
            Thread.sleep(1000L);
            cache.scheduleSlotReleaser(slot1);
            ShortCircuitShm.Slot slot2 = null;
            try {
                slot2 = cache.allocShmSlot(datanode, peer, usedPeer, blockId, "testReleaseSlotReuseDomainSocket_client");
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
            cache.scheduleSlotReleaser(slot2);
            Thread.sleep(2000L);
            Assert.assertEquals((long)0L, (long)cluster.getDataNodes().get(0).getShortCircuitRegistry().getShmNum());
            Assert.assertEquals((long)0L, (long)cache.getDfsClientShmManager().getShmNum());
        }
        finally {
            cluster.shutdown();
        }
    }

    public static class TestPreReceiptVerificationFailureInjector
    extends BlockReaderFactory.FailureInjector {
        public boolean getSupportsReceiptVerification() {
            return false;
        }
    }

    public static class TestCleanupFailureInjector
    extends BlockReaderFactory.FailureInjector {
        public void injectRequestFileDescriptorsFailure() throws IOException {
            throw new IOException("injected I/O error");
        }
    }

    private static class SimpleReplicaCreator
    implements ShortCircuitCache.ShortCircuitReplicaCreator {
        private final int blockId;
        private final ShortCircuitCache cache;
        private final TestFileDescriptorPair pair;

        SimpleReplicaCreator(int blockId, ShortCircuitCache cache, TestFileDescriptorPair pair) {
            this.blockId = blockId;
            this.cache = cache;
            this.pair = pair;
        }

        public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
            try {
                ExtendedBlockId key = new ExtendedBlockId((long)this.blockId, "test_bp1");
                return new ShortCircuitReplicaInfo(new ShortCircuitReplica(key, this.pair.getFileInputStreams()[0], this.pair.getFileInputStreams()[1], this.cache, Time.monotonicNow(), null));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TestFileDescriptorPair {
        final TemporarySocketDirectory dir = new TemporarySocketDirectory();
        final FileInputStream[] fis = new FileInputStream[2];

        public TestFileDescriptorPair() throws IOException {
            for (int i = 0; i < 2; ++i) {
                String name = this.dir.getDir() + "/file" + i;
                FileOutputStream fos = new FileOutputStream(name);
                if (i == 0) {
                    fos.write(1);
                } else {
                    BlockMetadataHeader header = new BlockMetadataHeader(1, DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)4));
                    DataOutputStream dos = new DataOutputStream(fos);
                    BlockMetadataHeader.writeHeader((DataOutputStream)dos, (BlockMetadataHeader)header);
                    dos.close();
                }
                fos.close();
                this.fis[i] = new FileInputStream(name);
            }
        }

        public FileInputStream[] getFileInputStreams() {
            return this.fis;
        }

        public void close() throws IOException {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])this.fis);
            this.dir.close();
        }

        public boolean compareWith(FileInputStream data, FileInputStream meta) {
            return data == this.fis[0] && meta == this.fis[1];
        }
    }
}

