/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;

public class Host {
    static final HostSerializer SERIALIZER = new HostSerializer();
    @NonNull
    private final String ipAddr;
    private final int port;
    private final String endpointId;
    private final String hostId;

    public Host(String ipAddr, int port, String endpointId) {
        this.ipAddr = ipAddr;
        this.port = port;
        this.endpointId = endpointId == null ? "" : endpointId;
        this.hostId = String.format("%s-%s", this.ipAddr, this.endpointId);
    }

    public String toString() {
        String endpoint = this.endpointId == null ? "" : String.format(":%s", this.endpointId);
        return String.format("%s:%d%s", this.getIpAddr(), this.getPort(), endpoint);
    }

    public static Host fromBytes(byte[] data) {
        return (Host)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static HostBuilder builder() {
        return new HostBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getIpAddr() {
        return this.ipAddr;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPort() {
        return this.port;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEndpointId() {
        return this.endpointId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getHostId() {
        return this.hostId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host other = (Host)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ipAddr = this.getIpAddr();
        String other$ipAddr = other.getIpAddr();
        if (this$ipAddr == null ? other$ipAddr != null : !this$ipAddr.equals(other$ipAddr)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$endpointId = this.getEndpointId();
        String other$endpointId = other.getEndpointId();
        if (this$endpointId == null ? other$endpointId != null : !this$endpointId.equals(other$endpointId)) {
            return false;
        }
        String this$hostId = this.getHostId();
        String other$hostId = other.getHostId();
        return !(this$hostId == null ? other$hostId != null : !this$hostId.equals(other$hostId));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Host;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ipAddr = this.getIpAddr();
        result = result * 59 + ($ipAddr == null ? 43 : $ipAddr.hashCode());
        result = result * 59 + this.getPort();
        String $endpointId = this.getEndpointId();
        result = result * 59 + ($endpointId == null ? 43 : $endpointId.hashCode());
        String $hostId = this.getHostId();
        result = result * 59 + ($hostId == null ? 43 : $hostId.hashCode());
        return result;
    }

    static class HostSerializer
    extends VersionedSerializer.WithBuilder<Host, HostBuilder> {
        HostSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, HostBuilder hostBuilder) throws IOException {
            hostBuilder.ipAddr(revisionDataInput.readUTF()).port(revisionDataInput.readInt()).endpointId(revisionDataInput.readUTF());
        }

        private void write00(Host host, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(host.ipAddr);
            revisionDataOutput.writeInt(host.port);
            revisionDataOutput.writeUTF(host.endpointId);
        }

        protected HostBuilder newBuilder() {
            return Host.builder();
        }
    }

    public static class HostBuilder
    implements ObjectBuilder<Host> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String ipAddr;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int port;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String endpointId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        HostBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HostBuilder ipAddr(String ipAddr) {
            this.ipAddr = ipAddr;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HostBuilder port(int port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HostBuilder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Host build() {
            return new Host(this.ipAddr, this.port, this.endpointId);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Host.HostBuilder(ipAddr=" + this.ipAddr + ", port=" + this.port + ", endpointId=" + this.endpointId + ")";
        }
    }
}

