/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.VolumeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.event.VolumeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.Volume;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeState;
import org.apache.hadoop.yarn.server.volume.csi.VolumeId;
import org.apache.hadoop.yarn.server.volume.csi.VolumeMetaData;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeImpl
implements Volume {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeImpl.class);
    private final Lock readLock;
    private final Lock writeLock;
    private final StateMachine<VolumeState, VolumeEventType, VolumeEvent> stateMachine;
    private final VolumeId volumeId;
    private final VolumeMetaData volumeMeta;
    private CsiAdaptorProtocol adaptorClient;

    public VolumeImpl(VolumeMetaData volumeMeta) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
        this.volumeId = volumeMeta.getVolumeId();
        this.volumeMeta = volumeMeta;
        this.stateMachine = this.createVolumeStateFactory().make((Object)this);
    }

    @Override
    @VisibleForTesting
    public void setClient(CsiAdaptorProtocol csiAdaptorClient) {
        this.adaptorClient = csiAdaptorClient;
    }

    @Override
    public CsiAdaptorProtocol getClient() {
        return this.adaptorClient;
    }

    @Override
    public VolumeMetaData getVolumeMeta() {
        return this.volumeMeta;
    }

    private StateMachineFactory<VolumeImpl, VolumeState, VolumeEventType, VolumeEvent> createVolumeStateFactory() {
        return new StateMachineFactory((Enum)VolumeState.NEW).addTransition((Enum)VolumeState.NEW, EnumSet.of(VolumeState.VALIDATED, VolumeState.UNAVAILABLE), (Enum)VolumeEventType.VALIDATE_VOLUME_EVENT, (MultipleArcTransition)new ValidateVolumeTransition()).addTransition((Enum)VolumeState.VALIDATED, (Enum)VolumeState.VALIDATED, (Enum)VolumeEventType.VALIDATE_VOLUME_EVENT).addTransition((Enum)VolumeState.VALIDATED, EnumSet.of(VolumeState.NODE_READY, VolumeState.UNAVAILABLE), (Enum)VolumeEventType.CONTROLLER_PUBLISH_VOLUME_EVENT, (MultipleArcTransition)new ControllerPublishVolumeTransition()).addTransition((Enum)VolumeState.UNAVAILABLE, EnumSet.of(VolumeState.UNAVAILABLE, VolumeState.VALIDATED), (Enum)VolumeEventType.VALIDATE_VOLUME_EVENT, (MultipleArcTransition)new ValidateVolumeTransition()).addTransition((Enum)VolumeState.UNAVAILABLE, (Enum)VolumeState.UNAVAILABLE, EnumSet.of(VolumeEventType.CONTROLLER_PUBLISH_VOLUME_EVENT)).addTransition((Enum)VolumeState.NODE_READY, (Enum)VolumeState.NODE_READY, EnumSet.of(VolumeEventType.CONTROLLER_PUBLISH_VOLUME_EVENT, VolumeEventType.VALIDATE_VOLUME_EVENT)).installTopology();
    }

    @Override
    public VolumeState getVolumeState() {
        this.readLock.lock();
        try {
            VolumeState volumeState = (VolumeState)this.stateMachine.getCurrentState();
            return volumeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public VolumeId getVolumeId() {
        this.readLock.lock();
        try {
            VolumeId volumeId = this.volumeId;
            return volumeId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(VolumeEvent event) {
        this.writeLock.lock();
        try {
            VolumeId volumeId = event.getVolumeId();
            if (volumeId == null) {
                LOG.warn("Unexpected volume event received, event type is " + ((VolumeEventType)event.getType()).name() + ", but the volumeId is null.");
                return;
            }
            LOG.info("Processing volume event, type=" + ((VolumeEventType)event.getType()).name() + ", volumeId=" + volumeId.toString());
            VolumeState oldState = null;
            VolumeState newState = null;
            try {
                oldState = (VolumeState)this.stateMachine.getCurrentState();
                newState = (VolumeState)this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.warn("Can't handle this event at current state: Current: [" + (Object)((Object)oldState) + "], eventType: [" + event.getType() + "], volumeId: [" + volumeId + "]", (Throwable)e);
            }
            if (newState != null && oldState != newState) {
                LOG.info("VolumeImpl " + volumeId + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static class ControllerPublishVolumeTransition
    implements MultipleArcTransition<VolumeImpl, VolumeEvent, VolumeState> {
        private ControllerPublishVolumeTransition() {
        }

        public VolumeState transition(VolumeImpl volume, VolumeEvent volumeEvent) {
            return VolumeState.NODE_READY;
        }
    }

    private static class ValidateVolumeTransition
    implements MultipleArcTransition<VolumeImpl, VolumeEvent, VolumeState> {
        private ValidateVolumeTransition() {
        }

        public VolumeState transition(VolumeImpl volume, VolumeEvent volumeEvent) {
            try {
                ValidateVolumeCapabilitiesRequest.VolumeCapability capability = new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.SINGLE_NODE_READER_ONLY, ValidateVolumeCapabilitiesRequest.VolumeType.FILE_SYSTEM, (List)ImmutableList.of());
                ValidateVolumeCapabilitiesRequest request = ValidateVolumeCapabilitiesRequest.newInstance((String)volume.getVolumeId().getId(), (List)ImmutableList.of((Object)capability), (Map)ImmutableMap.of());
                ValidateVolumeCapabilitiesResponse response = volume.getClient().validateVolumeCapacity(request);
                return response.isSupported() ? VolumeState.VALIDATED : VolumeState.UNAVAILABLE;
            }
            catch (IOException | YarnException e) {
                LOG.warn("Got exception while calling the CSI adaptor", e);
                return VolumeState.UNAVAILABLE;
            }
        }
    }
}

