/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3;

import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.bean.CompleteMultipartUploadResult;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.bean.PutObjectResult;
import com.emc.object.s3.request.AbortMultipartUploadRequest;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.InitiateMultipartUploadRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.emc.object.s3.request.UploadPartRequest;
import com.emc.object.util.InputStreamSegment;
import com.emc.object.util.ProgressInputStream;
import com.emc.object.util.ProgressListener;
import com.emc.rest.util.SizedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeFileUploader
implements Runnable,
ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(LargeFileUploader.class);
    public static final int DEFAULT_THREADS = 8;
    public static final int DEFAULT_MPU_THRESHOLD = 0x20000000;
    public static final long MIN_PART_SIZE = 0x400000L;
    public static final long DEFAULT_PART_SIZE = 0x8000000L;
    public static final int MAX_PARTS = 10000;
    private S3Client s3Client;
    private String bucket;
    private String key;
    private File file;
    private InputStream stream;
    private long fullSize;
    private AtomicLong bytesTransferred = new AtomicLong();
    private String eTag;
    private S3ObjectMetadata objectMetadata;
    private AccessControlList acl;
    private CannedAcl cannedAcl;
    private boolean closeStream = true;
    private long mpuThreshold = 0x20000000L;
    private Long partSize = 0x8000000L;
    private int threads = 8;
    private ExecutorService executorService;
    private ProgressListener progressListener;

    public LargeFileUploader(S3Client s3Client, String bucket, String key, File file) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.key = key;
        this.file = file;
    }

    public LargeFileUploader(S3Client s3Client, String bucket, String key, InputStream stream, long size) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.key = key;
        this.stream = stream;
        this.fullSize = size;
    }

    @Override
    public void progress(long completed, long total) {
    }

    @Override
    public void transferred(long size) {
        long totalTransferred = this.bytesTransferred.addAndGet(size);
        if (this.progressListener != null) {
            this.progressListener.transferred(size);
            this.progressListener.progress(totalTransferred, this.fullSize);
        }
    }

    @Override
    public void run() {
        this.upload();
    }

    public void upload() {
        this.configure();
        if (this.fullSize >= this.mpuThreshold) {
            this.doMultipartUpload();
        } else {
            this.doSinglePut();
        }
    }

    public void doSinglePut() {
        this.configure();
        InputStream is = null;
        try {
            is = this.file != null ? new FileInputStream(this.file) : this.stream;
            is = new ProgressInputStream(is, this);
            PutObjectRequest putRequest = new PutObjectRequest(this.bucket, this.key, is);
            putRequest.setObjectMetadata(this.objectMetadata);
            putRequest.setAcl(this.acl);
            putRequest.setCannedAcl(this.cannedAcl);
            PutObjectResult result = this.s3Client.putObject(putRequest);
            this.eTag = result.getETag();
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening file", e);
        }
        finally {
            if (is != null && this.closeStream) {
                try {
                    is.close();
                }
                catch (Throwable t) {
                    log.warn("could not close stream", t);
                }
            }
        }
    }

    public void doMultipartUpload() {
        this.configure();
        InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucket, this.key);
        initRequest.setObjectMetadata(this.objectMetadata);
        initRequest.setAcl(this.acl);
        initRequest.setCannedAcl(this.cannedAcl);
        String uploadId = this.s3Client.initiateMultipartUpload(initRequest).getUploadId();
        ArrayList<Future<MultipartPartETag>> futures = new ArrayList<Future<MultipartPartETag>>();
        try {
            int partNumber = 1;
            long length = this.partSize;
            for (long offset = 0L; offset < this.fullSize; offset += length) {
                if (offset + length > this.fullSize) {
                    length = this.fullSize - offset;
                }
                futures.add(this.executorService.submit(new UploadPartTask(uploadId, partNumber++, offset, length)));
            }
            TreeSet<MultipartPartETag> parts = new TreeSet<MultipartPartETag>();
            for (Future future : futures) {
                parts.add((MultipartPartETag)future.get());
            }
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(this.bucket, this.key, uploadId).withParts(parts);
            CompleteMultipartUploadResult completeMultipartUploadResult = this.s3Client.completeMultipartUpload(compRequest);
            this.eTag = completeMultipartUploadResult.getETag();
        }
        catch (Exception e) {
            try {
                this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, this.key, uploadId));
            }
            catch (Throwable t) {
                log.warn("could not abort upload after failure", t);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("error during upload", e);
        }
        finally {
            this.executorService.shutdown();
            if (this.stream != null && this.closeStream) {
                try {
                    this.stream.close();
                }
                catch (Throwable t) {
                    log.warn("could not close stream", t);
                }
            }
        }
    }

    public void doByteRangeUpload() {
        this.configure();
        PutObjectRequest request = new PutObjectRequest(this.bucket, this.key, null);
        request.setObjectMetadata(this.objectMetadata);
        request.setAcl(this.acl);
        request.setCannedAcl(this.cannedAcl);
        this.s3Client.putObject(request);
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        try {
            long length = this.partSize;
            for (long offset = 0L; offset < this.fullSize; offset += length) {
                if (offset + length > this.fullSize) {
                    length = this.fullSize - offset;
                }
                futures.add(this.executorService.submit(new PutObjectTask(offset, length)));
            }
            for (Future future : futures) {
                this.eTag = (String)future.get();
            }
        }
        catch (Exception e) {
            try {
                this.s3Client.deleteObject(this.bucket, this.key);
            }
            catch (Throwable t) {
                log.warn("could not delete object after failure", t);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("error during upload", e);
        }
        finally {
            this.executorService.shutdown();
            if (this.stream != null && this.closeStream) {
                try {
                    this.stream.close();
                }
                catch (Throwable t) {
                    log.warn("could not close stream", t);
                }
            }
        }
    }

    protected void configure() {
        if (this.file != null) {
            if (!this.file.exists() || !this.file.canRead()) {
                throw new IllegalArgumentException("cannot read file: " + this.file.getPath());
            }
            this.fullSize = this.file.length();
        } else {
            if (this.stream == null) {
                throw new IllegalArgumentException("must specify a file or stream to read");
            }
            if (this.fullSize <= 0L) {
                throw new IllegalArgumentException("size must be specified for stream");
            }
            this.executorService = null;
            this.threads = 1;
        }
        if (this.objectMetadata != null) {
            this.objectMetadata.setContentLength(null);
        }
        long minPartSize = Math.max(0x400000L, this.fullSize / 10000L + 1L);
        log.debug(String.format("minimum part size calculated as %,dk", minPartSize / 1024L));
        if (this.partSize == null) {
            this.partSize = minPartSize;
        }
        if (this.partSize < minPartSize) {
            log.warn(String.format("%,dk is below the minimum part size (%,dk). the minimum will be used instead", this.partSize / 1024L, minPartSize / 1024L));
            this.partSize = minPartSize;
        }
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(this.threads);
        }
    }

    public S3Client getS3Client() {
        return this.s3Client;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public long getFullSize() {
        return this.fullSize;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred.get();
    }

    public String getETag() {
        return this.eTag;
    }

    public S3ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public long getMpuThreshold() {
        return this.mpuThreshold;
    }

    public void setMpuThreshold(long mpuThreshold) {
        this.mpuThreshold = mpuThreshold;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public LargeFileUploader withObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public LargeFileUploader withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public LargeFileUploader withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }

    public LargeFileUploader withCloseStream(boolean closeStream) {
        this.setCloseStream(closeStream);
        return this;
    }

    public LargeFileUploader withMpuThreshold(long mpuThreshold) {
        this.setMpuThreshold(mpuThreshold);
        return this;
    }

    public LargeFileUploader withPartSize(Long partSize) {
        this.setPartSize(partSize);
        return this;
    }

    public LargeFileUploader withThreads(int threads) {
        this.setThreads(threads);
        return this;
    }

    public LargeFileUploader withExecutorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public LargeFileUploader withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    protected class PutObjectTask
    implements Callable<String> {
        private long offset;
        private long length;

        public PutObjectTask(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public String call() throws Exception {
            Range range = Range.fromOffsetLength(this.offset, this.length);
            InputStream is = LargeFileUploader.this.file != null ? new FileInputStream(LargeFileUploader.this.file) : LargeFileUploader.this.stream;
            is = new ProgressInputStream(is, LargeFileUploader.this);
            SizedInputStream segmentStream = LargeFileUploader.this.file != null ? new InputStreamSegment(is, this.offset, this.length) : new SizedInputStream(is, this.length);
            PutObjectRequest request = new PutObjectRequest(LargeFileUploader.this.bucket, LargeFileUploader.this.key, segmentStream).withRange(range);
            return LargeFileUploader.this.s3Client.putObject(request).getETag();
        }
    }

    private class UploadPartTask
    implements Callable<MultipartPartETag> {
        private String uploadId;
        private int partNumber;
        private long offset;
        private long length;

        public UploadPartTask(String uploadId, int partNumber, long offset, long length) {
            this.uploadId = uploadId;
            this.partNumber = partNumber;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public MultipartPartETag call() throws Exception {
            InputStream is = LargeFileUploader.this.file != null ? new FileInputStream(LargeFileUploader.this.file) : LargeFileUploader.this.stream;
            is = new ProgressInputStream(is, LargeFileUploader.this);
            SizedInputStream segmentStream = LargeFileUploader.this.file != null ? new InputStreamSegment(is, this.offset, this.length) : new SizedInputStream(is, this.length);
            UploadPartRequest request = new UploadPartRequest(LargeFileUploader.this.bucket, LargeFileUploader.this.key, this.uploadId, this.partNumber++, segmentStream);
            request.setContentLength(this.length);
            return LargeFileUploader.this.s3Client.uploadPart(request);
        }
    }
}

