/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.bean;

import com.emc.object.util.Iso8601DateAdapter;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"id", "prefix", "status", "expiration", "noncurrentVersionExpiration"})
public class LifecycleRule {
    private String id;
    private String prefix;
    private Status status;
    private Expiration expiration;
    private NoncurrentVersionExpiration noncurrentVersionExpiration;

    public LifecycleRule() {
        this(null, null, null);
    }

    public LifecycleRule(String id, String prefix, Status status) {
        this.id = id;
        this.prefix = prefix;
        this.status = status;
    }

    @Deprecated
    public LifecycleRule(String id, String prefix, Status status, Integer expirationDays) {
        this(id, prefix, status);
        this.setExpirationDays(expirationDays);
    }

    @Deprecated
    public LifecycleRule(String id, String prefix, Status status, Date expirationDate) {
        this(id, prefix, status);
        this.setExpirationDate(expirationDate);
    }

    public LifecycleRule withId(String id) {
        this.setId(id);
        return this;
    }

    public LifecycleRule withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public LifecycleRule withStatus(Status status) {
        this.setStatus(status);
        return this;
    }

    public LifecycleRule withExpirationDays(Integer expirationDays) {
        this.setExpirationDays(expirationDays);
        return this;
    }

    public LifecycleRule withExpirationDate(Date expirationDate) {
        this.setExpirationDate(expirationDate);
        return this;
    }

    public LifecycleRule withNoncurrentVersionExpirationDays(Integer days) {
        this.setNoncurrentVersionExpirationDays(days);
        return this;
    }

    @XmlElement(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="Prefix")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @XmlElement(name="Status")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @XmlElement(name="Expiration")
    protected Expiration getExpiration() {
        return this.expiration;
    }

    protected void setExpiration(Expiration expiration) {
        this.expiration = expiration;
    }

    @XmlTransient
    public Integer getExpirationDays() {
        return this.expiration == null ? null : this.expiration.days;
    }

    public void setExpirationDays(Integer expirationDays) {
        this.expiration = new Expiration();
        this.expiration.days = expirationDays;
    }

    @XmlTransient
    public Date getExpirationDate() {
        return this.expiration == null ? null : this.expiration.date;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expiration = new Expiration();
        this.expiration.date = expirationDate;
    }

    @XmlElement(name="NoncurrentVersionExpiration")
    protected NoncurrentVersionExpiration getNoncurrentVersionExpiration() {
        return this.noncurrentVersionExpiration;
    }

    protected void setNoncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
        this.noncurrentVersionExpiration = noncurrentVersionExpiration;
    }

    @XmlTransient
    public Integer getNoncurrentVersionExpirationDays() {
        return this.noncurrentVersionExpiration == null ? null : this.noncurrentVersionExpiration.days;
    }

    public void setNoncurrentVersionExpirationDays(Integer noncurrentDays) {
        this.noncurrentVersionExpiration = new NoncurrentVersionExpiration();
        this.noncurrentVersionExpiration.days = noncurrentDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleRule that = (LifecycleRule)o;
        if (this.id != null) {
            return this.id.equals(that.id);
        }
        if (this.getExpirationDate() != null ? !this.getExpirationDate().equals(that.getExpirationDate()) : that.getExpirationDate() != null) {
            return false;
        }
        if (this.getExpirationDays() != null ? !this.getExpirationDays().equals(that.getExpirationDays()) : that.getExpirationDays() != null) {
            return false;
        }
        if (this.getNoncurrentVersionExpirationDays() != null ? !this.getNoncurrentVersionExpirationDays().equals(that.getNoncurrentVersionExpirationDays()) : that.getNoncurrentVersionExpirationDays() != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.getExpirationDays() != null ? this.getExpirationDays().hashCode() : 0);
        result = 31 * result + (this.getExpirationDate() != null ? this.getExpirationDate().hashCode() : 0);
        result = 31 * result + (this.getNoncurrentVersionExpirationDays() != null ? this.getNoncurrentVersionExpirationDays().hashCode() : 0);
        return result;
    }

    @XmlEnum
    public static enum Status {
        Enabled,
        Disabled;

    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    protected static class NoncurrentVersionExpiration {
        @XmlElement(name="NoncurrentDays")
        public Integer days;

        protected NoncurrentVersionExpiration() {
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    protected static class Expiration {
        @XmlElement(name="Days")
        public Integer days;
        @XmlElement(name="Date")
        @XmlJavaTypeAdapter(value=Iso8601DateAdapter.class)
        public Date date;

        protected Expiration() {
        }
    }
}

