/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.jersey;

import com.emc.object.s3.S3Config;
import com.emc.object.util.RestUtil;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceFilter
extends ClientFilter {
    private static final Logger log = LoggerFactory.getLogger(NamespaceFilter.class);
    private S3Config s3Config;

    public static URI insertNamespace(URI uri, String namespace) {
        try {
            String hostname = namespace + "." + uri.getHost();
            log.debug("hostname including namespace: {}", (Object)hostname);
            return RestUtil.replaceHost(uri, hostname);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("namespace \"%s\" generated an invalid URI", namespace), e);
        }
    }

    public NamespaceFilter(S3Config s3Config) {
        this.s3Config = s3Config;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        String namespace = (String)request.getProperties().get("com.emc.object.namespace");
        if (namespace != null) {
            if (this.s3Config.isUseVHost()) {
                request.setURI(NamespaceFilter.insertNamespace(request.getURI(), namespace));
            } else {
                request.getHeaders().putSingle((Object)"x-emc-namespace", (Object)namespace);
            }
        }
        return this.getNext().handle(request);
    }
}

