/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.Method;
import com.emc.object.Range;
import com.emc.object.s3.request.ResponseHeaderOverride;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetObjectRequest<T extends GetObjectRequest<T>>
extends S3ObjectRequest {
    private String versionId;
    private Range range;
    private Date ifModifiedSince;
    private Date ifUnmodifiedSince;
    private String ifMatch;
    private String ifNoneMatch;
    private Map<ResponseHeaderOverride, String> headerOverrides = new HashMap<ResponseHeaderOverride, String>();

    public GetObjectRequest(String bucketName, String key) {
        this(Method.GET, bucketName, key);
    }

    protected GetObjectRequest(Method method, String bucketName, String key) {
        super(method, bucketName, key, null);
    }

    @Override
    public Map<String, String> getQueryParams() {
        Map<String, String> queryParams = super.getQueryParams();
        if (this.versionId != null) {
            queryParams.put("versionId", this.versionId);
        }
        for (ResponseHeaderOverride override : this.headerOverrides.keySet()) {
            queryParams.put(override.getQueryParam(), this.headerOverrides.get((Object)override));
        }
        return queryParams;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.range != null) {
            RestUtil.putSingle(headers, "Range", "bytes=" + this.range.toString());
        }
        if (this.ifModifiedSince != null) {
            RestUtil.putSingle(headers, "If-Modified-Since", RestUtil.headerFormat(this.ifModifiedSince));
        }
        if (this.ifUnmodifiedSince != null) {
            RestUtil.putSingle(headers, "If-Unmodified-Since", RestUtil.headerFormat(this.ifUnmodifiedSince));
        }
        if (this.ifMatch != null) {
            RestUtil.putSingle(headers, "If-Match", this.ifMatch);
        }
        if (this.ifNoneMatch != null) {
            RestUtil.putSingle(headers, "If-None-Match", this.ifNoneMatch);
        }
        return headers;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Date getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public void setIfModifiedSince(Date ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
    }

    public Date getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public void setIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ifUnmodifiedSince;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public Map<ResponseHeaderOverride, String> getHeaderOverrides() {
        return this.headerOverrides;
    }

    public void setHeaderOverrides(Map<ResponseHeaderOverride, String> headerOverrides) {
        this.headerOverrides = headerOverrides;
    }

    public T withVersionId(String versionId) {
        this.setVersionId(versionId);
        return (T)this;
    }

    public T withRange(Range range) {
        this.setRange(range);
        return (T)this;
    }

    public T withIfModifiedSince(Date ifModifiedSince) {
        this.setIfModifiedSince(ifModifiedSince);
        return (T)this;
    }

    public T withIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.setIfUnmodifiedSince(ifUnmodifiedSince);
        return (T)this;
    }

    public T withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return (T)this;
    }

    public T withIfNoneMatch(String ifNoneMatch) {
        this.setIfNoneMatch(ifNoneMatch);
        return (T)this;
    }

    public T headerOverride(ResponseHeaderOverride override, String value) {
        this.headerOverrides.put(override, value);
        return (T)this;
    }
}

