/*
 * Decompiled with CFR 0.152.
 */
package com.emc.object.s3.request;

import com.emc.object.EntityRequest;
import com.emc.object.Method;
import com.emc.object.Range;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.AccessControlList;
import com.emc.object.s3.bean.CannedAcl;
import com.emc.object.s3.request.S3ObjectRequest;
import com.emc.object.util.RestUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PutObjectRequest
extends S3ObjectRequest
implements EntityRequest {
    private S3ObjectMetadata objectMetadata;
    private Object object;
    private Range range;
    private Date ifModifiedSince;
    private Date ifUnmodifiedSince;
    private String ifMatch;
    private String ifNoneMatch;
    private AccessControlList acl;
    private CannedAcl cannedAcl;

    public PutObjectRequest(String bucketName, String key, Object object) {
        super(Method.PUT, bucketName, key, null);
        this.object = object;
    }

    public PutObjectRequest(PutObjectRequest other) {
        super(other);
        this.objectMetadata = other.objectMetadata;
        this.object = other.object;
        this.range = other.range;
        this.acl = other.acl;
        this.cannedAcl = other.cannedAcl;
    }

    @Override
    public Map<String, List<Object>> getHeaders() {
        Map<String, List<Object>> headers = super.getHeaders();
        if (this.range != null) {
            RestUtil.putSingle(headers, "Range", "bytes=" + this.range.toString());
        }
        if (this.objectMetadata != null) {
            headers.putAll(this.objectMetadata.toHeaders());
        }
        if (this.ifModifiedSince != null) {
            RestUtil.putSingle(headers, "If-Modified-Since", RestUtil.headerFormat(this.ifModifiedSince));
        }
        if (this.ifUnmodifiedSince != null) {
            RestUtil.putSingle(headers, "If-Unmodified-Since", RestUtil.headerFormat(this.ifUnmodifiedSince));
        }
        if (this.ifMatch != null) {
            RestUtil.putSingle(headers, "If-Match", this.ifMatch);
        }
        if (this.ifNoneMatch != null) {
            RestUtil.putSingle(headers, "If-None-Match", this.ifNoneMatch);
        }
        if (this.acl != null) {
            headers.putAll(this.acl.toHeaders());
        }
        if (this.cannedAcl != null) {
            RestUtil.putSingle(headers, "x-amz-acl", this.cannedAcl.getHeaderValue());
        }
        return headers;
    }

    @Override
    public Object getEntity() {
        return this.getObject();
    }

    @Override
    public String getContentType() {
        return this.objectMetadata != null ? this.objectMetadata.getContentType() : null;
    }

    @Override
    public Long getContentLength() {
        return this.objectMetadata != null ? this.objectMetadata.getContentLength() : null;
    }

    @Override
    public boolean isChunkable() {
        return true;
    }

    public S3ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public Object getObject() {
        return this.object;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Date getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public void setIfModifiedSince(Date ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
    }

    public Date getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public void setIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ifUnmodifiedSince;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public CannedAcl getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAcl cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    @Deprecated
    public Long getRetentionPeriod() {
        return this.objectMetadata == null ? null : this.objectMetadata.getRetentionPeriod();
    }

    @Deprecated
    public void setRetentionPeriod(Long retentionPeriod) {
        if (this.objectMetadata == null) {
            this.objectMetadata = new S3ObjectMetadata();
        }
        this.objectMetadata.setRetentionPeriod(retentionPeriod);
    }

    @Deprecated
    public String getRetentionPolicy() {
        return this.objectMetadata == null ? null : this.objectMetadata.getRetentionPolicy();
    }

    @Deprecated
    public void setRetentionPolicy(String retentionPolicy) {
        if (this.objectMetadata == null) {
            this.objectMetadata = new S3ObjectMetadata();
        }
        this.objectMetadata.setRetentionPolicy(retentionPolicy);
    }

    public PutObjectRequest withObjectMetadata(S3ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public PutObjectRequest withRange(Range range) {
        this.setRange(range);
        return this;
    }

    public PutObjectRequest withIfModifiedSince(Date ifModifiedSince) {
        this.setIfModifiedSince(ifModifiedSince);
        return this;
    }

    public PutObjectRequest withIfUnmodifiedSince(Date ifUnmodifiedSince) {
        this.setIfUnmodifiedSince(ifUnmodifiedSince);
        return this;
    }

    public PutObjectRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public PutObjectRequest withIfNoneMatch(String ifNoneMatch) {
        this.setIfNoneMatch(ifNoneMatch);
        return this;
    }

    public PutObjectRequest withAcl(AccessControlList acl) {
        this.setAcl(acl);
        return this;
    }

    public PutObjectRequest withCannedAcl(CannedAcl cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }

    @Deprecated
    public PutObjectRequest withRetentionPeriod(long retentionPeriod) {
        this.setRetentionPeriod(retentionPeriod);
        return this;
    }

    @Deprecated
    public PutObjectRequest withRetentionPolicy(String retentionPolicy) {
        this.setRetentionPolicy(retentionPolicy);
        return this;
    }
}

