/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ClientConnection;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.Flow;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.impl.ConnectionClosedException;
import io.pravega.common.concurrent.Futures;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.FailingReplyProcessor;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawClient
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RawClient.class);
    private final CompletableFuture<ClientConnection> connection;
    private final Segment segmentId;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<Long, CompletableFuture<Reply>> requests = new HashMap<Long, CompletableFuture<Reply>>();
    private final ResponseProcessor responseProcessor = new ResponseProcessor();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Flow flow = Flow.create();

    public RawClient(PravegaNodeUri uri, ConnectionPool connectionPool) {
        this.segmentId = null;
        this.connection = new CompletableFuture();
        this.connection.exceptionally(e -> {
            log.warn("Exception observed while attempting to obtain a connection to segment store {}", (Object)uri, e);
            return null;
        });
        Futures.exceptionListener(this.connection, this::closeConnection);
        connectionPool.getClientConnection(this.flow, uri, (ReplyProcessor)this.responseProcessor, this.connection);
    }

    public RawClient(Controller controller, ConnectionPool connectionPool, Segment segmentId) {
        this.segmentId = segmentId;
        this.connection = new CompletableFuture();
        this.connection.exceptionally(e -> {
            log.warn("Exception observed while attempting to obtain a connection to segment {}", (Object)segmentId, e);
            return null;
        });
        Futures.exceptionListener(this.connection, this::closeConnection);
        ((CompletableFuture)controller.getEndpointForSegment(segmentId.getScopedName()).thenAccept(uri -> connectionPool.getClientConnection(this.flow, (PravegaNodeUri)uri, (ReplyProcessor)this.responseProcessor, this.connection))).exceptionally(e -> {
            this.connection.completeExceptionally((Throwable)e);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reply(Reply reply) {
        CompletableFuture<Reply> future;
        Object object = this.lock;
        synchronized (object) {
            future = this.requests.remove(reply.getRequestId());
        }
        if (future != null) {
            future.complete(reply);
        } else {
            log.info("Could not find any matching request for {}. Ignoring.", (Object)reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Throwable exceptionToInflightRequests) {
        ArrayList<CompletableFuture<Reply>> requestsToFail;
        if (this.closed.get() || exceptionToInflightRequests instanceof ConnectionClosedException) {
            log.debug("Closing connection as requested");
        } else {
            log.warn("Closing connection to segment {} with exception", (Object)this.segmentId, (Object)exceptionToInflightRequests);
        }
        if (this.closed.compareAndSet(false, true)) {
            this.connection.thenAccept(c -> {
                try {
                    c.close();
                }
                catch (Exception e) {
                    log.warn("Exception tearing down connection {} : ", c, (Object)e);
                }
            });
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            requestsToFail = new ArrayList<CompletableFuture<Reply>>(this.requests.values());
            this.requests.clear();
        }
        for (CompletableFuture completableFuture : requestsToFail) {
            completableFuture.completeExceptionally(exceptionToInflightRequests);
        }
    }

    public <T extends Request & WireCommand> CompletableFuture<Reply> sendRequest(long requestId, T request) {
        return this.connection.thenCompose(c -> {
            log.debug("Sending request: {}", (Object)request);
            CompletableFuture reply = new CompletableFuture();
            Object object = this.lock;
            synchronized (object) {
                this.requests.put(requestId, reply);
            }
            try {
                c.send(request);
            }
            catch (ConnectionFailedException cfe) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.requests.remove(requestId);
                }
                reply.completeExceptionally(cfe);
                this.closeConnection(cfe);
            }
            return reply;
        });
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.closeConnection(new ConnectionClosedException());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Flow getFlow() {
        return this.flow;
    }

    private final class ResponseProcessor
    extends FailingReplyProcessor {
        private ResponseProcessor() {
        }

        public void process(Reply reply) {
            if (reply instanceof WireCommands.Hello) {
                WireCommands.Hello hello = (WireCommands.Hello)reply;
                log.info("Received hello: {}", (Object)hello);
                if (hello.getLowVersion() > 14 || hello.getHighVersion() < 5) {
                    RawClient.this.closeConnection(new IllegalStateException("Incompatible wire protocol versions " + hello));
                }
            } else if (reply instanceof WireCommands.WrongHost) {
                RawClient.this.closeConnection(new ConnectionFailedException(reply.toString()));
            } else if (reply instanceof WireCommands.ErrorMessage) {
                WireCommands.ErrorMessage errorMessage = (WireCommands.ErrorMessage)reply;
                log.info("Received an errorMessage containing an unhandled {} on segment {}", (Object)errorMessage.getErrorCode().getExceptionType().getSimpleName(), (Object)errorMessage.getSegment());
                RawClient.this.closeConnection(errorMessage.getThrowableException());
            } else {
                log.debug("Received reply {}", (Object)reply);
                RawClient.this.reply(reply);
            }
        }

        public void connectionDropped() {
            RawClient.this.closeConnection(new ConnectionFailedException());
        }

        public void processingFailure(Exception error) {
            log.warn("Processing failure on segment {}", (Object)RawClient.this.segmentId, (Object)error);
            RawClient.this.closeConnection(error);
        }

        public void authTokenCheckFailed(WireCommands.AuthTokenCheckFailed authTokenCheckFailed) {
            log.warn("Auth token check failed on segment {} with {}", (Object)RawClient.this.segmentId, (Object)authTokenCheckFailed);
            if (authTokenCheckFailed.isTokenExpired()) {
                RawClient.this.closeConnection((Throwable)new TokenExpiredException(authTokenCheckFailed.getServerStackTrace()));
            } else {
                RawClient.this.closeConnection((Throwable)new AuthenticationException(authTokenCheckFailed.toString()));
            }
        }
    }
}

