/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.Unpooled;
import io.pravega.auth.AuthenticationException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ClientConnection;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.Flow;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.AsyncSegmentInputStream;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.client.stream.impl.ConnectionClosedException;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.FailingReplyProcessor;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncSegmentInputStreamImpl
extends AsyncSegmentInputStream {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSegmentInputStreamImpl.class);
    private final Retry.RetryWithBackoff backoffSchedule = Retry.withExpBackoff((long)1L, (int)10, (int)9, (long)30000L);
    private final ConnectionPool connectionPool;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private CompletableFuture<ClientConnection> connection = null;
    @GuardedBy(value="lock")
    private final Map<Long, CompletableFuture<WireCommands.SegmentRead>> outstandingRequests = new HashMap<Long, CompletableFuture<WireCommands.SegmentRead>>();
    private final ResponseProcessor responseProcessor = new ResponseProcessor();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Controller controller;
    private final DelegationTokenProvider tokenProvider;
    @VisibleForTesting
    private final long requestId = Flow.create().asLong();
    private final Semaphore replyAvailable;

    public AsyncSegmentInputStreamImpl(Controller controller, ConnectionPool connectionPool, Segment segment, DelegationTokenProvider tokenProvider, Semaphore dataAvailable) {
        super(segment);
        this.tokenProvider = tokenProvider;
        Preconditions.checkNotNull((Object)controller);
        Preconditions.checkNotNull((Object)connectionPool);
        Preconditions.checkNotNull((Object)segment);
        this.controller = controller;
        this.connectionPool = connectionPool;
        this.replyAvailable = dataAvailable;
    }

    @Override
    public void close() {
        log.info("Closing reader for {}", (Object)this.segmentId);
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnection(new ConnectionClosedException());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public CompletableFuture<WireCommands.SegmentRead> read(long offset, int length) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.backoffSchedule.retryWhen(t -> {
            Throwable ex = Exceptions.unwrap((Throwable)t);
            if (this.closed.get()) {
                log.debug("Exception: {} while reading from Segment : {}", (Object)ex.toString(), (Object)this.segmentId);
            } else {
                log.warn("Exception while reading from Segment {} at offset {} :", new Object[]{this.segmentId, offset, ex});
            }
            return ex instanceof Exception && !(ex instanceof ConnectionClosedException) && !(ex instanceof SegmentTruncatedException) && !(ex instanceof AuthenticationException);
        }).runAsync(() -> this.tokenProvider.retrieveToken().thenComposeAsync(token -> {
            WireCommands.ReadSegment request = new WireCommands.ReadSegment(this.segmentId.getScopedName(), offset, length, token, this.requestId);
            return ((CompletableFuture)this.getConnection().whenComplete((connection1, ex) -> {
                if (ex != null) {
                    log.warn("Exception while establishing connection with Pravega node {}: ", connection1, ex);
                    this.closeConnection((Exception)((Object)new ConnectionFailedException(ex)));
                }
            })).thenCompose(c -> this.sendRequestOverConnection(request, (ClientConnection)c).whenComplete((reply, ex) -> {
                if (ex instanceof ConnectionFailedException) {
                    log.debug("ConnectionFailedException observed when sending request {}", (Object)request, ex);
                    this.closeConnection((Exception)((Object)((ConnectionFailedException)((Object)((Object)((Object)((Object)ex)))))));
                }
            }));
        }, (Executor)this.connectionPool.getInternalExecutor()), this.connectionPool.getInternalExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<WireCommands.SegmentRead> sendRequestOverConnection(WireCommands.ReadSegment request, ClientConnection c) {
        CompletableFuture<WireCommands.SegmentRead> result = new CompletableFuture<WireCommands.SegmentRead>();
        if (this.closed.get()) {
            result.completeExceptionally(new ConnectionClosedException());
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            this.outstandingRequests.put(request.getOffset(), result);
        }
        log.trace("Sending read request {}", (Object)request);
        try {
            c.send((WireCommand)request);
        }
        catch (ConnectionFailedException cfe) {
            log.error("Error while sending request {} to Pravega node {} :", new Object[]{request, c, cfe});
            Object object2 = this.lock;
            synchronized (object2) {
                this.outstandingRequests.remove(request.getOffset());
            }
            result.completeExceptionally(cfe);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Exception exceptionToInflightRequests) {
        CompletableFuture<ClientConnection> c;
        if (this.closed.get()) {
            log.info("Closing connection to segment: {}", (Object)this.segmentId);
        } else {
            log.warn("Closing connection to segment {} with exception: {}", (Object)this.segmentId, (Object)exceptionToInflightRequests.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            c = this.connection;
            this.connection = null;
        }
        if (c != null && Futures.isSuccessful(c)) {
            try {
                ((ClientConnection)c.getNow(null)).close();
            }
            catch (Exception e) {
                log.warn("Exception tearing down connection: ", (Throwable)e);
            }
        }
        this.failAllInflight(exceptionToInflightRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<ClientConnection> getConnection() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection != null) {
                return this.connection;
            }
        }
        return this.controller.getEndpointForSegment(this.segmentId.getScopedName()).thenCompose(uri -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.connection == null) {
                    this.connection = this.connectionPool.getClientConnection(Flow.from(this.requestId), (PravegaNodeUri)uri, (ReplyProcessor)this.responseProcessor);
                }
                return this.connection;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failAllInflight(Exception e) {
        ArrayList<CompletableFuture<WireCommands.SegmentRead>> readsToFail;
        log.info("Connection failed due to a {}. Read requests for segment {} will be retransmitted.", (Object)e.toString(), (Object)this.segmentId);
        Iterator iterator = this.lock;
        synchronized (iterator) {
            readsToFail = new ArrayList<CompletableFuture<WireCommands.SegmentRead>>(this.outstandingRequests.values());
            this.outstandingRequests.clear();
        }
        for (CompletableFuture completableFuture : readsToFail) {
            completableFuture.completeExceptionally(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    private final class ResponseProcessor
    extends FailingReplyProcessor {
        private ResponseProcessor() {
        }

        public void process(Reply reply) {
            super.process(reply);
            if (AsyncSegmentInputStreamImpl.this.replyAvailable != null) {
                AsyncSegmentInputStreamImpl.this.replyAvailable.release();
            }
        }

        public void connectionDropped() {
            AsyncSegmentInputStreamImpl.this.closeConnection((Exception)((Object)new ConnectionFailedException()));
        }

        public void wrongHost(WireCommands.WrongHost wrongHost) {
            AsyncSegmentInputStreamImpl.this.closeConnection((Exception)((Object)new ConnectionFailedException(wrongHost.toString())));
        }

        public void noSuchSegment(WireCommands.NoSuchSegment noSuchSegment) {
            log.info("Received noSuchSegment {}", (Object)noSuchSegment);
            CompletableFuture<WireCommands.SegmentRead> future = this.grabFuture(noSuchSegment.getSegment(), noSuchSegment.getOffset());
            if (future != null) {
                future.completeExceptionally(new SegmentTruncatedException(String.format("Segment %s no longer exists.", noSuchSegment.getSegment())));
            }
        }

        public void segmentIsTruncated(WireCommands.SegmentIsTruncated segmentIsTruncated) {
            log.info("Received segmentIsTruncated {}", (Object)segmentIsTruncated);
            CompletableFuture<WireCommands.SegmentRead> future = this.grabFuture(segmentIsTruncated.getSegment(), segmentIsTruncated.getOffset());
            if (future != null) {
                future.completeExceptionally(new SegmentTruncatedException(segmentIsTruncated.toString()));
            }
        }

        public void segmentIsSealed(WireCommands.SegmentIsSealed segmentIsSealed) {
            log.info("Received segmentSealed {}", (Object)segmentIsSealed);
            CompletableFuture<WireCommands.SegmentRead> future = this.grabFuture(segmentIsSealed.getSegment(), segmentIsSealed.getOffset());
            if (future != null) {
                future.complete(new WireCommands.SegmentRead(segmentIsSealed.getSegment(), segmentIsSealed.getOffset(), true, true, Unpooled.EMPTY_BUFFER, segmentIsSealed.getRequestId()));
            }
        }

        public void segmentRead(WireCommands.SegmentRead segmentRead) {
            log.trace("Received read result {}", (Object)segmentRead);
            CompletableFuture<WireCommands.SegmentRead> future = this.grabFuture(segmentRead.getSegment(), segmentRead.getOffset());
            if (future != null) {
                future.complete(segmentRead);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<WireCommands.SegmentRead> grabFuture(String segment, long offset) {
            this.checkSegment(segment);
            Object object = AsyncSegmentInputStreamImpl.this.lock;
            synchronized (object) {
                return (CompletableFuture)AsyncSegmentInputStreamImpl.this.outstandingRequests.remove(offset);
            }
        }

        public void processingFailure(Exception error) {
            log.warn("Processing failure on segment {}", (Object)AsyncSegmentInputStreamImpl.this.segmentId, (Object)error);
            AsyncSegmentInputStreamImpl.this.closeConnection(error);
        }

        public void authTokenCheckFailed(WireCommands.AuthTokenCheckFailed authTokenCheckFailed) {
            log.warn("Auth check failed for reads on segment {} with {}", (Object)AsyncSegmentInputStreamImpl.this.segmentId, (Object)authTokenCheckFailed);
            if (authTokenCheckFailed.isTokenExpired()) {
                AsyncSegmentInputStreamImpl.this.tokenProvider.signalTokenExpired();
                AsyncSegmentInputStreamImpl.this.closeConnection((Exception)new TokenExpiredException(authTokenCheckFailed.getServerStackTrace()));
            } else {
                AsyncSegmentInputStreamImpl.this.closeConnection((Exception)new AuthenticationException(authTokenCheckFailed.toString()));
            }
        }

        private void checkSegment(String segment) {
            Preconditions.checkState((boolean)AsyncSegmentInputStreamImpl.this.segmentId.getScopedName().equals(segment), (String)"Operating on segmentId {} but received sealed for segment {}", (Object)AsyncSegmentInputStreamImpl.this.segmentId, (Object)segment);
        }

        public void errorMessage(WireCommands.ErrorMessage errorMessage) {
            log.info("Received an errorMessage containing an unhandled {} on segment {}", (Object)errorMessage.getErrorCode().getExceptionType().getSimpleName(), (Object)errorMessage.getSegment());
            AsyncSegmentInputStreamImpl.this.closeConnection(errorMessage.getThrowableException());
        }
    }
}

