/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.segment.impl.SegmentOutputStreamFactory;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.impl.PendingEvent;
import io.pravega.client.stream.impl.Pinger;
import io.pravega.client.stream.impl.SegmentSelector;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.util.ByteBufferUtils;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.common.util.Retry;
import io.pravega.common.util.ReusableLatch;
import io.pravega.shared.security.auth.AccessOperation;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStreamWriterImpl<Type>
implements EventStreamWriter<Type> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventStreamWriterImpl.class);
    private final Object writeFlushLock = new Object();
    private final Object writeSealLock = new Object();
    private final Stream stream;
    private final String writerId;
    private final Serializer<Type> serializer;
    private final Controller controller;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final EventWriterConfig config;
    private final SegmentSelector selector;
    private final Consumer<Segment> segmentSealedCallBack;
    private final ConcurrentLinkedQueue<Segment> sealedSegmentQueue = new ConcurrentLinkedQueue();
    private final ReusableLatch sealedSegmentQueueEmptyLatch = new ReusableLatch(true);
    private final ExecutorService retransmitPool;
    private final Pinger pinger;
    private final DelegationTokenProvider tokenProvider;

    EventStreamWriterImpl(Stream stream, String writerId, Controller controller, SegmentOutputStreamFactory outputStreamFactory, Serializer<Type> serializer, EventWriterConfig config, ExecutorService retransmitPool, ScheduledExecutorService internalExecutor) {
        this.writerId = writerId;
        this.stream = (Stream)Preconditions.checkNotNull((Object)stream);
        this.controller = (Controller)Preconditions.checkNotNull((Object)controller);
        this.segmentSealedCallBack = this::handleLogSealed;
        this.tokenProvider = DelegationTokenProviderFactory.create(this.controller, this.stream.getScope(), this.stream.getStreamName(), AccessOperation.WRITE);
        this.selector = new SegmentSelector(stream, controller, outputStreamFactory, config, this.tokenProvider);
        this.serializer = (Serializer)Preconditions.checkNotNull(serializer);
        this.config = config;
        this.retransmitPool = (ExecutorService)Preconditions.checkNotNull((Object)retransmitPool);
        this.pinger = new Pinger(config.getTransactionTimeoutTime(), stream, controller, internalExecutor);
        List<PendingEvent> failedEvents = this.selector.refreshSegmentEventWriters(this.segmentSealedCallBack);
        assert (failedEvents.isEmpty()) : "There should not be any events to have failed";
        if (config.isAutomaticallyNoteTime()) {
            internalExecutor.scheduleWithFixedDelay(() -> this.noteTimeInternal(System.currentTimeMillis()), 5L, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public CompletableFuture<Void> writeEvent(Type event) {
        return this.writeEventInternal(null, event);
    }

    @Override
    public CompletableFuture<Void> writeEvent(String routingKey, Type event) {
        Preconditions.checkNotNull((Object)routingKey);
        return this.writeEventInternal(routingKey, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> writeEventInternal(String routingKey, Type event) {
        Preconditions.checkNotNull(event);
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ByteBuffer data = this.serializer.serialize(event);
        CompletableFuture<Void> ackFuture = new CompletableFuture<Void>();
        Object object = this.writeFlushLock;
        synchronized (object) {
            Object object2 = this.writeSealLock;
            synchronized (object2) {
                SegmentOutputStream segmentWriter = this.getSegmentWriter(routingKey);
                segmentWriter.write(PendingEvent.withHeader(routingKey, data, ackFuture));
            }
        }
        return ackFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> writeEvents(String routingKey, List<Type> events) {
        Preconditions.checkNotNull((Object)routingKey);
        Preconditions.checkNotNull(events);
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        List<ByteBuffer> data = events.stream().map(this.serializer::serialize).collect(Collectors.toList());
        CompletableFuture<Void> ackFuture = new CompletableFuture<Void>();
        Object object = this.writeFlushLock;
        synchronized (object) {
            Object object2 = this.writeSealLock;
            synchronized (object2) {
                SegmentOutputStream segmentWriter = this.getSegmentWriter(routingKey);
                segmentWriter.write(PendingEvent.withHeader(routingKey, data, ackFuture));
            }
        }
        return ackFuture;
    }

    private SegmentOutputStream getSegmentWriter(String routingKey) {
        SegmentOutputStream segmentWriter = this.selector.getSegmentOutputStreamForKey(routingKey);
        while (segmentWriter == null) {
            log.info("Don't have a writer for segment: {}", (Object)this.selector.getSegmentForEvent(routingKey));
            this.handleMissingLog();
            segmentWriter = this.selector.getSegmentOutputStreamForKey(routingKey);
        }
        return segmentWriter;
    }

    @GuardedBy(value="writeSealLock")
    private void handleMissingLog() {
        List<PendingEvent> toResend = this.selector.refreshSegmentEventWriters(this.segmentSealedCallBack);
        this.resend(toResend);
    }

    private void handleLogSealed(Segment segment) {
        this.sealedSegmentQueueEmptyLatch.reset();
        this.sealedSegmentQueue.add(segment);
        this.retransmitPool.execute(() -> Retry.indefinitelyWithExpBackoff((long)this.config.getInitialBackoffMillis(), (int)this.config.getBackoffMultiple(), (long)this.config.getMaxBackoffMillis(), t -> log.error("Encountered exception when handling a sealed segment: ", t)).run(() -> {
            Object object = this.writeSealLock;
            synchronized (object) {
                Segment toSeal = this.sealedSegmentQueue.poll();
                log.info("Sealing segment {} ", (Object)toSeal);
                while (toSeal != null) {
                    this.resend(this.selector.refreshSegmentEventWritersUponSealed(toSeal, this.segmentSealedCallBack));
                    this.selector.removeSegmentWriter(toSeal);
                    for (SegmentOutputStream writer : this.selector.getWriters().values()) {
                        try {
                            writer.write(PendingEvent.withoutHeader(null, ByteBufferUtils.EMPTY, null));
                            writer.flush();
                        }
                        catch (SegmentSealedException e) {
                            log.info("Flush on segment {} failed due to {}, it will be retried.", (Object)writer.getSegmentName(), (Object)e.getMessage());
                        }
                        catch (RetriesExhaustedException e1) {
                            log.warn("Flush on segment {} failed after all retries", (Object)writer.getSegmentName(), (Object)e1);
                        }
                    }
                    toSeal = this.sealedSegmentQueue.poll();
                    log.info("Sealing another segment {} ", (Object)toSeal);
                }
                this.sealedSegmentQueueEmptyLatch.release();
            }
            return null;
        }));
    }

    @GuardedBy(value="writeSealLock")
    private void resend(List<PendingEvent> toResend) {
        while (!toResend.isEmpty()) {
            ArrayList<PendingEvent> unsent = new ArrayList<PendingEvent>();
            boolean sendFailed = false;
            log.info("Resending {} events", (Object)toResend.size());
            for (PendingEvent event : toResend) {
                if (sendFailed) {
                    unsent.add(event);
                    continue;
                }
                SegmentOutputStream segmentWriter = this.selector.getSegmentOutputStreamForKey(event.getRoutingKey());
                if (segmentWriter == null) {
                    log.info("No writer for segment during resend.");
                    unsent.addAll(this.selector.refreshSegmentEventWriters(this.segmentSealedCallBack));
                    sendFailed = true;
                    continue;
                }
                segmentWriter.write(event);
            }
            toResend = unsent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        Object object = this.writeFlushLock;
        synchronized (object) {
            boolean success = false;
            RetriesExhaustedException retriesExhaustedException = null;
            block6: while (!success) {
                success = true;
                for (SegmentOutputStream writer : this.selector.getWriters().values()) {
                    try {
                        writer.flush();
                    }
                    catch (SegmentSealedException e) {
                        success = false;
                        log.warn("Flush on segment {} by event writer {} failed due to {}, it will be retried.", new Object[]{writer.getSegmentName(), this.writerId, e.getMessage()});
                        this.tryWaitForSuccessors();
                        continue block6;
                    }
                    catch (RetriesExhaustedException e1) {
                        log.warn("Flush on segment {} by event writer {} failed after all configured retries", (Object)writer.getSegmentName(), (Object)this.writerId);
                        retriesExhaustedException = e1;
                    }
                }
            }
            if (retriesExhaustedException != null) {
                log.error("Flush by writer {} on Stream {} failed after all retries to connect with Pravega exhausted.", (Object)this.writerId, (Object)this.stream.getScopedName());
                throw retriesExhaustedException;
            }
        }
    }

    @GuardedBy(value="writeFlushLock")
    private void tryWaitForSuccessors() {
        Exceptions.handleInterrupted(() -> this.sealedSegmentQueueEmptyLatch.await());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.pinger.close();
        Object object = this.writeFlushLock;
        synchronized (object) {
            boolean success = false;
            while (!success) {
                success = true;
                for (SegmentOutputStream writer : this.selector.getWriters().values()) {
                    try {
                        writer.close();
                    }
                    catch (SegmentSealedException e) {
                        success = false;
                        log.warn("Close failed due to {}, it will be retried.", (Object)e.getMessage());
                        this.tryWaitForSuccessors();
                    }
                }
            }
        }
        ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.retransmitPool});
    }

    @Override
    public EventWriterConfig getConfig() {
        return this.config;
    }

    @Override
    public void noteTime(long timestamp) {
        Preconditions.checkState((!this.config.isAutomaticallyNoteTime() ? 1 : 0) != 0, (Object)"To note time, automatic noting of time should be disabled.");
        this.noteTimeInternal(timestamp);
    }

    private void noteTimeInternal(long timestamp) {
        Map<Segment, Long> offsets = this.selector.getWriters().entrySet().stream().collect(Collectors.toMap(e -> (Segment)e.getKey(), e -> ((SegmentOutputStream)e.getValue()).getLastObservedWriteOffset()));
        WriterPosition position = new WriterPosition(offsets);
        this.controller.noteTimestampFromWriter(this.writerId, this.stream, timestamp, position);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EventStreamWriterImpl(stream=" + this.stream + ", closed=" + this.closed + ")";
    }
}

