/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public class CheckpointConfig {
    private final Type type;
    private final CheckpointPeriod checkpointPeriod;

    CheckpointConfig(Type type, CheckpointPeriod checkpointPeriod) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkArgument((type == Type.None && checkpointPeriod == null || type == Type.Periodic && checkpointPeriod != null ? 1 : 0) != 0, (Object)"CheckpointPeriod should be non-null if Type is not None");
        this.type = type;
        this.checkpointPeriod = checkpointPeriod;
    }

    public static CheckpointConfig periodic(int numEvents, int numSeconds) {
        return new CheckpointConfig(Type.Periodic, new CheckpointPeriod(numEvents, numSeconds));
    }

    public static CheckpointConfig none() {
        return new CheckpointConfig(Type.None, null);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CheckpointConfigBuilder builder() {
        return new CheckpointConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Type getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckpointPeriod getCheckpointPeriod() {
        return this.checkpointPeriod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointConfig)) {
            return false;
        }
        CheckpointConfig other = (CheckpointConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        CheckpointPeriod this$checkpointPeriod = this.getCheckpointPeriod();
        CheckpointPeriod other$checkpointPeriod = other.getCheckpointPeriod();
        return !(this$checkpointPeriod == null ? other$checkpointPeriod != null : !((Object)this$checkpointPeriod).equals(other$checkpointPeriod));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CheckpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        CheckpointPeriod $checkpointPeriod = this.getCheckpointPeriod();
        result = result * 59 + ($checkpointPeriod == null ? 43 : ((Object)$checkpointPeriod).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CheckpointConfig(type=" + this.getType() + ", checkpointPeriod=" + this.getCheckpointPeriod() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class CheckpointConfigBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Type type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CheckpointPeriod checkpointPeriod;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CheckpointConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointConfigBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointConfigBuilder checkpointPeriod(CheckpointPeriod checkpointPeriod) {
            this.checkpointPeriod = checkpointPeriod;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointConfig build() {
            return new CheckpointConfig(this.type, this.checkpointPeriod);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CheckpointConfig.CheckpointConfigBuilder(type=" + this.type + ", checkpointPeriod=" + this.checkpointPeriod + ")";
        }
    }

    public static class CheckpointPeriod {
        private final int numEvents;
        private final int numSeconds;

        private CheckpointPeriod(int numEvents, int numSeconds) {
            Preconditions.checkArgument((numEvents > 0 ? 1 : 0) != 0, (Object)"numEvents should be positive integer");
            Preconditions.checkArgument((numSeconds > 0 ? 1 : 0) != 0, (Object)"numSeconds should be positive integer");
            this.numEvents = numEvents;
            this.numSeconds = numSeconds;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static CheckpointPeriodBuilder builder() {
            return new CheckpointPeriodBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getNumEvents() {
            return this.numEvents;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getNumSeconds() {
            return this.numSeconds;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckpointPeriod)) {
                return false;
            }
            CheckpointPeriod other = (CheckpointPeriod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNumEvents() != other.getNumEvents()) {
                return false;
            }
            return this.getNumSeconds() == other.getNumSeconds();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CheckpointPeriod;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNumEvents();
            result = result * 59 + this.getNumSeconds();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CheckpointConfig.CheckpointPeriod(numEvents=" + this.getNumEvents() + ", numSeconds=" + this.getNumSeconds() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class CheckpointPeriodBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private int numEvents;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private int numSeconds;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            CheckpointPeriodBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public CheckpointPeriodBuilder numEvents(int numEvents) {
                this.numEvents = numEvents;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public CheckpointPeriodBuilder numSeconds(int numSeconds) {
                this.numSeconds = numSeconds;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public CheckpointPeriod build() {
                return new CheckpointPeriod(this.numEvents, this.numSeconds);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "CheckpointConfig.CheckpointPeriod.CheckpointPeriodBuilder(numEvents=" + this.numEvents + ", numSeconds=" + this.numSeconds + ")";
            }
        }
    }

    public static enum Type {
        None,
        Periodic;

    }
}

