/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Serializer;
import io.pravega.controller.eventProcessor.EventProcessorGroupConfig;
import io.pravega.controller.eventProcessor.ExceptionHandler;
import io.pravega.controller.eventProcessor.impl.EventProcessor;
import io.pravega.shared.controller.event.ControllerEvent;
import java.util.function.Supplier;
import lombok.Generated;

public class EventProcessorConfig<T extends ControllerEvent> {
    private final EventProcessorGroupConfig config;
    private final ExceptionHandler exceptionHandler;
    private final Serializer<T> serializer;
    private final Supplier<EventProcessor<T>> supplier;
    private final long rebalancePeriodMillis;

    private EventProcessorConfig(EventProcessorGroupConfig config, ExceptionHandler exceptionHandler, Serializer<T> serializer, Supplier<EventProcessor<T>> supplier, long rebalancePeriodMillis) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull(serializer);
        Preconditions.checkNotNull(supplier);
        this.config = config;
        this.exceptionHandler = exceptionHandler == null ? ExceptionHandler.DEFAULT_EXCEPTION_HANDLER : exceptionHandler;
        this.serializer = serializer;
        this.supplier = supplier;
        this.rebalancePeriodMillis = rebalancePeriodMillis;
    }

    public static <T extends ControllerEvent> EventProcessorConfigBuilder<T> builder() {
        return new EventProcessorConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EventProcessorGroupConfig getConfig() {
        return this.config;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Serializer<T> getSerializer() {
        return this.serializer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<EventProcessor<T>> getSupplier() {
        return this.supplier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRebalancePeriodMillis() {
        return this.rebalancePeriodMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventProcessorConfig)) {
            return false;
        }
        EventProcessorConfig other = (EventProcessorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventProcessorGroupConfig this$config = this.getConfig();
        EventProcessorGroupConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        ExceptionHandler this$exceptionHandler = this.getExceptionHandler();
        ExceptionHandler other$exceptionHandler = other.getExceptionHandler();
        if (this$exceptionHandler == null ? other$exceptionHandler != null : !this$exceptionHandler.equals(other$exceptionHandler)) {
            return false;
        }
        Serializer<T> this$serializer = this.getSerializer();
        Serializer<T> other$serializer = other.getSerializer();
        if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
            return false;
        }
        Supplier<EventProcessor<T>> this$supplier = this.getSupplier();
        Supplier<EventProcessor<T>> other$supplier = other.getSupplier();
        if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
            return false;
        }
        return this.getRebalancePeriodMillis() == other.getRebalancePeriodMillis();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventProcessorConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventProcessorGroupConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        ExceptionHandler $exceptionHandler = this.getExceptionHandler();
        result = result * 59 + ($exceptionHandler == null ? 43 : $exceptionHandler.hashCode());
        Serializer<T> $serializer = this.getSerializer();
        result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
        Supplier<EventProcessor<T>> $supplier = this.getSupplier();
        result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
        long $rebalancePeriodMillis = this.getRebalancePeriodMillis();
        result = result * 59 + (int)($rebalancePeriodMillis >>> 32 ^ $rebalancePeriodMillis);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EventProcessorConfig(config=" + this.getConfig() + ", exceptionHandler=" + this.getExceptionHandler() + ", serializer=" + this.getSerializer() + ", supplier=" + this.getSupplier() + ", rebalancePeriodMillis=" + this.getRebalancePeriodMillis() + ")";
    }

    public static class EventProcessorConfigBuilder<T extends ControllerEvent> {
        private EventProcessorGroupConfig config;
        private ExceptionHandler exceptionHandler;
        private Serializer<T> serializer;
        private Supplier<EventProcessor<T>> supplier;
        private long rebalancePeriodMillis = Long.MIN_VALUE;

        EventProcessorConfigBuilder() {
        }

        public EventProcessorConfigBuilder<T> config(EventProcessorGroupConfig config) {
            this.config = config;
            return this;
        }

        public EventProcessorConfigBuilder<T> decider(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public EventProcessorConfigBuilder<T> serializer(Serializer<T> serializer) {
            this.serializer = serializer;
            return this;
        }

        public EventProcessorConfigBuilder<T> supplier(Supplier<EventProcessor<T>> supplier) {
            this.supplier = supplier;
            return this;
        }

        public EventProcessorConfigBuilder<T> minRebalanceIntervalMillis(long rebalancePeriodMillis) {
            this.rebalancePeriodMillis = rebalancePeriodMillis;
            return this;
        }

        public EventProcessorConfig<T> build() {
            return new EventProcessorConfig<T>(this.config, this.exceptionHandler, this.serializer, this.supplier, this.rebalancePeriodMillis);
        }

        public String toString() {
            return "Props.PropsBuilder(config=" + this.config + ", exceptionHandler=" + this.exceptionHandler + ", serializer=" + this.serializer + ", supplier=" + this.supplier + ", rebalancePeriodMillis=" + this.rebalancePeriodMillis + ")";
        }
    }
}

