/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Position;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.controller.eventProcessor.RequestHandler;
import io.pravega.controller.eventProcessor.impl.EventProcessor;
import io.pravega.controller.eventProcessor.impl.EventProcessorHelper;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.shared.controller.event.ControllerEvent;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentEventProcessor<R extends ControllerEvent, H extends RequestHandler<R>>
extends EventProcessor<R> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConcurrentEventProcessor.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final int MAX_CONCURRENT = 1000;
    private static final PositionCounter MAX = new PositionCounter(null, Long.MAX_VALUE);
    private final ConcurrentSkipListSet<PositionCounter> running;
    private final ConcurrentSkipListSet<PositionCounter> completed;
    private final AtomicReference<PositionCounter> checkpoint;
    private final ScheduledExecutorService executor;
    private final H requestHandler;
    private final AtomicLong counter = new AtomicLong(0L);
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final Comparator<PositionCounter> positionCounterComparator = Comparator.comparingLong(o -> o.counter);
    private final Semaphore semaphore;
    private final ScheduledFuture<?> periodicCheckpoint;
    private final EventProcessor.Checkpointer checkpointer;
    private final EventProcessor.Writer<R> internalWriter;
    private final Phaser phaser;

    public ConcurrentEventProcessor(H requestHandler, ScheduledExecutorService executor) {
        this(requestHandler, 1000, executor, null, null, 1L, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    ConcurrentEventProcessor(H requestHandler, int maxConcurrent, ScheduledExecutorService executor, EventProcessor.Checkpointer checkpointer, EventProcessor.Writer<R> writer, long checkpointPeriod, TimeUnit timeUnit) {
        Preconditions.checkNotNull(requestHandler);
        Preconditions.checkNotNull((Object)executor);
        this.requestHandler = requestHandler;
        this.running = new ConcurrentSkipListSet<PositionCounter>(this.positionCounterComparator);
        this.completed = new ConcurrentSkipListSet<PositionCounter>(this.positionCounterComparator);
        this.checkpointer = checkpointer;
        this.checkpoint = new AtomicReference();
        this.internalWriter = writer;
        this.executor = executor;
        this.periodicCheckpoint = this.executor.scheduleAtFixedRate(this::periodicCheckpoint, 0L, checkpointPeriod, timeUnit);
        this.semaphore = new Semaphore(maxConcurrent);
        this.phaser = new Phaser(1);
    }

    @Override
    protected void process(R request, Position position) {
        if (!this.stop.get()) {
            this.semaphore.acquireUninterruptibly();
            this.phaser.register();
            long next = this.counter.incrementAndGet();
            PositionCounter pc = new PositionCounter(position, next);
            this.running.add(pc);
            EventProcessorHelper.withRetries(() -> this.requestHandler.process((ControllerEvent)request, this.stop::get), this.executor).whenCompleteAsync((r, e) -> {
                CompletableFuture<Object> future;
                if (e != null) {
                    log.warn("ConcurrentEventProcessor Processing failed {}", (Object)e.getClass().getName());
                    future = this.handleProcessingError(request, (Throwable)e);
                } else {
                    log.debug("ConcurrentEventProcessor Processing complete");
                    future = CompletableFuture.completedFuture(null);
                }
                future.whenCompleteAsync((res, ex) -> {
                    if (!this.stop.get() || ex == null || !(Exceptions.unwrap((Throwable)ex) instanceof CancellationException)) {
                        this.checkpoint(pc);
                    }
                    this.phaser.arriveAndDeregister();
                    this.semaphore.release();
                }, (Executor)this.executor);
            }, (Executor)this.executor);
        } else {
            log.warn("processing requested after processor is stopped.");
        }
    }

    private CompletableFuture<Void> handleProcessingError(R request, Throwable e) {
        CompletableFuture future;
        Throwable cause = Exceptions.unwrap((Throwable)e);
        if (cause instanceof RetriesExhaustedException) {
            cause = cause.getCause();
        }
        if (RetryableException.isRetryable(cause)) {
            log.warn("ConcurrentEventProcessor Processing failed, Retryable Exception {}. Putting the event back.", (Object)cause.getClass().getName());
            EventProcessor.Writer<Object> writer = this.internalWriter != null ? this.internalWriter : (this.getSelfWriter() != null ? this.getSelfWriter() : null);
            future = EventProcessorHelper.indefiniteRetries(() -> EventProcessorHelper.writeBack(request, writer), this.executor);
        } else {
            Throwable actual = Exceptions.unwrap((Throwable)e);
            log.warn("ConcurrentEventProcessor Processing failed, {} {}", actual.getClass(), (Object)actual.getMessage());
            future = Futures.failedFuture((Throwable)actual);
        }
        return future;
    }

    @Override
    protected void afterStop() {
        this.stop.set(true);
        this.phaser.arriveAndAwaitAdvance();
        this.phaser.arriveAndDeregister();
        this.periodicCheckpoint.cancel(true);
    }

    @VisibleForTesting
    boolean isStopFlagSet() {
        return this.stop.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpoint(PositionCounter pc) {
        Object object = this.$lock;
        synchronized (object) {
            this.running.remove(pc);
            this.completed.add(pc);
            PositionCounter smallest = this.running.isEmpty() ? MAX : this.running.first();
            List checkpointCandidates = this.completed.stream().filter(x -> this.positionCounterComparator.compare((PositionCounter)x, smallest) < 0).collect(Collectors.toList());
            if (checkpointCandidates.size() > 0) {
                PositionCounter checkpointPosition = (PositionCounter)checkpointCandidates.get(checkpointCandidates.size() - 1);
                this.completed.removeAll(checkpointCandidates);
                this.checkpoint.set(checkpointPosition);
            }
        }
    }

    @VisibleForTesting
    void periodicCheckpoint() {
        try {
            if (this.checkpoint.get() != null && this.checkpoint.get().position != null) {
                if (this.checkpointer != null) {
                    this.checkpointer.store(this.checkpoint.get().position);
                } else if (this.getCheckpointer() != null) {
                    this.getCheckpointer().store(this.checkpoint.get().position);
                }
            }
        }
        catch (Exception e) {
            log.warn("error while trying to store checkpoint in the store {}", (Throwable)e);
        }
    }

    private static class PositionCounter {
        private final Position position;
        private final long counter;

        @ConstructorProperties(value={"position", "counter"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PositionCounter(Position position, long counter) {
            this.position = position;
            this.counter = counter;
        }
    }
}

