/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.EventRead;
import io.pravega.client.stream.EventStreamReader;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.Position;
import io.pravega.common.LoggerHelpers;
import io.pravega.controller.eventProcessor.CheckpointConfig;
import io.pravega.controller.eventProcessor.EventProcessorConfig;
import io.pravega.controller.eventProcessor.EventProcessorInitException;
import io.pravega.controller.eventProcessor.EventProcessorReinitException;
import io.pravega.controller.eventProcessor.ExceptionHandler;
import io.pravega.controller.eventProcessor.impl.EventProcessor;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import io.pravega.shared.controller.event.ControllerEvent;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventProcessorCell<T extends ControllerEvent> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProcessorCell.class);
    private final EventStreamReader<T> reader;
    private final EventStreamWriter<T> selfWriter;
    private final CheckpointStore checkpointStore;
    private final String process;
    private final String readerGroupName;
    private final String readerId;
    private final String objectId;
    private final AtomicReference<Position> lastCheckpoint;
    @VisibleForTesting
    private EventProcessor<T> actor;
    private final Service delegate;

    EventProcessorCell(EventProcessorConfig<T> eventProcessorConfig, EventStreamReader<T> reader, EventStreamWriter<T> selfWriter, String process, String readerId, int index, CheckpointStore checkpointStore) {
        Preconditions.checkNotNull(eventProcessorConfig);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)process) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)readerId) ? 1 : 0) != 0);
        this.reader = (EventStreamReader)Preconditions.checkNotNull(reader);
        this.selfWriter = (EventStreamWriter)Preconditions.checkNotNull(selfWriter);
        this.checkpointStore = (CheckpointStore)Preconditions.checkNotNull((Object)checkpointStore);
        this.process = process;
        this.readerGroupName = eventProcessorConfig.getConfig().getReaderGroupName();
        this.readerId = readerId;
        this.objectId = String.format("EventProcessor[%s:%d:%s]", this.readerGroupName, index, readerId);
        this.actor = this.createEventProcessor(eventProcessorConfig);
        this.delegate = new Delegate(eventProcessorConfig);
        this.lastCheckpoint = new AtomicReference();
    }

    final void startAsync() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startAsync", (Object[])new Object[0]);
        try {
            this.delegate.startAsync();
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startAsync", (long)traceId, (Object[])new Object[0]);
        }
    }

    final void stopAsync() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"stopAsync", (Object[])new Object[0]);
        try {
            this.delegate.stopAsync();
            log.info("Event processor cell {} SHUTDOWN issued", (Object)this.objectId);
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"stopAsync", (long)traceId, (Object[])new Object[0]);
        }
    }

    final void awaitStartupComplete() {
        block2: {
            try {
                this.delegate.awaitRunning();
            }
            catch (IllegalStateException e) {
                Service.State state = this.delegate.state();
                if (state == Service.State.STOPPING || state == Service.State.TERMINATED) break block2;
                throw e;
            }
        }
    }

    final void awaitTerminated() {
        this.delegate.awaitTerminated();
        log.info("Event processor cell {} Terminated", (Object)this.objectId);
    }

    private EventProcessor<T> createEventProcessor(EventProcessorConfig<T> eventProcessorConfig) {
        EventProcessor<T> eventProcessor = eventProcessorConfig.getSupplier().get();
        eventProcessor.checkpointer = position -> {
            this.checkpointStore.setPosition(this.process, this.readerGroupName, this.readerId, position);
            this.lastCheckpoint.set(position);
        };
        eventProcessor.selfWriter = arg_0 -> this.selfWriter.writeEvent(arg_0);
        return eventProcessor;
    }

    Position getCheckpoint() {
        return this.lastCheckpoint.get();
    }

    public String toString() {
        return String.format("%s[%s]", this.objectId, this.delegate.state());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    String getProcess() {
        return this.process;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    String getReaderId() {
        return this.readerId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    EventProcessor<T> getActor() {
        return this.actor;
    }

    @NotThreadSafe
    private class CheckpointState {
        private final boolean enableCheckpoint;
        private final CheckpointConfig.CheckpointPeriod checkpointPeriod;
        private int count;
        private int previousCheckpointIndex;
        private long previousCheckpointTimestamp;

        CheckpointState(CheckpointConfig checkpointConfig) {
            if (checkpointConfig.getType() == CheckpointConfig.Type.Periodic) {
                this.enableCheckpoint = true;
                this.checkpointPeriod = checkpointConfig.getCheckpointPeriod();
            } else {
                this.enableCheckpoint = false;
                this.checkpointPeriod = null;
            }
            this.count = 0;
            this.previousCheckpointIndex = 0;
            this.previousCheckpointTimestamp = System.currentTimeMillis();
        }

        void store(Position position) {
            if (!this.enableCheckpoint) {
                return;
            }
            ++this.count;
            long timestamp = System.currentTimeMillis();
            int countInterval = this.count - this.previousCheckpointIndex;
            long timeInterval = timestamp - this.previousCheckpointTimestamp;
            if (countInterval >= this.checkpointPeriod.getNumEvents() || timeInterval >= (long)(1000 * this.checkpointPeriod.getNumSeconds())) {
                try {
                    EventProcessorCell.this.actor.getCheckpointer().store(position);
                    this.previousCheckpointIndex = this.count;
                    this.previousCheckpointTimestamp = timestamp;
                }
                catch (CheckpointStoreException cse) {
                    log.warn(String.format("Failed persisting checkpoint for event processor %s", EventProcessorCell.this.objectId), cse.getCause());
                }
            }
        }
    }

    private class Delegate
    extends AbstractExecutionThreadService {
        private final long defaultTimeout = 2000L;
        private final EventProcessorConfig<T> eventProcessorConfig;
        private EventRead<T> event;
        private final CheckpointState state;

        Delegate(EventProcessorConfig<T> eventProcessorConfig) {
            this.eventProcessorConfig = eventProcessorConfig;
            this.state = new CheckpointState(eventProcessorConfig.getConfig().getCheckpointConfig());
        }

        protected final void startUp() {
            log.info("Event processor STARTUP {}, state={}", (Object)EventProcessorCell.this.objectId, (Object)this.state());
            try {
                EventProcessorCell.this.actor.beforeStart();
            }
            catch (Exception e) {
                log.warn(String.format("Failed while executing preStart for event processor %s", EventProcessorCell.this.objectId), (Throwable)e);
                this.handleException(new EventProcessorInitException(e));
            }
        }

        protected final void run() throws Exception {
            log.debug("Event processor RUN {}, state={}", (Object)EventProcessorCell.this.objectId, (Object)this.state());
            while (this.isRunning()) {
                try {
                    this.event = EventProcessorCell.this.reader.readNextEvent(2000L);
                    if (this.event == null || this.event.getEvent() == null) continue;
                    EventProcessorCell.this.actor.process((ControllerEvent)this.event.getEvent(), this.event.getPosition());
                    this.state.store(this.event.getPosition());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        protected final void shutDown() throws Exception {
            log.info("Event processor SHUTDOWN {}, state={}", (Object)EventProcessorCell.this.objectId, (Object)this.state());
            try {
                EventProcessorCell.this.actor.afterStop();
            }
            catch (Exception e) {
                log.warn(String.format("Failed while executing afterStop for event processor %s", EventProcessorCell.this.objectId), (Throwable)e);
                throw e;
            }
            finally {
                log.info("Closing reader for {}", (Object)EventProcessorCell.this.objectId);
                try {
                    EventProcessorCell.this.reader.closeAt(EventProcessorCell.this.getCheckpoint());
                }
                catch (Exception e) {
                    log.info("Exception while closing EventProcessorCell reader from checkpointStore: {}.", (Object)e.getMessage());
                }
            }
        }

        private void restart(Throwable error, T event) {
            log.debug("Event processor RESTART {}, state={}", (Object)EventProcessorCell.this.objectId, (Object)this.state());
            try {
                EventProcessorCell.this.actor.beforeRestart(error, event);
                EventProcessorCell.this.actor = EventProcessorCell.this.createEventProcessor(this.eventProcessorConfig);
                this.startUp();
            }
            catch (Exception e) {
                log.warn(String.format("Failed while executing preRestart for event processor %s", EventProcessorCell.this.objectId), (Throwable)e);
                this.handleException(new EventProcessorReinitException(e));
            }
        }

        private void handleException(Exception e) {
            ExceptionHandler.Directive directive = this.eventProcessorConfig.getExceptionHandler().run(e);
            switch (directive) {
                case Restart: {
                    log.warn("Restarting event processor: {} due to exception: {}", (Object)EventProcessorCell.this.objectId, (Object)e);
                    this.restart(e, this.event == null ? null : (ControllerEvent)this.event.getEvent());
                    break;
                }
                case Resume: {
                    log.debug("Resuming event processor: {} after receiving exception: {}", (Object)EventProcessorCell.this.objectId, (Object)e);
                    break;
                }
                case Stop: {
                    log.warn("Stopping event processor: {} due to exception: {}", (Object)EventProcessorCell.this.objectId, (Object)e);
                    this.stopAsync();
                }
            }
        }
    }
}

