/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.eventProcessor.CheckpointConfig;
import io.pravega.controller.eventProcessor.EventProcessorGroupConfig;
import lombok.Generated;

public class EventProcessorGroupConfigImpl
implements EventProcessorGroupConfig {
    private final String streamName;
    private final String readerGroupName;
    private final int eventProcessorCount;
    private final CheckpointConfig checkpointConfig;

    private EventProcessorGroupConfigImpl(String streamName, String readerGroupName, int eventProcessorCount, CheckpointConfig checkpointConfig) {
        Preconditions.checkNotNull((Object)streamName);
        Preconditions.checkNotNull((Object)readerGroupName);
        Preconditions.checkArgument((!readerGroupName.contains("/") ? 1 : 0) != 0, (Object)"Invalid readerGroupName, '/' not allowed");
        Preconditions.checkArgument((eventProcessorCount > 0 ? 1 : 0) != 0, (Object)"Event processor count should be positive integer");
        Preconditions.checkNotNull((Object)checkpointConfig);
        this.streamName = streamName;
        this.readerGroupName = readerGroupName;
        this.eventProcessorCount = eventProcessorCount;
        this.checkpointConfig = checkpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EventProcessorGroupConfigImplBuilder builder() {
        return new EventProcessorGroupConfigImplBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getReaderGroupName() {
        return this.readerGroupName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEventProcessorCount() {
        return this.eventProcessorCount;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventProcessorGroupConfigImpl)) {
            return false;
        }
        EventProcessorGroupConfigImpl other = (EventProcessorGroupConfigImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        String this$readerGroupName = this.getReaderGroupName();
        String other$readerGroupName = other.getReaderGroupName();
        if (this$readerGroupName == null ? other$readerGroupName != null : !this$readerGroupName.equals(other$readerGroupName)) {
            return false;
        }
        if (this.getEventProcessorCount() != other.getEventProcessorCount()) {
            return false;
        }
        CheckpointConfig this$checkpointConfig = this.getCheckpointConfig();
        CheckpointConfig other$checkpointConfig = other.getCheckpointConfig();
        return !(this$checkpointConfig == null ? other$checkpointConfig != null : !((Object)this$checkpointConfig).equals(other$checkpointConfig));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventProcessorGroupConfigImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        String $readerGroupName = this.getReaderGroupName();
        result = result * 59 + ($readerGroupName == null ? 43 : $readerGroupName.hashCode());
        result = result * 59 + this.getEventProcessorCount();
        CheckpointConfig $checkpointConfig = this.getCheckpointConfig();
        result = result * 59 + ($checkpointConfig == null ? 43 : ((Object)$checkpointConfig).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EventProcessorGroupConfigImpl(streamName=" + this.getStreamName() + ", readerGroupName=" + this.getReaderGroupName() + ", eventProcessorCount=" + this.getEventProcessorCount() + ", checkpointConfig=" + this.getCheckpointConfig() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class EventProcessorGroupConfigImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String streamName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String readerGroupName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int eventProcessorCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CheckpointConfig checkpointConfig;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EventProcessorGroupConfigImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventProcessorGroupConfigImplBuilder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventProcessorGroupConfigImplBuilder readerGroupName(String readerGroupName) {
            this.readerGroupName = readerGroupName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventProcessorGroupConfigImplBuilder eventProcessorCount(int eventProcessorCount) {
            this.eventProcessorCount = eventProcessorCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventProcessorGroupConfigImplBuilder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventProcessorGroupConfigImpl build() {
            return new EventProcessorGroupConfigImpl(this.streamName, this.readerGroupName, this.eventProcessorCount, this.checkpointConfig);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EventProcessorGroupConfigImpl.EventProcessorGroupConfigImplBuilder(streamName=" + this.streamName + ", readerGroupName=" + this.readerGroupName + ", eventProcessorCount=" + this.eventProcessorCount + ", checkpointConfig=" + this.checkpointConfig + ")";
        }
    }
}

