/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.stream.EventStreamReader;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.ReaderConfig;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.ReaderSegmentDistribution;
import io.pravega.client.stream.Stream;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.controller.eventProcessor.EventProcessorConfig;
import io.pravega.controller.eventProcessor.EventProcessorGroup;
import io.pravega.controller.eventProcessor.impl.EventProcessorCell;
import io.pravega.controller.eventProcessor.impl.EventProcessorSystemImpl;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import io.pravega.shared.controller.event.ControllerEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventProcessorGroupImpl<T extends ControllerEvent>
extends AbstractIdleService
implements EventProcessorGroup<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProcessorGroupImpl.class);
    private final String objectId;
    private final EventProcessorSystemImpl actorSystem;
    private final EventProcessorConfig<T> eventProcessorConfig;
    @VisibleForTesting
    private final ConcurrentHashMap<String, EventProcessorCell<T>> eventProcessorMap;
    private final EventStreamWriter<T> writer;
    private ReaderGroup readerGroup;
    private final CheckpointStore checkpointStore;
    private final ScheduledExecutorService rebalanceExecutor;
    private ScheduledFuture<?> rebalanceFuture;
    private final long rebalancePeriodMillis;
    private final Object lock = new Object();

    EventProcessorGroupImpl(EventProcessorSystemImpl actorSystem, EventProcessorConfig<T> eventProcessorConfig, CheckpointStore checkpointStore) {
        this(actorSystem, eventProcessorConfig, checkpointStore, null);
    }

    EventProcessorGroupImpl(EventProcessorSystemImpl actorSystem, EventProcessorConfig<T> eventProcessorConfig, CheckpointStore checkpointStore, ScheduledExecutorService rebalanceExecutor) {
        this.objectId = String.format("EventProcessorGroup[%s]", eventProcessorConfig.getConfig().getReaderGroupName());
        this.actorSystem = actorSystem;
        this.eventProcessorConfig = eventProcessorConfig;
        this.rebalanceExecutor = rebalanceExecutor;
        this.eventProcessorMap = new ConcurrentHashMap();
        this.writer = actorSystem.clientFactory.createEventWriter(eventProcessorConfig.getConfig().getStreamName(), eventProcessorConfig.getSerializer(), EventWriterConfig.builder().enableConnectionPooling(true).retryAttempts(Integer.MAX_VALUE).build());
        this.checkpointStore = checkpointStore;
        this.rebalancePeriodMillis = eventProcessorConfig.getRebalancePeriodMillis();
    }

    void initialize() throws CheckpointStoreException {
        try {
            this.checkpointStore.addReaderGroup(this.actorSystem.getProcess(), this.eventProcessorConfig.getConfig().getReaderGroupName());
        }
        catch (CheckpointStoreException e) {
            if (!e.getType().equals((Object)CheckpointStoreException.Type.NodeExists)) {
                throw e;
            }
            log.debug("reader group {} exists", (Object)this.eventProcessorConfig.getConfig().getReaderGroupName());
        }
        this.readerGroup = this.createIfNotExists(this.actorSystem.readerGroupManager, this.eventProcessorConfig.getConfig().getReaderGroupName(), ReaderGroupConfig.builder().disableAutomaticCheckpoints().stream(Stream.of((String)this.actorSystem.getScope(), (String)this.eventProcessorConfig.getConfig().getStreamName())).build());
        this.createEventProcessors(this.eventProcessorConfig.getConfig().getEventProcessorCount() - this.eventProcessorMap.values().size());
    }

    private ReaderGroup createIfNotExists(ReaderGroupManager readerGroupManager, String groupName, ReaderGroupConfig groupConfig) {
        readerGroupManager.createReaderGroup(groupName, groupConfig);
        return readerGroupManager.getReaderGroup(groupName);
    }

    private List<String> createEventProcessors(int count) throws CheckpointStoreException {
        ArrayList<String> readerIds = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String readerId = UUID.randomUUID().toString();
            this.checkpointStore.addReader(this.actorSystem.getProcess(), this.eventProcessorConfig.getConfig().getReaderGroupName(), readerId);
            EventStreamReader reader = this.actorSystem.clientFactory.createReader(readerId, this.eventProcessorConfig.getConfig().getReaderGroupName(), this.eventProcessorConfig.getSerializer(), ReaderConfig.builder().disableTimeWindows(true).build());
            EventProcessorCell<T> actorCell = new EventProcessorCell<T>(this.eventProcessorConfig, reader, this.writer, this.actorSystem.getProcess(), readerId, i, this.checkpointStore);
            log.info("Created event processor {}, id={}", (Object)i, (Object)actorCell.toString());
            this.eventProcessorMap.put(readerId, actorCell);
            readerIds.add(readerId);
            try {
                this.checkpointStore.addReader(this.actorSystem.getProcess(), this.eventProcessorConfig.getConfig().getReaderGroupName(), readerId);
                continue;
            }
            catch (CheckpointStoreException ex) {
                if (ex.getType().equals((Object)CheckpointStoreException.Type.NodeExists)) continue;
                throw ex;
            }
        }
        return readerIds;
    }

    protected void startUp() {
        long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"startUp", (Object[])new Object[0]);
        try {
            log.info("Attempting to start all event processors in {}", (Object)this.toString());
            this.eventProcessorMap.entrySet().forEach(entry -> ((EventProcessorCell)entry.getValue()).startAsync());
            this.eventProcessorMap.entrySet().forEach(entry -> ((EventProcessorCell)entry.getValue()).awaitStartupComplete());
            log.info("All event processors in {} started successfully.", (Object)this.toString());
            this.rebalanceFuture = this.rebalancePeriodMillis > 0L && this.rebalanceExecutor != null ? this.rebalanceExecutor.scheduleWithFixedDelay(this::rebalance, this.rebalancePeriodMillis, this.rebalancePeriodMillis, TimeUnit.MILLISECONDS) : null;
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() {
        log.info("Shutting down all event processors in {}", (Object)this.toString());
        Object object = this.lock;
        synchronized (object) {
            long traceId = LoggerHelpers.traceEnterWithContext((Logger)log, (String)this.objectId, (String)"shutDown", (Object[])new Object[0]);
            try {
                this.cleanUpCheckpointStore();
                this.readerGroup.close();
                if (this.rebalanceFuture != null) {
                    this.rebalanceFuture.cancel(true);
                }
                this.writer.close();
            }
            finally {
                LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
            }
        }
        log.info("Shut down all event processors in {} complete.", (Object)this.toString());
    }

    private void cleanUpCheckpointStore() {
        for (EventProcessorCell<T> cell : this.eventProcessorMap.values()) {
            log.info("Terminating event processor cell: {}", cell);
            cell.stopAsync();
        }
        for (EventProcessorCell<T> cell : this.eventProcessorMap.values()) {
            try {
                cell.awaitTerminated();
                log.debug("Termination of event processor cell: {} completed successfully.", cell);
            }
            catch (Exception e) {
                log.warn("Failed terminating event processor cell {}.", cell, (Object)e);
            }
        }
        try {
            log.debug("Attempting to clean up reader group {} entry from checkpoint store", (Object)this.objectId);
            this.checkpointStore.removeProcessFromGroup(this.actorSystem.getProcess(), this.readerGroup.getGroupName());
        }
        catch (CheckpointStoreException e) {
            log.warn("Error removing reader group " + this.objectId, (Throwable)e);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void notifyProcessFailure(String process) throws CheckpointStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeEventProcessorCount(int count) throws CheckpointStoreException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.isRunning(), (Object)this.state().name());
            if (count <= 0) {
                throw new NotImplementedException("Decrease processor count");
            }
            List<String> readerIds = this.createEventProcessors(count);
            readerIds.stream().forEach(readerId -> this.eventProcessorMap.get(readerId).startAsync());
        }
    }

    @Override
    public EventStreamWriter<T> getWriter() {
        return this.writer;
    }

    @Override
    public Set<String> getProcesses() throws CheckpointStoreException {
        return this.checkpointStore.getProcesses();
    }

    @VisibleForTesting
    void rebalance() {
        try {
            ReaderSegmentDistribution readerSegmentDistribution = this.readerGroup.getReaderSegmentDistribution();
            Map distribution = readerSegmentDistribution.getReaderSegmentDistribution();
            int readerCount = distribution.size();
            int unassigned = readerSegmentDistribution.getUnassignedSegments();
            int segmentCount = distribution.values().stream().reduce(0, Integer::sum) + unassigned;
            boolean idleReaders = distribution.entrySet().stream().anyMatch(x -> !Strings.isNullOrEmpty((String)((String)x.getKey())) && (Integer)x.getValue() == 0);
            if (idleReaders) {
                distribution.forEach((readerId, assigned) -> {
                    if (!Strings.isNullOrEmpty((String)readerId) && this.eventProcessorMap.containsKey(readerId) && this.isRebalanceCandidate((int)assigned, readerCount, segmentCount)) {
                        this.replaceCell((String)readerId);
                    }
                });
            }
        }
        catch (Exception e) {
            Throwable realException = Exceptions.unwrap((Throwable)e);
            log.warn("Re-balance failed with exception {} {}", (Object)realException.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private boolean isRebalanceCandidate(int assigned, int readerCount, int segmentCount) {
        double fair = (double)segmentCount / (double)readerCount;
        return (double)assigned >= fair + 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceCell(String readerId) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.isRunning(), (Object)this.state().name());
            log.info("Found overloaded reader: {}", (Object)readerId);
            try {
                List<String> newReaders = this.createEventProcessors(1);
                assert (newReaders.size() == 1);
                String newReaderId = newReaders.get(0);
                this.eventProcessorMap.get(newReaderId).startAsync();
            }
            catch (CheckpointStoreException e) {
                log.warn("Unable to create a new event processor cell", (Object)e.getMessage());
                return;
            }
            EventProcessorCell<T> cell = this.eventProcessorMap.get(readerId);
            log.info("Stopping event processor cell: {}", cell);
            try {
                cell.stopAsync();
                cell.awaitTerminated();
                this.checkpointStore.removeReader(cell.getProcess(), this.readerGroup.getGroupName(), readerId);
                this.eventProcessorMap.remove(readerId);
                log.info("Termination of event processor cell: {} completed successfully.", cell);
            }
            catch (Exception e) {
                log.warn("Failed terminating event processor cell {}.", cell, (Object)e);
            }
        }
    }

    @Override
    public void close() {
        this.stopAsync();
        this.writer.close();
    }

    public String toString() {
        return this.objectId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ConcurrentHashMap<String, EventProcessorCell<T>> getEventProcessorMap() {
        return this.eventProcessorMap;
    }
}

