/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.eventProcessor.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.controller.eventProcessor.EventProcessorConfig;
import io.pravega.controller.eventProcessor.EventProcessorGroup;
import io.pravega.controller.eventProcessor.EventProcessorSystem;
import io.pravega.controller.eventProcessor.impl.EventProcessorGroupImpl;
import io.pravega.controller.store.checkpoint.CheckpointStore;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import io.pravega.shared.controller.event.ControllerEvent;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorSystemImpl
implements EventProcessorSystem {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProcessorSystemImpl.class);
    final EventStreamClientFactory clientFactory;
    final ReaderGroupManager readerGroupManager;
    private final String name;
    private final String process;
    private final String scope;

    public EventProcessorSystemImpl(String name, String process, String scope, EventStreamClientFactory clientFactory, ReaderGroupManager readerGroupManager) {
        this.name = name;
        this.process = process;
        this.scope = scope;
        this.clientFactory = clientFactory;
        this.readerGroupManager = readerGroupManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    @Override
    public <T extends ControllerEvent> EventProcessorGroup<T> createEventProcessorGroup(EventProcessorConfig<T> eventProcessorConfig, CheckpointStore checkpointStore, ScheduledExecutorService rebalanceExecutor) throws CheckpointStoreException {
        Preconditions.checkNotNull(eventProcessorConfig, (Object)"eventProcessorConfig");
        Preconditions.checkNotNull((Object)checkpointStore, (Object)"checkpointStore");
        EventProcessorGroupImpl<T> actorGroup = new EventProcessorGroupImpl<T>(this, eventProcessorConfig, checkpointStore, rebalanceExecutor);
        try {
            actorGroup.initialize();
            actorGroup.startAsync();
        }
        catch (Throwable ex) {
            actorGroup.close();
            throw ex;
        }
        return actorGroup;
    }
}

