/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.fault;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.cluster.Cluster;
import io.pravega.common.cluster.ClusterException;
import io.pravega.common.cluster.Host;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.fault.FailoverSweeper;
import io.pravega.controller.util.RetryHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerClusterListener
extends AbstractIdleService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerClusterListener.class);
    private final String objectId;
    private final Host host;
    private final Cluster cluster;
    private final ScheduledExecutorService executor;
    private final List<FailoverSweeper> sweepers;

    public ControllerClusterListener(Host host, Cluster cluster, ScheduledExecutorService executor, List<FailoverSweeper> sweepers) {
        Preconditions.checkNotNull((Object)host, (Object)"host");
        Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Preconditions.checkArgument((boolean)sweepers.stream().noneMatch(Objects::isNull));
        this.objectId = "ControllerClusterListener";
        this.host = host;
        this.cluster = cluster;
        this.executor = executor;
        this.sweepers = Lists.newArrayList(sweepers);
    }

    public boolean isMetadataServiceConnected() {
        return this.cluster.isHealthy();
    }

    public boolean areAllSweepersReady() {
        return this.sweepers.stream().allMatch(s -> s.isReady());
    }

    public boolean isReady() {
        return this.isMetadataServiceConnected() && this.areAllSweepersReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() throws InterruptedException {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)this.objectId, (Object[])new Object[]{"startUp"});
        try {
            log.info("Registering host {} with controller cluster", (Object)this.host);
            this.cluster.registerHost(this.host);
            log.info("Adding controller cluster listener");
            this.cluster.addListener((type, host) -> {
                switch (type) {
                    case HOST_ADDED: {
                        log.info("Received HOST_ADDED cluster event: {} for host: {}", (Object)type, (Object)host);
                        break;
                    }
                    case HOST_REMOVED: {
                        log.info("Received HOST_REMOVED cluster event: {} for host: {}", (Object)type, (Object)host);
                        this.handleHostRemoved(host);
                        break;
                    }
                    case ERROR: {
                        log.info("Received error event from controller host {}", (Object)host);
                    }
                }
            }, (Executor)this.executor);
            Supplier<Set<String>> processes = () -> {
                try {
                    return this.cluster.getClusterMembers().stream().map(Host::getHostId).collect(Collectors.toSet());
                }
                catch (ClusterException e) {
                    log.error("Error fetching cluster members {}", (Object)e.getMessage());
                    throw new CompletionException(e);
                }
            };
            this.sweepAll(processes);
            log.info("Controller cluster listener startUp complete");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"startUp", (long)traceId, (Object[])new Object[0]);
        }
    }

    private CompletableFuture<Void> handleHostRemoved(Host host) {
        return Futures.allOf((Collection)this.sweepers.stream().map(sweeper -> {
            if (sweeper.isReady()) {
                return RetryHelper.withIndefiniteRetriesAsync(() -> sweeper.handleFailedProcess(host.getHostId()), e -> log.warn(e.getMessage()), this.executor);
            }
            return CompletableFuture.completedFuture(null);
        }).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> sweepAll(Supplier<Set<String>> processes) {
        return Futures.allOf((Collection)this.sweepers.stream().map(sweeper -> RetryHelper.withIndefiniteRetriesAsync(() -> ControllerClusterListener.lambda$sweepAll$6(sweeper, (Supplier)processes), e -> log.warn(e.getMessage()), this.executor)).collect(Collectors.toList()));
    }

    protected void shutDown() throws Exception {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)this.objectId, (Object[])new Object[]{"shutDown"});
        try {
            log.info("De-registering host {} from controller cluster", (Object)this.host);
            this.cluster.deregisterHost(this.host);
            log.info("Controller cluster listener shutDown complete");
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)this.objectId, (String)"shutDown", (long)traceId, (Object[])new Object[0]);
        }
    }

    private static /* synthetic */ CompletableFuture lambda$sweepAll$6(FailoverSweeper sweeper, Supplier processes) {
        if (!sweeper.isReady()) {
            throw new RuntimeException(String.format("sweeper %s not ready, retrying with exponential backoff.", sweeper.getClass()));
        }
        return sweeper.sweepFailedProcesses(processes);
    }
}

