/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.fault;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.fault.ContainerBalancer;
import io.pravega.controller.fault.SegmentMonitorLeader;
import io.pravega.controller.store.host.HostControllerStore;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentContainerMonitor
extends AbstractIdleService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentContainerMonitor.class);
    private final SegmentMonitorLeader segmentMonitorLeader;
    private final LeaderSelector leaderSelector;
    private final String leaderZKPath;
    private final AtomicBoolean zkConnected = new AtomicBoolean(false);

    public SegmentContainerMonitor(HostControllerStore hostStore, CuratorFramework client, ContainerBalancer balancer, int minRebalanceInterval) {
        Preconditions.checkNotNull((Object)hostStore, (Object)"hostStore");
        Preconditions.checkNotNull((Object)client, (Object)"client");
        Preconditions.checkNotNull((Object)balancer, (Object)"balancer");
        this.leaderZKPath = ZKPaths.makePath((String)"cluster", (String)"faulthandlerleader");
        this.segmentMonitorLeader = new SegmentMonitorLeader(hostStore, balancer, minRebalanceInterval);
        this.leaderSelector = new LeaderSelector(client, this.leaderZKPath, (LeaderSelectorListener)this.segmentMonitorLeader);
        this.zkConnected.set(client.getZookeeperClient().isConnected());
        client.getConnectionStateListenable().addListener((curatorClient, newState) -> {
            this.zkConnected.set(newState.isConnected());
            switch (newState) {
                case LOST: {
                    log.warn("Connection to zookeeper lost, attempting to interrrupt the leader thread");
                    this.leaderSelector.interruptLeadership();
                    break;
                }
                case SUSPENDED: {
                    if (!this.leaderSelector.hasLeadership()) break;
                    log.info("Zookeeper session suspended, pausing the segment monitor");
                    this.segmentMonitorLeader.suspend();
                    break;
                }
                case RECONNECTED: {
                    if (!this.leaderSelector.hasLeadership()) break;
                    log.info("Zookeeper session reconnected, resume the segment monitor");
                    this.segmentMonitorLeader.resume();
                    break;
                }
                default: {
                    log.debug("Connection state to zookeeper updated: " + newState.toString());
                }
            }
        });
    }

    public boolean isZKConnected() {
        return this.zkConnected.get();
    }

    protected void startUp() {
        this.leaderSelector.autoRequeue();
        this.leaderSelector.start();
    }

    protected void shutDown() {
        this.leaderSelector.interruptLeadership();
        this.leaderSelector.close();
    }
}

