/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.fault;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.cluster.Cluster;
import io.pravega.common.cluster.ClusterException;
import io.pravega.common.cluster.Host;
import io.pravega.common.cluster.zkImpl.ClusterZKImpl;
import io.pravega.controller.fault.ContainerBalancer;
import io.pravega.controller.metrics.HostContainerMetrics;
import io.pravega.controller.store.host.HostControllerStore;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentMonitorLeader
implements LeaderSelectorListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentMonitorLeader.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private final HostControllerStore hostStore;
    private final ContainerBalancer segBalancer;
    private Cluster pravegaServiceCluster = null;
    private Duration minRebalanceInterval;
    private final Semaphore hostsChange = new Semaphore(0);
    private final Semaphore suspendMonitor = new Semaphore(0);
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final HostContainerMetrics hostContainerMetrics = new HostContainerMetrics();

    public SegmentMonitorLeader(HostControllerStore hostStore, ContainerBalancer balancer, int minRebalanceInterval) {
        Preconditions.checkNotNull((Object)hostStore, (Object)"hostStore");
        Preconditions.checkNotNull((Object)balancer, (Object)"balancer");
        Preconditions.checkArgument((minRebalanceInterval >= 0 ? 1 : 0) != 0, (Object)"minRebalanceInterval should not be negative");
        this.hostStore = hostStore;
        this.segBalancer = balancer;
        this.minRebalanceInterval = Duration.ofSeconds(minRebalanceInterval);
    }

    public void suspend() {
        this.suspended.set(true);
    }

    public void resume() {
        if (this.suspended.compareAndSet(true, false)) {
            this.suspendMonitor.release();
        }
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            log.info("Obtained leadership to monitor the Host to Segment Container Mapping");
            this.hostsChange.release();
            this.pravegaServiceCluster = new ClusterZKImpl(client, "hosts");
            this.pravegaServiceCluster.addListener((type, host) -> {
                switch (type) {
                    case HOST_ADDED: 
                    case HOST_REMOVED: {
                        log.info("Received event: {} for host: {}. Wake up leader for rebalancing", (Object)type, (Object)host);
                        this.hostsChange.release();
                        break;
                    }
                    case ERROR: {
                        log.info("Received error event when monitoring the pravega host cluster, ignoring...");
                    }
                }
            });
            while (true) {
                try {
                    while (true) {
                        if (this.suspended.get()) {
                            log.info("Monitor is suspended, waiting for notification to resume");
                            this.suspendMonitor.acquire();
                            log.info("Resuming monitor");
                        }
                        this.hostsChange.acquire();
                        log.info("Received rebalance event");
                        this.waitForRebalance();
                        this.hostsChange.drainPermits();
                        this.triggerRebalance();
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Leadership interrupted, releasing monitor thread");
                    this.pravegaServiceCluster.close();
                    throw e;
                }
                catch (Exception e) {
                    if (this.suspended.get()) continue;
                    log.warn("Failed to perform rebalancing, relinquishing leadership");
                    this.pravegaServiceCluster.close();
                    throw e;
                }
                break;
            }
        }
    }

    private void waitForRebalance() throws InterruptedException {
        log.info("Waiting for {} seconds before attempting to rebalance", (Object)this.minRebalanceInterval.getSeconds());
        Thread.sleep(this.minRebalanceInterval.toMillis());
    }

    private void triggerRebalance() throws IOException {
        try {
            Map<Host, Set<Integer>> newMapping = this.segBalancer.rebalance(this.hostStore.getHostContainersMap(), this.pravegaServiceCluster.getClusterMembers());
            Map<Host, Set<Integer>> oldMapping = this.hostStore.getHostContainersMap();
            this.hostStore.updateHostContainersMap(newMapping);
            this.hostContainerMetrics.updateHostContainerMetrics(oldMapping, newMapping);
        }
        catch (ClusterException e) {
            throw new IOException(e);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        log.info("Zookeeper connection state changed to: " + newState.toString());
    }
}

