/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.metrics;

import com.google.common.base.Preconditions;
import io.pravega.controller.metrics.AbstractControllerMetrics;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.OpStatsLogger;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;

public final class StreamMetrics
extends AbstractControllerMetrics {
    private static final AtomicReference<StreamMetrics> INSTANCE = new AtomicReference();
    private final OpStatsLogger createStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.created_latency_ms", new String[0]);
    private final OpStatsLogger deleteStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.deleted_latency_ms", new String[0]);
    private final OpStatsLogger sealStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.sealed_latency_ms", new String[0]);
    private final OpStatsLogger updateStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.updated_latency_ms", new String[0]);
    private final OpStatsLogger addReaderGroupLatency;
    private final OpStatsLogger truncateStreamLatency = STATS_LOGGER.createStats("pravega.controller.stream.truncated_latency_ms", new String[0]);
    private final OpStatsLogger deleteReaderGroupLatency;
    private final OpStatsLogger updateReaderGroupLatency;
    private final OpStatsLogger updateSubscriberLatency;
    private final OpStatsLogger createKeyValueTableLatency;
    private final OpStatsLogger deleteKeyValueTableLatency;
    private final OpStatsLogger createScopeLatency;
    private final OpStatsLogger deleteScopeLatency;

    private StreamMetrics() {
        this.addReaderGroupLatency = STATS_LOGGER.createStats("pravega.controller.stream.create_reader_group_latency_ms", new String[0]);
        this.deleteReaderGroupLatency = STATS_LOGGER.createStats("pravega.controller.stream.delete_reader_group_latency_ms", new String[0]);
        this.createScopeLatency = STATS_LOGGER.createStats("pravega.controller.scope.created_latency_ms", new String[0]);
        this.deleteScopeLatency = STATS_LOGGER.createStats("pravega.controller.scope.deleted_latency_ms", new String[0]);
        this.createKeyValueTableLatency = STATS_LOGGER.createStats("pravega.controller.kvtable.created_latency_ms", new String[0]);
        this.deleteKeyValueTableLatency = STATS_LOGGER.createStats("pravega.controller.kvtable.deleted_latency_ms", new String[0]);
        this.updateSubscriberLatency = STATS_LOGGER.createStats("pravega.controller.stream.update_subscriber_streamcut_latency_ms", new String[0]);
        this.updateReaderGroupLatency = STATS_LOGGER.createStats("pravega.controller.stream.update_reader_group_latency_ms", new String[0]);
    }

    public static synchronized void initialize() {
        if (INSTANCE.get() == null) {
            INSTANCE.set(new StreamMetrics());
        }
    }

    public static StreamMetrics getInstance() {
        Preconditions.checkState((INSTANCE.get() != null ? 1 : 0) != 0, (Object)"You need call initialize before using this class.");
        return INSTANCE.get();
    }

    public void createKeyValueTable(String scope, String kvtName, int minNumSegments, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.kvtable.created", 1L, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.kvtable.segments.count", (Number)minNumSegments, MetricsTags.streamTags((String)scope, (String)kvtName));
        this.createKeyValueTableLatency.reportSuccessValue(latency.toMillis());
    }

    public void createKeyValueTableFailed(String scope, String kvtName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.kvtable.create_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.kvtable.create_failed", 1L, MetricsTags.streamTags((String)scope, (String)kvtName));
    }

    public void deleteKeyValueTable(String scope, String kvtName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.kvtable.deleted", 1L, new String[0]);
        this.deleteKeyValueTableLatency.reportSuccessValue(latency.toMillis());
    }

    public void deleteKeyValueTableFailed(String scope, String kvtName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.kvtable.delete_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.kvtable.delete_failed", 1L, MetricsTags.streamTags((String)scope, (String)kvtName));
    }

    public void createStream(String scope, String streamName, int minNumSegments, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.created", 1L, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.transactions.opened", (Number)0, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segments.count", (Number)minNumSegments, MetricsTags.streamTags((String)scope, (String)streamName));
        this.createStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void createScope(Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.scope.created", 1L, new String[0]);
        this.createScopeLatency.reportSuccessValue(latency.toMillis());
    }

    public void createStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.create_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.create_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void createScopeFailed(String scope) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.scope.create_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.scope.create_failed", 1L, MetricsTags.streamTags((String)scope, (String)""));
    }

    public void deleteStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.deleted", 1L, new String[0]);
        this.deleteStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void deleteScope(Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.scope.deleted", 1L, new String[0]);
        this.deleteScopeLatency.reportSuccessValue(latency.toMillis());
    }

    public void deleteStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.delete_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.delete_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void deleteScopeFailed(String scope) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.scope.delete_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.scope.delete_failed", 1L, MetricsTags.streamTags((String)scope, (String)""));
    }

    public void sealStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.sealed", 1L, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.transactions.opened", (Number)0, MetricsTags.streamTags((String)scope, (String)streamName));
        this.sealStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void sealStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.seal_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.seal_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void updateStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.updated"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.updated", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.updateStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void updateStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.update_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.update_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void createReaderGroup(String scope, String rgName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.create_reader_group"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.create_reader_group", 1L, MetricsTags.readerGroupTags((String)scope, (String)rgName));
        this.addReaderGroupLatency.reportSuccessValue(latency.toMillis());
    }

    public void createReaderGroupFailed(String scope, String rgName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.create_reader_group_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.create_reader_group_failed", 1L, MetricsTags.readerGroupTags((String)scope, (String)rgName));
    }

    public void updateReaderGroup(String scope, String rgName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.update_reader_group"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.update_reader_group", 1L, MetricsTags.readerGroupTags((String)scope, (String)rgName));
        this.updateReaderGroupLatency.reportSuccessValue(latency.toMillis());
    }

    public void updateReaderGroupFailed(String scope, String rgName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.update_reader_group_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.update_reader_group_failed", 1L, MetricsTags.readerGroupTags((String)scope, (String)rgName));
    }

    public void deleteReaderGroup(String scope, String rgName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.delete_reader_group"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.delete_reader_group", 1L, MetricsTags.readerGroupTags((String)scope, (String)rgName));
        this.deleteReaderGroupLatency.reportSuccessValue(latency.toMillis());
    }

    public void deleteReaderGroupFailed(String scope, String rgName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.delete_reader_group_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.delete_reader_group_failed", 1L, MetricsTags.readerGroupTags((String)scope, (String)rgName));
    }

    public void updateTruncationSC(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.update_subscriber_streamcut"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.update_subscriber_streamcut", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.updateSubscriberLatency.reportSuccessValue(latency.toMillis());
    }

    public void updateTruncationSCFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.update_subscriber_streamcut_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.update_subscriber_streamcut_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public void truncateStream(String scope, String streamName, Duration latency) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.truncated"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.truncated", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
        this.truncateStreamLatency.reportSuccessValue(latency.toMillis());
    }

    public void truncateStreamFailed(String scope, String streamName) {
        DYNAMIC_LOGGER.incCounterValue(MetricsNames.globalMetricName((String)"pravega.controller.stream.truncate_failed"), 1L, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.controller.stream.truncate_failed", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static void reportRetentionEvent(String scope, String streamName) {
        DYNAMIC_LOGGER.recordMeterEvents("pravega.controller.retention.frequency", 1L, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static void reportActiveSegments(String scope, String streamName, int numSegments) {
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segments.count", (Number)numSegments, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static void reportSegmentSplitsAndMerges(String scope, String streamName, long splits, long merges) {
        DYNAMIC_LOGGER.reportGaugeValue(MetricsNames.globalMetricName((String)"pravega.controller.segment.splits"), (Number)splits, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segment.splits", (Number)splits, MetricsTags.streamTags((String)scope, (String)streamName));
        DYNAMIC_LOGGER.reportGaugeValue(MetricsNames.globalMetricName((String)"pravega.controller.segment.merges"), (Number)merges, new String[0]);
        DYNAMIC_LOGGER.reportGaugeValue("pravega.controller.segment.merges", (Number)merges, MetricsTags.streamTags((String)scope, (String)streamName));
    }

    public static synchronized void reset() {
        StreamMetrics old = INSTANCE.get();
        if (old != null) {
            old.createStreamLatency.close();
            old.deleteStreamLatency.close();
            old.sealStreamLatency.close();
            old.updateStreamLatency.close();
            old.truncateStreamLatency.close();
            old.addReaderGroupLatency.close();
            old.deleteReaderGroupLatency.close();
            old.updateSubscriberLatency.close();
            old.createScopeLatency.close();
            old.deleteScopeLatency.close();
        }
        INSTANCE.set(new StreamMetrics());
    }
}

